/*
 * Decompiled with CFR 0.152.
 */
package org.somox.analyzer.simplemodelanalyzer.builder.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.PrimitiveDataType;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceRepository;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;

public class DefaultResourceEnvironment {
    private static final String RESOURCETYPE_URI = "pathmap://PCM_MODELS/Palladio.resourcetype";
    private static final String PRIMITIVETYPES_URI = "pathmap://PCM_MODELS/PrimitiveTypes.repository";
    private static ResourceEnvironment resourceEnvironment;
    private static ResourceRepository resourceRepository;
    private static Repository primitiveTypesRepository;

    private DefaultResourceEnvironment() {
    }

    public static ResourceEnvironment getDefaultResourceEnvironment() {
        if (resourceEnvironment == null) {
            resourceEnvironment = DefaultResourceEnvironment.createDefaultResourceEnvironment();
        }
        return resourceEnvironment;
    }

    private static Map<String, PrimitiveDataType> getPrimitiveDataTypes() {
        HashMap<String, PrimitiveDataType> primitives = new HashMap<String, PrimitiveDataType>();
        if (primitiveTypesRepository == null) {
            primitiveTypesRepository = DefaultResourceEnvironment.getPrimitiveTypesRepository();
        }
        for (DataType d : primitiveTypesRepository.getDataTypes__Repository()) {
            if (!(d instanceof PrimitiveDataType)) continue;
            PrimitiveDataType pdt = (PrimitiveDataType)d;
            primitives.put(pdt.getType().getName(), pdt);
        }
        return primitives;
    }

    public static PrimitiveDataType getPrimitiveDataTypeInteger() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("INT");
    }

    public static PrimitiveDataType getPrimitiveDataTypeDouble() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("DOUBLE");
    }

    public static PrimitiveDataType getPrimitiveDataTypeBool() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("BOOL");
    }

    public static PrimitiveDataType getPrimitiveDataTypeChar() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("CHAR");
    }

    public static PrimitiveDataType getPrimitiveDataTypeByte() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("BYTE");
    }

    public static PrimitiveDataType getPrimitiveDataTypeString() {
        return DefaultResourceEnvironment.getPrimitiveDataTypes().get("STRING");
    }

    public static ResourceEnvironment createDefaultResourceEnvironment() {
        ResourceenvironmentFactory factory = ResourceenvironmentPackage.eINSTANCE.getResourceenvironmentFactory();
        ResourceEnvironment resourceEnvironment = factory.createResourceEnvironment();
        resourceEnvironment.setEntityName("SoMoX Default ResourceEnvironment");
        ResourceContainer container = factory.createResourceContainer();
        container.setEntityName("SoMoX Default ResourceContainer");
        ProcessingResourceSpecification spec = factory.createProcessingResourceSpecification();
        spec.setActiveResourceType_ActiveResourceSpecification(DefaultResourceEnvironment.getCPUProcessingResourceType());
        spec.setNumberOfReplicas(1);
        spec.setSchedulingPolicy(DefaultResourceEnvironment.getProcessorSharingSchedulingPolicy());
        PCMRandomVariable processingRate = CoreFactory.eINSTANCE.createPCMRandomVariable();
        processingRate.setSpecification("1");
        spec.setProcessingRate_ProcessingResourceSpecification(processingRate);
        container.getActiveResourceSpecifications_ResourceContainer().add((Object)spec);
        resourceEnvironment.getResourceContainer_ResourceEnvironment().add((Object)container);
        return resourceEnvironment;
    }

    protected static SchedulingPolicy getProcessorSharingSchedulingPolicy() {
        return (SchedulingPolicy)DefaultResourceEnvironment.getResourceRepository().getSchedulingPolicies__ResourceRepository().get(0);
    }

    public static ProcessingResourceType getCPUProcessingResourceType() {
        return (ProcessingResourceType)DefaultResourceEnvironment.getResourceRepository().getAvailableResourceTypes_ResourceRepository().get(0);
    }

    public static Repository getPrimitiveTypesRepository() {
        if (primitiveTypesRepository != null) {
            return primitiveTypesRepository;
        }
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("repository", new XMIResourceFactoryImpl());
        URI uri = URI.createURI((String)PRIMITIVETYPES_URI);
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        primitiveTypesRepository = (Repository)resource.getContents().get(0);
        return primitiveTypesRepository;
    }

    protected static ResourceRepository getResourceRepository() {
        if (resourceRepository != null) {
            return resourceRepository;
        }
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("resourcetype", new XMIResourceFactoryImpl());
        URI uri = URI.createURI((String)RESOURCETYPE_URI);
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(uri, true);
        resourceRepository = (ResourceRepository)resource.getContents().get(0);
        return resourceRepository;
    }
}

