/*
 * Decompiled with CFR 0.152.
 */
package org.somox.filter;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.gmt.modisco.java.EnumDeclaration;
import org.eclipse.gmt.modisco.java.MethodDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.VisibilityKind;
import org.somox.filter.BaseFilter;
import org.somox.kdmhelper.KDMHelper;

public class DataObjectFilter
extends BaseFilter<Type> {
    private static final Logger logger = Logger.getLogger(DataObjectFilter.class);
    private final String[] filteredPrefixes = new String[]{"is", "get", "set", "equals", "hashcode"};

    @Override
    public boolean passes(Type object) {
        if (object instanceof EnumDeclaration) {
            return true;
        }
        List allMethods = KDMHelper.getMethods((Type)object);
        for (MethodDeclaration m : allMethods) {
            if (!KDMHelper.isModifierOfKind((MethodDeclaration)m, (VisibilityKind)VisibilityKind.PUBLIC) || !this.isNotGetterOrSetter(m)) continue;
            return true;
        }
        logger.debug((Object)("Removed GAST Class " + object.getName() + " from component candidates as it is a datatype"));
        return false;
    }

    private boolean isNotGetterOrSetter(MethodDeclaration m) {
        boolean result = false;
        String simpleMethodName = m.getName().toLowerCase();
        String[] stringArray = this.filteredPrefixes;
        int n = this.filteredPrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            result |= simpleMethodName.startsWith(prefix);
            ++n2;
        }
        return !result;
    }
}

