/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.registry;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.somox.metrics.Activator;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.dsl.metricDSL.Metric;
import org.somox.metrics.dsl.metricDSL.MetricModel;
import org.somox.metrics.dslvisitor.DSLConfigurationVisitor;

public class MetricsRegistry {
    private static final String METRIC_CLASS_ATTRIBUTE = "class";
    private static final String METRIC_ATTRIBUTE_NAME = "metric";
    private static final String METRIC_FORMULA_ATTRIBUTE_NAME = "metricformula";
    private static final String METRIC_DEFINITION_ATTRIBUTE_NAME = "metric_definition";
    private static final String ORG_SOMOX_CORE_METRIC_EXTENSION_ID = "org.somox.core.metric";
    private static final Logger LOG = Logger.getLogger(MetricsRegistry.class);
    private static final Map<MetricID, IMetric> registeredMetrics = Collections.unmodifiableMap(MetricsRegistry.internalGetRegisteredMetrics());

    public static final Map<MetricID, IMetric> getRegisteredMetrics() {
        return registeredMetrics;
    }

    private static Map<MetricID, IMetric> internalGetRegisteredMetrics() {
        IConfigurationElement metricExtension;
        IConfigurationElement[] metricExtensions;
        HashMap<MetricID, IMetric> allMetrics = new HashMap<MetricID, IMetric>();
        IConfigurationElement[] iConfigurationElementArray = metricExtensions = Platform.getExtensionRegistry().getConfigurationElementsFor(ORG_SOMOX_CORE_METRIC_EXTENSION_ID);
        int n = metricExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            metricExtension = iConfigurationElementArray[n2];
            if (metricExtension.getName().equals(METRIC_ATTRIBUTE_NAME)) {
                MetricsRegistry.parseBasicMetric(allMetrics, metricExtension);
            }
            ++n2;
        }
        iConfigurationElementArray = metricExtensions;
        n = metricExtensions.length;
        n2 = 0;
        while (n2 < n) {
            metricExtension = iConfigurationElementArray[n2];
            if (metricExtension.getName().equals(METRIC_FORMULA_ATTRIBUTE_NAME)) {
                MetricsRegistry.parseMetricDefinitionModel(allMetrics, metricExtension);
            }
            ++n2;
        }
        return allMetrics;
    }

    private static void parseMetricDefinitionModel(Map<MetricID, IMetric> allMetrics, IConfigurationElement metricExtension) {
        String resourcePath = metricExtension.getAttribute(METRIC_DEFINITION_ATTRIBUTE_NAME);
        MetricModel metricDefinitions = MetricsRegistry.loadResource(String.valueOf(metricExtension.getContributor().getName()) + "/" + resourcePath);
        if (metricDefinitions != null) {
            for (Metric metricDefinition : metricDefinitions.getMetrics()) {
                IMetric newMetric = MetricsRegistry.parseMetricDefintion(allMetrics, metricDefinition);
                if (newMetric != null) {
                    if (allMetrics.containsKey(newMetric.getMID())) continue;
                    allMetrics.put(newMetric.getMID(), newMetric);
                    continue;
                }
                Activator.getPlugin().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Unable to parse metric from metric defintion, ID was " + metricDefinition.getName()));
            }
        } else {
            Activator.getPlugin().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Failed to load a metric definition from a metric DSL file. Some metrics mightbe unavailable and further errors may occur during SoMoX runs"));
        }
    }

    private static void parseBasicMetric(Map<MetricID, IMetric> allMetrics, IConfigurationElement metricExtension) {
        Object o = null;
        try {
            o = metricExtension.createExecutableExtension(METRIC_CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Warning: Specified Analyzer Metric " + metricExtension.getName() + " cannot be loaded."));
            throw new RuntimeException("Eclipse core failure", e);
        }
        if (o == null || !(o instanceof IMetric)) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", "Warning: Specified Analyzer Metric " + metricExtension.getName() + " cannot be loaded."));
            throw new RuntimeException("Eclipse core failure. Could not instanciate metric", null);
        }
        allMetrics.put(((IMetric)o).getMID(), (IMetric)o);
    }

    private static IMetric parseMetricDefintion(Map<MetricID, IMetric> allMetrics, Metric metric) {
        LOG.info((Object)("Parsing metric definition " + metric.getName()));
        return (IMetric)new DSLConfigurationVisitor(allMetrics).doSwitch((EObject)metric);
    }

    private static MetricModel loadResource(String resourcePath) {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createPlatformPluginURI((String)resourcePath, (boolean)true));
        try {
            r.load(new HashMap());
        }
        catch (IOException e) {
            Activator.getPlugin().getLog().log((IStatus)new Status(4, "de.uka.ipd.sdq.somox.metrics", 0, "Failed to load metrics from stored DSL", (Throwable)e));
            throw new RuntimeException(e);
        }
        return (MetricModel)r.getContents().get(0);
    }
}

