/*
 * Decompiled with CFR 0.152.
 */
package org.somox.metrics.structure;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.Type;
import org.jgrapht.DirectedGraph;
import org.somox.configuration.SoMoXConfiguration;
import org.somox.kdmhelper.KDMHelper;
import org.somox.kdmhelper.metamodeladdition.Root;
import org.somox.metrics.ClusteringRelation;
import org.somox.metrics.IMetric;
import org.somox.metrics.MetricID;
import org.somox.metrics.abstractmetrics.AbstractMetric;
import org.somox.metrics.helper.ClassAccessGraphEdge;
import org.somox.metrics.helper.ComponentToImplementingClassesHelper;
import org.somox.metrics.structure.SliceLayerArchitectureQuality;

public class SubsystemComponent
extends AbstractMetric {
    public static final MetricID METRIC_ID = new MetricID("org.somox.metrics.SubsystemComponent");
    private IMetric sliceArchitectureMetric = null;

    @Override
    public void initialize(Root gastModel, SoMoXConfiguration somoxConfiguration, Map<MetricID, IMetric> allMetrics, DirectedGraph<Type, ClassAccessGraphEdge> accessGraph, ComponentToImplementingClassesHelper componentToImplementingClassesHelper) {
        super.initialize(gastModel, somoxConfiguration, allMetrics, accessGraph, componentToImplementingClassesHelper);
        this.sliceArchitectureMetric = this.getMetric(allMetrics, SliceLayerArchitectureQuality.METRIC_ID);
    }

    @Override
    protected void internalComputeDirected(ClusteringRelation relationToCompute) {
        Set<Type> classes2;
        Set<Type> classes1 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getSourceComponent());
        Package prefixPackage = this.computePrefix(classes1, classes2 = this.getComponentToClassHelper().deriveImplementingClasses(relationToCompute.getTargetComponent()));
        if (prefixPackage == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        EList slices = prefixPackage.getOwnedPackages();
        EList layers = null;
        String subLayer = null;
        int max = 0;
        for (Package current : slices) {
            if (current.getOwnedPackages().size() < max) continue;
            layers = current.getOwnedPackages();
            max = layers.size();
        }
        if (max == 0 || layers.size() == 0 || layers == null) {
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        Package currentPackage = null;
        block1: for (Type currentElement : classes1) {
            currentPackage = KDMHelper.getSurroundingPackage((Type)currentElement);
            if (currentPackage == null) continue;
            if (subLayer == null) {
                for (Package slicePackage : slices) {
                    if (!KDMHelper.computeFullQualifiedName((ASTNode)currentPackage).startsWith(KDMHelper.computeFullQualifiedName((ASTNode)slicePackage))) continue;
                    for (Package layerPackage : layers) {
                        if (!KDMHelper.computeFullQualifiedName((ASTNode)currentPackage).startsWith(String.valueOf(KDMHelper.computeFullQualifiedName((ASTNode)slicePackage)) + "." + layerPackage.getName())) continue;
                        subLayer = String.valueOf(KDMHelper.computeFullQualifiedName((ASTNode)slicePackage)) + "." + layerPackage.getName();
                        continue block1;
                    }
                    continue block1;
                }
                continue;
            }
            if (KDMHelper.computeFullQualifiedName((ASTNode)currentPackage).startsWith(subLayer)) continue;
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        block4: for (Type currentElement : classes2) {
            currentPackage = KDMHelper.getSurroundingPackage((Type)currentElement);
            if (currentPackage == null) continue;
            if (subLayer == null) {
                for (Package slicePackage : slices) {
                    if (!KDMHelper.computeFullQualifiedName((ASTNode)currentPackage).startsWith(KDMHelper.computeFullQualifiedName((ASTNode)slicePackage))) continue;
                    for (Package layerPackage : layers) {
                        if (!KDMHelper.computeFullQualifiedName((ASTNode)currentPackage).startsWith(String.valueOf(KDMHelper.computeFullQualifiedName((ASTNode)slicePackage)) + "." + layerPackage.getName())) continue;
                        subLayer = String.valueOf(KDMHelper.computeFullQualifiedName((ASTNode)slicePackage)) + "." + layerPackage.getName();
                        continue block4;
                    }
                    continue block4;
                }
                continue;
            }
            if (KDMHelper.computeFullQualifiedName((ASTNode)currentPackage).startsWith(subLayer)) continue;
            relationToCompute.setResultMetric(this.getMID(), 0.0);
            return;
        }
        this.sliceArchitectureMetric.computeDirected(relationToCompute);
        assert (relationToCompute.getResult().containsKey(this.sliceArchitectureMetric.getMID()));
        double slaq = relationToCompute.getResult().get(this.sliceArchitectureMetric.getMID());
        relationToCompute.setResultMetric(this.getMID(), slaq);
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public MetricID getMID() {
        return METRIC_ID;
    }

    private Package computePrefix(Set<Type> elements1, Set<Type> elements2) {
        Package prefix = null;
        LinkedList<Type> elementsLeft = new LinkedList<Type>();
        elementsLeft.addAll(elements1);
        elementsLeft.addAll(elements2);
        ListIterator iterator = elementsLeft.listIterator();
        while (iterator.hasNext()) {
            Type current = (Type)iterator.next();
            if (prefix == null && KDMHelper.getSurroundingPackage((Type)current) != null) {
                prefix = KDMHelper.getSurroundingPackage((Type)current);
            }
            if (prefix == null || KDMHelper.getSurroundingPackage((Type)current) == null || KDMHelper.computeFullQualifiedName((ASTNode)current).startsWith(KDMHelper.computeFullQualifiedName((ASTNode)prefix))) continue;
            if ((prefix = prefix.getPackage()) == null) {
                return null;
            }
            iterator = elementsLeft.listIterator();
        }
        return prefix;
    }

    @Override
    public boolean isNormalised() {
        return true;
    }
}

