/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.core.ui.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.storydriven.core.ui.IExpressionEditor;

public class ExpressionEditorUtil {
    private static Map<String, IExpressionEditor> editors;

    public static IExpressionEditor getEditor(String language, String version) {
        return ExpressionEditorUtil.getEditors().get(ExpressionEditorUtil.getKey(language, version));
    }

    private static String getKey(String language, String version) {
        return String.valueOf(language) + version;
    }

    private static Map<String, IExpressionEditor> getEditors() {
        if (editors == null) {
            IConfigurationElement[] configurationElements;
            editors = new HashMap<String, IExpressionEditor>();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.storydriven.core.ui.expressionEditor");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String language = ce.getAttribute("language");
                String version = ce.getAttribute("version");
                try {
                    IExpressionEditor editor = (IExpressionEditor)ce.createExecutableExtension("class");
                    editors.put(ExpressionEditorUtil.getKey(language, version), editor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return editors;
    }
}

