/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String ID = "org.storydriven.storydiagrams.diagram.custom";
    private static Activator instance;

    public void logError(String message) {
        this.logError(message, null);
    }

    public void logError(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(4, message, exception);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(1, message, exception);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.addImages();
    }

    private void addImages() {
        this.addImage("icons/controls/add.png");
        this.addImage("icons/controls/remove.png");
        this.addImage("icons/controls/configure.png");
        this.addImage("icons/controls/shortcut.png");
        this.addImage("icons/controls/up.png");
        this.addImage("icons/controls/down.png");
        this.addImage("icons/controls/search.png");
        this.addImage("icons/controls/warning.png");
        this.addImage("icons/elements/ecore/EAnnotation.png");
        this.addImage("icons/elements/ecore/EAttribute.png");
        this.addImage("icons/elements/ecore/EClass.png");
        this.addImage("icons/elements/ecore/EDataType.png");
        this.addImage("icons/elements/ecore/EEnum.png");
        this.addImage("icons/elements/ecore/EEnumLiteral.png");
        this.addImage("icons/elements/ecore/EOperation.png");
        this.addImage("icons/elements/ecore/EPackage.png");
        this.addImage("icons/elements/ecore/EPackage_linked.png");
        this.addImage("icons/elements/ecore/EPackage_plugin.png");
        this.addImage("icons/elements/ecore/EPackage_workspace.png");
        this.addImage("icons/elements/ecore/EParameter_in.png");
        this.addImage("icons/elements/ecore/EParameter_in_referenced.png");
        this.addImage("icons/elements/ecore/EParameter_out.png");
        this.addImage("icons/elements/ecore/EParameter_out_referenced.png");
        this.addImage("icons/elements/ecore/EReference.png");
        this.addImage("icons/elements/ecore/EStringToStringMapEntry.png");
        this.addImage("icons/banners/select_eclass.png");
        this.addImage("icons/banners/select_edatatype.png");
        this.addImage("icons/banners/add_epackage_uri.png");
        this.addImage("icons/banners/add_epackage_workspace.png");
        this.addImage("icons/banners/configure_in_parameter.png");
        this.addImage("icons/banners/configure_out_parameter.png");
        this.addImage("icons/banners/load_resource_workspace.png");
        this.addImage("icons/banners/select_eclass.png");
        this.addImage("icons/banners/select_edatatype.png");
        this.addImage("icons/banners/select_precondition.png");
    }

    private void addImage(String path) {
        ImageDescriptor desc = Activator.imageDescriptorFromPlugin((String)this.getID(), (String)path);
        if (desc != null) {
            this.getImageRegistry().put(path, desc);
        } else {
            this.logWarning("The image under '" + path + "' could not be cached. It probably does not exist.");
        }
    }

    public void logWarning(String message) {
        this.logWarning(message, null);
    }

    public void logWarning(String message, Throwable exception) {
        if (message == null && exception != null) {
            message = exception.getMessage();
        }
        this.log(2, message, exception);
    }

    private void log(int severity, String message, Throwable throwable) {
        this.getLog().log((IStatus)new Status(severity, this.getID(), message, throwable));
    }

    protected String getID() {
        return ID;
    }

    public static Activator getInstance() {
        return instance;
    }

    public Image getImage(String key) {
        if (this.getImageRegistry().get(key) == null) {
            return ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.getImageRegistry().get(key);
    }

    public ImageDescriptor getImageDescriptor(String key) {
        if (this.getImageRegistry().getDescriptor(key) == null) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return this.getImageRegistry().getDescriptor(key);
    }

    public void stop(BundleContext context) throws Exception {
        instance = null;
        super.stop(context);
    }
}

