/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom;

import java.util.Collection;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.ExpressionsPackage;
import org.storydriven.core.expressions.TextualExpression;
import org.storydriven.core.expressions.util.ExpressionUtils;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.ui.SourceViewerProvider;

public class EditExpressionDialog
extends Dialog {
    private LanguageSelectionWidget languageChoosingWidget;
    protected ISourceViewer currentSourceViewer;
    private ISourceViewer defaultSourceViewer;
    protected static final String DIALOG_TITLE = "Edit Expression";
    protected static final int DIALOG_WIDTH = 500;
    protected static final int DIALOG_HEIGHT = 400;
    protected static final int DIALOG_PADDING = 10;
    private static final int SOURCEVIEWER_HEIGHT = 300;
    private static final int RADIO_BUTTON_THRESHOLD_LANGUAGES = 3;
    private static final int RADIO_BUTTON_THRESHOLD_VERSIONS = 3;
    private static final String DEFAULT_LANGUAGE = "OCL";
    public static final String EXPRESSION_SOURCE_VIEWER_EXTENSION_POINT_ID = "org.storydriven.storydiagrams.diagram.custom.expressionSourceViewerExtension";
    public static final String EXPRESSION_LANGUAGES_LANGUAGE_ATTRIBUTE_NAME = "expressionLanguage";
    public static final String EXPRESSION_LANGUAGES_VERSION_ATTRIBUTE_NAME = "version";
    public static final String EXPRESSION_SOURCE_VIEWER_ATTRIBUTE_NAME = "sourceViewerProvider";
    private Map<String, SourceViewerProvider> sourceViewerProviders = new HashMap<String, SourceViewerProvider>();
    private HashMap<String, ISourceViewer> sourceViewers;
    private EClassifier contextClassifier;
    private EClassifier expectedReturnType;
    private EditingDomain editingDomain;
    private String originalText;
    private TextualExpression expression;
    private Activity activity;
    private Map<String, EClassifier> contextInformation;
    private Composite languageEditingArea;

    public EditExpressionDialog(Shell parent) {
        super(parent);
        this.initializeSourceViewerProviders();
    }

    private void initializeSourceViewerProviders() {
        if (Platform.getExtensionRegistry() != null) {
            IConfigurationElement[] configurationElements;
            this.sourceViewerProviders = new HashMap<String, SourceViewerProvider>();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPRESSION_SOURCE_VIEWER_EXTENSION_POINT_ID);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                String s = configurationElement.getAttribute(EXPRESSION_LANGUAGES_LANGUAGE_ATTRIBUTE_NAME);
                String v = configurationElement.getAttribute(EXPRESSION_LANGUAGES_VERSION_ATTRIBUTE_NAME);
                if (s != null && !"".equals(s) && v != null && !"".equals(v)) {
                    try {
                        this.sourceViewerProviders.put(s.concat(v), (SourceViewerProvider)configurationElement.createExecutableExtension(EXPRESSION_SOURCE_VIEWER_ATTRIBUTE_NAME));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        for (String aLanguage : ExpressionUtils.getAvailableExpressionLanguages()) {
            for (String aVersion : ExpressionUtils.getAvailableExpressionLanguageVersions((String)aLanguage)) {
                if (this.sourceViewerProviders.containsKey(aLanguage.concat(aVersion))) continue;
                this.sourceViewerProviders.put(aLanguage.concat(aVersion), new SourceViewerProvider());
            }
        }
    }

    public void create() {
        super.create();
    }

    public boolean close() {
        this.disposeSourceViewerProviders();
        return super.close();
    }

    public void setExpectedReturnType(EClassifier classifier) {
        this.expectedReturnType = classifier;
    }

    public void setChangeAttributeCommand(Command changeAttributeCommand, EditingDomain transactionalEditingDomain) {
        this.editingDomain = transactionalEditingDomain;
    }

    public void setContextInformation(Map<String, EClassifier> contextInformation) {
        this.contextInformation = contextInformation;
    }

    public void setExpression(TextualExpression expression) {
        this.expression = expression;
        this.originalText = expression.getExpressionText();
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    public Expression getExpression() {
        return this.expression;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(DIALOG_TITLE);
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new RowLayout(512));
        this.languageChoosingWidget = ExpressionUtils.getAmountLanguages() <= 3 && ExpressionUtils.getMaximumAmountVersions() <= 3 ? new LanguageSelectionRadioWidget(composite, 0) : new LanguageSelectionComboWidget(composite, 0);
        this.populateLanguageChoosingWidget(this.languageChoosingWidget);
        LanguageSelectedListener listener = new LanguageSelectedListener(){

            @Override
            public void languageSelected(LanguageSelectedEvent event) {
                EditExpressionDialog.this.changeSourceViewerTo(event.language, event.version);
            }

            @Override
            public void noLanguageSelected() {
                EditExpressionDialog.this.changeToDefaultSourceViewer();
            }
        };
        this.languageChoosingWidget.addLanguageSelectedListener(listener);
        Composite expectedReturnArea = new Composite(composite, 0);
        expectedReturnArea.setLayout((Layout)new RowLayout());
        Label expectedReturnLabel = new Label(expectedReturnArea, 0);
        expectedReturnLabel.setText("Expected return Value:");
        Label expectedReturnValueLabel = new Label(expectedReturnArea, 0);
        expectedReturnValueLabel.setText(this.getExpectedReturnString());
        this.languageEditingArea = new Composite(composite, 0);
        this.languageEditingArea.setLayout((Layout)new StackLayout());
        this.languageEditingArea.setLayoutData((Object)new RowData(500, 300));
        this.initializeSourceViewers();
        composite.layout(false);
        this.languageEditingArea.layout(false);
        this.adjustDefaultSourceViewer();
        return composite;
    }

    private void populateLanguageChoosingWidget(LanguageSelectionWidget alanguageChoosingWidget) {
        for (String aLanguage : ExpressionUtils.getAvailableExpressionLanguages()) {
            for (String aVersion : ExpressionUtils.getAvailableExpressionLanguageVersions((String)aLanguage)) {
                alanguageChoosingWidget.addLanguageWithVersion(aLanguage, aVersion);
            }
        }
    }

    private void initializeSourceViewers() {
        this.sourceViewers = new HashMap();
        if (this.contextInformation == null) {
            this.contextInformation = new LinkedHashMap<String, EClassifier>();
        }
        for (Map.Entry<String, SourceViewerProvider> svpEntry : this.sourceViewerProviders.entrySet()) {
            ISourceViewer sv = svpEntry.getValue().createSourceViewer(this.languageEditingArea, 2818, this.contextClassifier, this.contextInformation, this.originalText);
            this.sourceViewers.put(svpEntry.getKey(), sv);
            sv.getTextWidget().setVisible(false);
        }
        this.currentSourceViewer = this.defaultSourceViewer = new SourceViewerProvider().createSourceViewer(this.languageEditingArea, 2818, this.contextClassifier, this.contextInformation, this.originalText);
        this.currentSourceViewer.getTextWidget().setVisible(true);
        ((StackLayout)this.languageEditingArea.getLayout()).topControl = this.currentSourceViewer.getTextWidget();
        this.languageEditingArea.layout();
    }

    private void adjustDefaultSourceViewer() {
        if (ExpressionUtils.getAvailableExpressionLanguages().contains(DEFAULT_LANGUAGE)) {
            String availableVersion = (String)ExpressionUtils.getAvailableExpressionLanguageVersions((String)DEFAULT_LANGUAGE).get(0);
            this.languageChoosingWidget.setSelectedLanguage(DEFAULT_LANGUAGE, availableVersion);
            this.changeSourceViewerTo(DEFAULT_LANGUAGE, availableVersion);
        }
    }

    private void changeSourceViewerTo(String language, String version) {
        this.changeSourceViewerTo(language.concat(version));
    }

    private void changeSourceViewerTo(String languageKey) {
        if (this.sourceViewers.containsKey(languageKey)) {
            this.placeSourceViewer(this.sourceViewers.get(languageKey));
        } else {
            this.changeToDefaultSourceViewer();
        }
    }

    private void changeToDefaultSourceViewer() {
        this.placeSourceViewer(this.defaultSourceViewer);
    }

    private void placeSourceViewer(ISourceViewer nextSourceViewer) {
        String text = this.currentSourceViewer.getDocument().get();
        nextSourceViewer.getDocument().set(text);
        this.currentSourceViewer.getTextWidget().setVisible(false);
        ((StackLayout)this.languageEditingArea.getLayout()).topControl = nextSourceViewer.getTextWidget();
        nextSourceViewer.getTextWidget().setVisible(true);
        this.currentSourceViewer = nextSourceViewer;
        this.languageEditingArea.layout();
    }

    protected void okPressed() {
        if (this.expression != null) {
            EAttribute feature = ExpressionsPackage.Literals.TEXTUAL_EXPRESSION__LANGUAGE;
            Command command = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.expression, (Object)feature, (Object)this.getSelectedLanguage());
            feature = ExpressionsPackage.Literals.TEXTUAL_EXPRESSION__LANGUAGE_VERSION;
            command.chain(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.expression, (Object)feature, (Object)this.getSelectedVersion()));
            feature = ExpressionsPackage.Literals.TEXTUAL_EXPRESSION__EXPRESSION_TEXT;
            command.chain(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.expression, (Object)feature, (Object)this.currentSourceViewer.getDocument().get()));
            this.editingDomain.getCommandStack().execute(command);
        }
        super.okPressed();
    }

    private String getSelectedLanguage() {
        return this.languageChoosingWidget.getSelectedLanguage();
    }

    private String getSelectedVersion() {
        return this.languageChoosingWidget.getSelectedVersion();
    }

    protected Map<String, EClassifier> getContextInformation() {
        HashMap<String, EClassifier> contextInfos = new HashMap<String, EClassifier>();
        if (this.activity != null) {
            if (this.activity.getOwningOperation().getOperation() != null) {
                EClass thisClass = this.activity.getOwningOperation().getOperation().getEContainingClass();
                if (thisClass != null) {
                    contextInfos.put("this", (EClassifier)thisClass);
                }
                for (EParameter parameter : this.activity.getOwningOperation().getOperation().getEParameters()) {
                    if (parameter.getName() == null || "".equals(parameter) || parameter.getEType() == null) continue;
                    contextInfos.put(parameter.getName(), parameter.getEType());
                }
            }
            TreeIterator it = this.activity.eAllContents();
            while (it.hasNext()) {
                ObjectVariable spo;
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof ObjectVariable) || (spo = (ObjectVariable)eObject).getName() == null || "".equals(spo.getName()) || spo.getClassifier() == null) continue;
                contextInfos.put(spo.getName(), (EClassifier)spo.getClassifier());
            }
        }
        return contextInfos;
    }

    private void disposeSourceViewerProviders() {
        for (SourceViewerProvider svp : this.sourceViewerProviders.values()) {
            svp.dispose();
        }
    }

    private String getExpectedReturnString() {
        return this.expectedReturnType != null ? this.expectedReturnType.getName() : "null";
    }

    public class LanguageSelectedEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        public String language;
        public String version;

        public LanguageSelectedEvent(Object source, String language, String version) {
            super(source);
            this.language = language;
            this.version = version;
        }
    }

    public static interface LanguageSelectedListener
    extends EventListener {
        public void languageSelected(LanguageSelectedEvent var1);

        public void noLanguageSelected();
    }

    protected class LanguageSelectionComboWidget
    extends Composite
    implements LanguageSelectionWidget {
        Combo languageCombo;
        Combo versionCombo;
        Map<String, Collection<String>> languageDirectory;
        Vector<LanguageSelectedListener> languageSelectedListeners;

        public LanguageSelectionComboWidget(Composite parent, int style) {
            super(parent, style);
            this.languageSelectedListeners = new Vector();
            this.setLayout((Layout)new GridLayout(2, false));
            this.languageDirectory = new HashMap<String, Collection<String>>();
            Label languageLabel = new Label((Composite)this, 0);
            languageLabel.setText("Expression Language");
            this.createDialogLanguageCombo(this);
            Label versionLabel = new Label((Composite)this, 0);
            versionLabel.setText("Language Version");
            this.createDialogVersionCombo(this);
        }

        @Override
        public void addLanguageSelectedListener(LanguageSelectedListener listener) {
            this.languageSelectedListeners.addElement(listener);
        }

        @Override
        public void removeLanguageSelectedListener(LanguageSelectedListener listener) {
            this.languageSelectedListeners.removeElement(listener);
        }

        private void createDialogLanguageCombo(Composite mainArea) {
            this.languageCombo = new Combo(mainArea, 4);
            this.languageCombo.setLayoutData((Object)new GridData(4, 1, false, false));
            String[] items = new String[]{};
            this.languageCombo.setItems(items);
            this.languageCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    LanguageSelectionComboWidget.this.changeDialogVersionCombo(LanguageSelectionComboWidget.this.languageCombo.getItem(LanguageSelectionComboWidget.this.languageCombo.getSelectionIndex()));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    String[] emptyBuffer = new String[]{};
                    LanguageSelectionComboWidget.this.versionCombo.setItems(emptyBuffer);
                    LanguageSelectionComboWidget.this.noLanguageSelected();
                }
            });
        }

        private void changeDialogVersionCombo(String language) {
            String[] emptyBuffer = new String[]{};
            this.versionCombo.setItems(this.languageDirectory.get(language).toArray(emptyBuffer));
        }

        private void createDialogVersionCombo(Composite mainArea) {
            this.versionCombo = new Combo(mainArea, 4);
            this.versionCombo.setLayoutData((Object)new GridData(4, 2, false, false));
            String[] items = new String[]{};
            this.versionCombo.setItems(items);
            this.versionCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    LanguageSelectionComboWidget.this.languageSelected(LanguageSelectionComboWidget.this.languageCombo.getItem(LanguageSelectionComboWidget.this.languageCombo.getSelectionIndex()), LanguageSelectionComboWidget.this.versionCombo.getItem(LanguageSelectionComboWidget.this.versionCombo.getSelectionIndex()));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    LanguageSelectionComboWidget.this.noLanguageSelected();
                }
            });
        }

        protected void languageSelected(String language, String version) {
            LanguageSelectedEvent e = new LanguageSelectedEvent(this, language, version);
            for (LanguageSelectedListener listener : this.languageSelectedListeners) {
                listener.languageSelected(e);
            }
        }

        @Override
        public void setSelectedLanguage(String language, String version) {
            int index = this.searchStringInCombo(this.languageCombo, language);
            this.languageCombo.select(index);
            index = this.searchStringInCombo(this.versionCombo, version);
            this.languageCombo.select(index);
        }

        @Override
        public void addLanguageWithVersion(String language, String version) {
            if (!this.languageDirectory.containsKey(language)) {
                this.languageDirectory.put(language, new Vector());
                String[] items = new String[]{};
                this.languageCombo.setItems(this.languageDirectory.keySet().toArray(items));
            }
            this.languageDirectory.get(language).add(version);
        }

        private void noLanguageSelected() {
            for (LanguageSelectedListener listener : this.languageSelectedListeners) {
                listener.noLanguageSelected();
            }
        }

        private int searchStringInCombo(Combo aCombo, String searchString) {
            String[] items = aCombo.getItems();
            int numberOfItems = items.length;
            int searchedIndex = 0;
            int i = 0;
            while (i < numberOfItems && !items[searchedIndex].equals(searchString)) {
                ++searchedIndex;
                ++i;
            }
            return searchedIndex;
        }

        @Override
        public String getSelectedLanguage() {
            return this.languageCombo.getItem(this.languageCombo.getSelectionIndex());
        }

        @Override
        public String getSelectedVersion() {
            return this.versionCombo.getItem(this.versionCombo.getSelectionIndex());
        }
    }

    protected class LanguageSelectionRadioWidget
    extends Composite
    implements LanguageSelectionWidget {
        private Map<String, Collection<String>> languageDirectory;
        Composite languageRadioArea;
        Map<String, Composite> buttonRowList;
        Map<Button, String[]> buttonList;
        Vector<LanguageSelectedListener> languageSelectedListeners;

        public LanguageSelectionRadioWidget(Composite parent, int style) {
            super(parent, style);
            this.languageSelectedListeners = new Vector();
            this.setLayout((Layout)new RowLayout(512));
            this.languageDirectory = new HashMap<String, Collection<String>>();
            Label languageLabel = new Label((Composite)this, 0);
            languageLabel.setText("Expression Language");
            this.createDialogLanguageRadioButtons(this);
        }

        @Override
        public void addLanguageSelectedListener(LanguageSelectedListener listener) {
            this.languageSelectedListeners.addElement(listener);
        }

        @Override
        public void removeLanguageSelectedListener(LanguageSelectedListener listener) {
            this.languageSelectedListeners.removeElement(listener);
        }

        public void createDialogLanguageRadioButtons(Composite mainArea) {
            this.languageRadioArea = new Composite(mainArea, 0);
            this.languageRadioArea.setLayout((Layout)new RowLayout(512));
            this.buttonList = new HashMap<Button, String[]>();
            this.buttonRowList = new HashMap<String, Composite>();
        }

        protected void languageSelected(String language, String version) {
            LanguageSelectedEvent e = new LanguageSelectedEvent(this, language, version);
            for (LanguageSelectedListener listener : this.languageSelectedListeners) {
                listener.languageSelected(e);
            }
        }

        @Override
        public void setSelectedLanguage(String language, String version) {
            Button searchedButton = this.buttonList.keySet().iterator().next();
            for (Button aButton : this.buttonList.keySet()) {
                if (this.buttonList.get(aButton)[0].equals(language) && this.buttonList.get(aButton)[1].equals(version)) {
                    searchedButton = aButton;
                }
                aButton.setSelection(false);
            }
            searchedButton.setSelection(true);
        }

        @Override
        public void addLanguageWithVersion(String language, String version) {
            if (!this.languageDirectory.containsKey(language)) {
                this.languageDirectory.put(language, new Vector());
                Composite buttonRow = new Composite((Composite)this, 0);
                buttonRow.setLayout((Layout)new RowLayout());
                this.buttonRowList.put(language, buttonRow);
            }
            this.languageDirectory.get(language).add(version);
            Listener listener = new Listener(){

                public void handleEvent(Event e) {
                    for (Control control : LanguageSelectionRadioWidget.this.buttonList.keySet()) {
                        ((Button)control).setSelection(false);
                    }
                    ((Button)e.widget).setSelection(true);
                    LanguageSelectionRadioWidget.this.languageSelected(LanguageSelectionRadioWidget.this.buttonList.get((Button)e.widget)[0], LanguageSelectionRadioWidget.this.buttonList.get((Button)e.widget)[1]);
                }
            };
            Button tempButton = new Button(this.buttonRowList.get(language), 16);
            tempButton.setText(language.concat(" ").concat(version));
            tempButton.addListener(13, listener);
            String[] buttonInfo = new String[]{language, version};
            this.buttonList.put(tempButton, buttonInfo);
        }

        @Override
        public String getSelectedLanguage() {
            return this.getInfoOfSelectedButton(0);
        }

        @Override
        public String getSelectedVersion() {
            return this.getInfoOfSelectedButton(1);
        }

        private String getInfoOfSelectedButton(int indexOfInfo) {
            String resultString = "none";
            for (Button aButton : this.buttonList.keySet()) {
                if (!aButton.getSelection()) continue;
                resultString = this.buttonList.get(aButton)[indexOfInfo];
            }
            return resultString;
        }
    }

    public static interface LanguageSelectionWidget {
        public void addLanguageSelectedListener(LanguageSelectedListener var1);

        public void removeLanguageSelectedListener(LanguageSelectedListener var1);

        public void setSelectedLanguage(String var1, String var2);

        public void addLanguageWithVersion(String var1, String var2);

        public String getSelectedLanguage();

        public String getSelectedVersion();
    }
}

