/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.swt.graphics.Color;

public class EllipseDecoration
extends Ellipse
implements RotatableDecoration {
    private Polyline verticalLine;
    private Polyline horizontalLine;
    private Transform transform = new Transform();
    private Point location = new Point();
    private int diameter;

    public EllipseDecoration(IMapMode mapMode) {
        this.diameter = mapMode.DPtoLP(16);
        int radius = mapMode.DPtoLP(8);
        Dimension dimension = new Dimension(this.diameter, this.diameter);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.setClippingStrategy(new IClippingStrategy(){

            public Rectangle[] getClip(IFigure childFigure) {
                return new Rectangle[]{childFigure.getBounds()};
            }
        });
        PointList pl = new PointList(2);
        pl.addPoint(-radius, mapMode.DPtoLP(-2));
        pl.addPoint(-radius, mapMode.DPtoLP(-this.diameter + 2));
        this.verticalLine = new Polyline();
        this.verticalLine.setPoints(pl);
        this.verticalLine.setFill(true);
        this.add((IFigure)this.verticalLine);
        pl = new PointList(2);
        pl.addPoint(mapMode.DPtoLP(-2), -radius);
        pl.addPoint(mapMode.DPtoLP(-this.diameter + 2), -radius);
        this.horizontalLine = new Polyline();
        this.horizontalLine.setPoints(pl);
        this.horizontalLine.setFill(true);
        this.add((IFigure)this.horizontalLine);
        this.setFill(false);
        this.setLineWidth(1);
        this.setBackgroundColor(ColorConstants.white);
    }

    public void setBackgroundColor(Color fg) {
        super.setBackgroundColor(fg);
        this.verticalLine.setBackgroundColor(fg);
        this.horizontalLine.setBackgroundColor(fg);
    }

    public void setReferencePoint(Point ref) {
        Point pt = Point.SINGLETON;
        pt.setLocation(ref);
        pt.negate().translate(this.location);
        this.setRotation(Math.atan2(pt.y, pt.x));
    }

    public void setRotation(double angle) {
        this.bounds = null;
        this.transform.setRotation(angle);
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            int expand = (int)(this.getLineWidthFloat() / 2.0f);
            this.bounds = new Rectangle(this.location.x, this.location.y, this.diameter, this.diameter).getExpanded(expand, expand);
        }
        return this.bounds;
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        this.verticalLine.setForegroundColor(fg);
        this.horizontalLine.setForegroundColor(fg);
    }

    public void setLocation(Point p) {
        this.bounds = null;
        this.location.setLocation(p);
        this.transform.setTranslation((double)p.x, (double)p.y);
    }
}

