/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.storydriven.core.NamedElement;
import org.storydriven.storydiagrams.activities.ActivitiesPackage;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.custom.Activator;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.PrimitiveVariable;

public class ResourceManager {
    public static final String SOURCE_TYPES = "http://www.storydriven.org/storydiagrams/types";
    private static final Comparator<EClassifier> COMPARATOR_ECORE = new Comparator<EClassifier>(){

        @Override
        public int compare(EClassifier a, EClassifier b) {
            String nameA = String.valueOf(a.getName());
            String nameB = String.valueOf(b.getName());
            return nameA.compareTo(nameB);
        }
    };
    private static final Comparator<NamedElement> COMPARATOR_STORIES = new Comparator<NamedElement>(){

        @Override
        public int compare(NamedElement a, NamedElement b) {
            String nameA = String.valueOf(a.getName());
            String nameB = String.valueOf(b.getName());
            return nameA.compareTo(nameB);
        }
    };
    private static final Map<Activity, ResourceManager> instances = new LinkedHashMap<Activity, ResourceManager>();
    private final Collection<EPackage> ePackages;
    private final List<EClass> eClasses;
    private final List<EDataType> eDataTypes;
    private final List<Activity> activities;
    private Activity activity;
    private Adapter resourceSetAdapter;

    private ResourceManager(Activity activity) {
        this.activity = activity;
        this.ePackages = new HashSet<EPackage>();
        this.eClasses = new ArrayList<EClass>();
        this.eDataTypes = new ArrayList<EDataType>();
        this.activities = new ArrayList<Activity>();
        this.registerListeners();
        this.recollect();
    }

    private void registerListeners() {
        this.resourceSetAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                ResourceManager.this.recollect();
            }
        };
        this.activity.eResource().getResourceSet().eAdapters().add((Object)this.resourceSetAdapter);
        this.activity.eAdapters().add((Object)this.resourceSetAdapter);
        EAnnotation annotation = this.activity.getAnnotation(SOURCE_TYPES);
        if (annotation != null) {
            annotation.eAdapters().add((Object)this.resourceSetAdapter);
        }
    }

    public void recollect() {
        this.recollectActivities();
        this.recollectEcore();
    }

    private void recollectActivities() {
        this.activities.clear();
        EClass type = ActivitiesPackage.Literals.ACTIVITY;
        if (this.activity != null && this.activity.eResource() != null && this.activity.eResource().getResourceSet() != null) {
            ResourceSet resourceSet = this.activity.eResource().getResourceSet();
            for (Resource resource : resourceSet.getResources()) {
                for (EObject element : ResourceManager.getReachableObjectsOfType(resource, (EClassifier)type)) {
                    if (!(element instanceof Activity) || this.activities.contains(element)) continue;
                    this.activities.add((Activity)element);
                }
            }
            Collections.sort(this.activities, COMPARATOR_STORIES);
        }
    }

    private static Collection<EObject> getReachableObjectsOfType(Resource resource, EClassifier type) {
        LinkedList<EObject> queue = new LinkedList<EObject>();
        HashSet<EObject> visited = new HashSet<EObject>();
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator i = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof EObject)) continue;
            ResourceManager.collectReachableObjectsOfType(visited, queue, result, (EObject)object, type);
            i.prune();
        }
        while (!queue.isEmpty()) {
            EObject element = (EObject)queue.removeFirst();
            ResourceManager.collectReachableObjectsOfType(visited, queue, result, element, type);
        }
        return result;
    }

    private static void collectReachableObjectsOfType(Collection<EObject> visited, Deque<EObject> queue, Collection<EObject> result, EObject element, EClassifier type) {
        if (visited.add(element)) {
            if (type.isInstance((Object)element)) {
                result.add(element);
            }
            if (!EcorePackage.Literals.EOBJECT.equals(element)) {
                EClass eClass = element.eClass();
                for (EStructuralFeature feature : eClass.getEAllStructuralFeatures()) {
                    if (feature.isDerived()) continue;
                    if (feature instanceof EReference) {
                        Object object2;
                        EReference reference = (EReference)feature;
                        if (reference.isMany()) {
                            for (Object object2 : (Collection)element.eGet((EStructuralFeature)reference)) {
                                queue.add((EObject)object2);
                            }
                            continue;
                        }
                        object2 = (EObject)element.eGet((EStructuralFeature)reference);
                        if (object2 == null || EcorePackage.eINSTANCE.equals(object2) && EcorePackage.Literals.ECLASSIFIER__EPACKAGE.equals(feature) && !(element instanceof EClass)) continue;
                        queue.addLast((EObject)object2);
                        continue;
                    }
                    if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) continue;
                    for (FeatureMap.Entry entry : (FeatureMap)element.eGet(feature)) {
                        if (!(entry.getEStructuralFeature() instanceof EReference) || entry.getValue() == null) continue;
                        queue.addLast((EObject)entry.getValue());
                    }
                }
            }
        }
    }

    private void recollectEcore() {
        this.ePackages.clear();
        this.eClasses.clear();
        this.eDataTypes.clear();
        EAnnotation annotation = this.activity.getAnnotation(SOURCE_TYPES);
        if (annotation != null) {
            for (EObject reference : annotation.getReferences()) {
                if (!(reference instanceof EPackage)) continue;
                this.ePackages.add((EPackage)reference);
            }
            for (String nsUri : annotation.getDetails().keySet()) {
                EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
                if (ePackage != null) {
                    this.ePackages.add(ePackage);
                    continue;
                }
                String message = String.format("The EPackage with the nsURI '%1s' could not be found!", nsUri);
                Activator.getInstance().logWarning(message);
            }
        }
        for (EPackage ePackage : this.ePackages) {
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (eClassifier instanceof EDataType) {
                    this.eDataTypes.add((EDataType)eClassifier);
                    continue;
                }
                if (!(eClassifier instanceof EClass)) continue;
                this.eClasses.add((EClass)eClassifier);
            }
        }
        Collections.sort(this.eClasses, COMPARATOR_ECORE);
        Collections.sort(this.eDataTypes, COMPARATOR_ECORE);
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public List<EClass> getEClasses() {
        return this.eClasses;
    }

    public List<EDataType> getEDataTypes() {
        return this.eDataTypes;
    }

    public static ResourceManager get(Activity activity) {
        ResourceManager manager = instances.get(activity);
        if (manager == null) {
            manager = new ResourceManager(activity);
            instances.put(activity, manager);
        }
        return manager;
    }

    public static void dispose(Activity activity) {
        ResourceManager manager = instances.get(activity);
        if (manager != null) {
            manager.dispose();
        }
        instances.remove(activity);
    }

    public Collection<EPackage> getAllEPackages() {
        return this.ePackages;
    }

    private void dispose() {
        this.activity.eResource().getResourceSet().eAdapters().remove((Object)this.resourceSetAdapter);
        this.activity.eAdapters().remove((Object)this.resourceSetAdapter);
        EAnnotation annotation = this.activity.getAnnotation(SOURCE_TYPES);
        if (annotation != null) {
            annotation.eAdapters().remove((Object)this.resourceSetAdapter);
        }
        this.activity.eResource().getResourceSet().eAdapters().remove((Object)this.resourceSetAdapter);
    }

    public static boolean isReferencing(EObject element, EPackage ePackage) {
        if (element instanceof ObjectVariable) {
            return ResourceManager.isReferencing((EObject)((ObjectVariable)element).getClassifier(), ePackage);
        }
        if (element instanceof PrimitiveVariable) {
            return ResourceManager.isReferencing((EObject)((PrimitiveVariable)element).getClassifier(), ePackage);
        }
        if (element instanceof LinkVariable) {
            return ResourceManager.isReferencing((EObject)((LinkVariable)element).getSourceEnd(), ePackage) || ResourceManager.isReferencing((EObject)((LinkVariable)element).getTargetEnd(), ePackage);
        }
        if (element instanceof EParameter) {
            return ResourceManager.isReferencing((EObject)((EParameter)element).getEType(), ePackage);
        }
        if (element instanceof EReference) {
            return ResourceManager.isReferencing((EObject)((EReference)element).getEContainingClass(), ePackage);
        }
        if (element instanceof EClassifier) {
            return ResourceManager.isReferencing((EObject)((EClassifier)element).getEPackage(), ePackage);
        }
        if (element instanceof EPackage) {
            return ePackage.equals(element);
        }
        return false;
    }
}

