/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.dialogs;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.custom.Activator;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.custom.providers.ResourcesContentProvider;
import org.storydriven.storydiagrams.diagram.custom.providers.ResourcesLabelProvider;

public class ConfigureEParameterDialog
extends TitleAreaDialog {
    private EClassifier eClassifier;
    private String name;
    private boolean isOutgoing;
    private boolean isCreating;
    private Text nameText;
    private TreeViewer typeViewer;
    private Activity activity;
    private Text filterText;

    public ConfigureEParameterDialog(Shell shell) {
        super(shell);
        this.setHelpAvailable(false);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EClassifier getEClassifier() {
        return this.eClassifier;
    }

    public void setEClassifier(EClassifier eClassifier) {
        this.eClassifier = eClassifier;
    }

    public void setCreating(boolean isCreating) {
        this.isCreating = isCreating;
    }

    public void setOutgoing(boolean isOutgoing) {
        this.isOutgoing = isOutgoing;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.getShellText());
        this.setTitle(this.getTitle());
        this.setMessage(this.getDescription());
        if (this.isOutgoing) {
            this.setTitleImage(DiagramImages.getImage("icons/banners/configure_out_parameter.png"));
        } else {
            this.setTitleImage(DiagramImages.getImage("icons/banners/configure_in_parameter.png"));
        }
        Composite areaComposite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(areaComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(mainComposite);
        Group typeGroup = new Group(mainComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)typeGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo((Composite)typeGroup);
        typeGroup.setText("Type");
        Composite filterComposite = new Composite((Composite)typeGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)filterComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(filterComposite);
        Label filterLabel = new Label(filterComposite, 131072);
        filterLabel.setText("Filter:");
        this.filterText = new Text(filterComposite, 18436);
        this.filterText.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
        this.typeViewer = new TreeViewer((Composite)typeGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.typeViewer.getControl());
        this.typeViewer.setContentProvider((IContentProvider)new ResourcesContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new ResourcesLabelProvider());
        this.typeViewer.setUseHashlookup(true);
        this.typeViewer.setComparator(new ViewerComparator());
        this.typeViewer.setInput((Object)this.activity);
        Composite nameComposite = new Composite(mainComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)nameComposite);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(nameComposite);
        Label nameLabel = new Label(nameComposite, 131072);
        nameLabel.setText("Name:");
        this.nameText = new Text(nameComposite, 18436);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
        this.hookListeners();
        if (this.name != null) {
            this.nameText.setText(this.name);
            this.nameText.selectAll();
        }
        if (this.eClassifier != null) {
            EPackage ePackage = this.eClassifier.getEPackage();
            while (ePackage != null) {
                this.typeViewer.setExpandedState((Object)ePackage.eResource(), true);
                this.typeViewer.setExpandedState((Object)ePackage, true);
                ePackage = ePackage.getESuperPackage();
            }
            this.typeViewer.setSelection((ISelection)new StructuredSelection((Object)this.eClassifier), true);
        }
        return mainComposite;
    }

    private String getShellText() {
        if (this.isOutgoing) {
            return "Output Parameter";
        }
        return "Input Parameter";
    }

    private String getTitle() {
        if (this.isCreating) {
            if (this.isOutgoing) {
                return "Create Output Parameter";
            }
            return "Create Input Parameter";
        }
        if (this.isOutgoing) {
            return "Configure Output Parameter";
        }
        return "Configure Input Parameter";
    }

    private String getDescription() {
        if (this.isCreating) {
            if (this.isOutgoing) {
                return "Create an out parameter for the activity.";
            }
            return "Create an in parameter for the activity.";
        }
        if (this.isOutgoing) {
            return "Configure out parameter of the activity.";
        }
        return "Configure in parameter of the activity.";
    }

    private void hookListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigureEParameterDialog.this.name = ConfigureEParameterDialog.this.nameText.getText();
            }
        });
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)ConfigureEParameterDialog.this.typeViewer.getSelection();
                if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof EClassifier) {
                    ConfigureEParameterDialog.this.eClassifier = (EClassifier)element;
                }
            }
        });
        this.typeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ConfigureEParameterDialog.this.typeViewer.getSelection();
                if (selection.size() == 1) {
                    Object element = selection.getFirstElement();
                    if (element instanceof EClassifier) {
                        ConfigureEParameterDialog.this.eClassifier = (EClassifier)element;
                        ConfigureEParameterDialog.this.okPressed();
                    } else {
                        boolean expanded = ConfigureEParameterDialog.this.typeViewer.getExpandedState(element);
                        ConfigureEParameterDialog.this.typeViewer.setExpandedState(element, !expanded);
                    }
                }
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = ((Object)((Object)this)).getClass().getCanonicalName();
        IDialogSettings plugin = Activator.getInstance().getDialogSettings();
        IDialogSettings dialog = plugin.getSection(sectionName);
        if (dialog == null) {
            dialog = plugin.addNewSection(sectionName);
        }
        return dialog;
    }
}

