/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.dialogs;

import de.upb.swt.core.ui.providers.ComposedAdapterFactoryLabelProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.storydriven.storydiagrams.activities.MatchingStoryNode;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.custom.dialogs.AbstractTreeSelectionDialog;

public class SelectActivityPreconditionDialog
extends AbstractTreeSelectionDialog<MatchingStoryNode> {
    private ResourceSet resourceSet;

    public SelectActivityPreconditionDialog() {
        super("Activity Precodition", "Select Activity Precondition", "Select the pattern that must be matched as condition of the activity.");
        this.setTitleImage(DiagramImages.getImage("icons/banners/select_precondition.png"));
    }

    public void setInput(ResourceSet resourceSet) {
        this.setResourceSet(resourceSet);
        this.resourceSet = resourceSet;
    }

    @Override
    protected ILabelProvider getLabelProvider() {
        return new ComposedAdapterFactoryLabelProvider();
    }

    @Override
    protected boolean hasLoadButton() {
        return true;
    }

    @Override
    protected ViewerFilter getViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof MatchingStoryNode) {
                    return true;
                }
                if (element instanceof Resource) {
                    for (EObject content : ((Resource)element).getContents()) {
                        if (!this.select(viewer, element, content)) continue;
                        return true;
                    }
                }
                if (element instanceof EObject) {
                    for (EObject content : ((EObject)element).eContents()) {
                        if (!this.select(viewer, element, content)) continue;
                        return true;
                    }
                }
                return false;
            }
        };
    }

    @Override
    protected Object getInput() {
        return this.resourceSet;
    }

    @Override
    protected String getErrorMessage(Object element) {
        if (element instanceof MatchingStoryNode) {
            return null;
        }
        return "You have to select an Matching Story Node!";
    }
}

