/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.properties.sections;

import de.upb.swt.core.ui.properties.sections.AbstractPropertySection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.custom.dialogs.ConfigureEParameterDialog;
import org.storydriven.storydiagrams.diagram.custom.providers.EParametersLabelProvider;
import org.storydriven.storydiagrams.diagram.custom.util.ActivityUtil;

public class ActivityParametersSection
extends AbstractPropertySection {
    private ConfigureEParameterDialog configureDialog;
    private TableViewer inParametersViewer;
    private Button inAddButton;
    private Button inRemoveButton;
    private Button inConfigureButton;
    private Button inUpButton;
    private Button inDownButton;
    private TableViewer outParametersViewer;
    private Button outAddButton;
    private Button outRemoveButton;
    private Button outConfigureButton;
    private Button outUpButton;
    private Button outDownButton;

    public ActivityParametersSection() {
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        this.configureDialog = new ConfigureEParameterDialog(shell);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected void hookWidgetListeners() {
        this.hookInListeners();
        this.hookOutListeners();
    }

    private void hookInListeners() {
        this.inParametersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActivityParametersSection.this.checkButtonStates();
            }
        });
        this.inParametersViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ActivityParametersSection.this.configure(false, false, ActivityParametersSection.getEParameter(ActivityParametersSection.this.inParametersViewer.getSelection()));
            }
        });
        this.inParametersViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && !ActivityParametersSection.this.inParametersViewer.getSelection().isEmpty()) {
                    ActivityParametersSection.this.remove((IStructuredSelection)ActivityParametersSection.this.inParametersViewer.getSelection(), false);
                }
            }
        });
        this.inAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityParametersSection.this.configure(true, false, EcoreFactory.eINSTANCE.createEParameter());
            }
        });
        this.inRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityParametersSection.this.inParametersViewer.getSelection();
                if (!selection.isEmpty()) {
                    ActivityParametersSection.this.remove(selection, false);
                }
            }
        });
        this.inConfigureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityParametersSection.this.configure(false, false, ActivityParametersSection.getEParameter(ActivityParametersSection.this.inParametersViewer.getSelection()));
                ActivityParametersSection.this.inParametersViewer.refresh();
            }
        });
        this.inUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityParametersSection.this.inParametersViewer.getSelection();
                if (!selection.isEmpty()) {
                    ActivityParametersSection.this.move(selection, false, false);
                }
            }
        });
        this.inDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityParametersSection.this.inParametersViewer.getSelection();
                if (!selection.isEmpty()) {
                    ActivityParametersSection.this.move(selection, false, true);
                }
            }
        });
    }

    private void hookOutListeners() {
        this.outParametersViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActivityParametersSection.this.checkButtonStates();
            }
        });
        this.outParametersViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ActivityParametersSection.this.configure(false, true, ActivityParametersSection.getEParameter(ActivityParametersSection.this.outParametersViewer.getSelection()));
            }
        });
        this.outParametersViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && !ActivityParametersSection.this.outParametersViewer.getSelection().isEmpty()) {
                    ActivityParametersSection.this.remove((IStructuredSelection)ActivityParametersSection.this.outParametersViewer.getSelection(), true);
                }
            }
        });
        this.outAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityParametersSection.this.configure(true, true, EcoreFactory.eINSTANCE.createEParameter());
            }
        });
        this.outRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityParametersSection.this.outParametersViewer.getSelection();
                if (!selection.isEmpty()) {
                    ActivityParametersSection.this.remove(selection, true);
                }
            }
        });
        this.outConfigureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityParametersSection.this.configure(false, true, ActivityParametersSection.getEParameter(ActivityParametersSection.this.outParametersViewer.getSelection()));
            }
        });
        this.outUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityParametersSection.this.outParametersViewer.getSelection();
                if (!selection.isEmpty()) {
                    ActivityParametersSection.this.move(selection, true, false);
                }
            }
        });
        this.outDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ActivityParametersSection.this.outParametersViewer.getSelection();
                if (!selection.isEmpty()) {
                    ActivityParametersSection.this.move(selection, true, true);
                }
            }
        });
    }

    protected boolean shouldRefresh(Notification msg) {
        return true;
    }

    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        Group inParametersGroup = factory.createGroup(parent, "In Parameters");
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo((Composite)inParametersGroup);
        Composite inControlsComposite = factory.createFlatFormComposite((Composite)inParametersGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).numColumns(3).applyTo(inControlsComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(131072, 4).applyTo((Control)inControlsComposite);
        factory.createFlatFormComposite((Composite)inParametersGroup);
        this.inAddButton = factory.createButton(inControlsComposite, "", 8);
        this.inAddButton.setImage(DiagramImages.getImage("icons/controls/add.png"));
        this.inAddButton.setToolTipText("Add In Parameter");
        this.inRemoveButton = factory.createButton(inControlsComposite, "", 8);
        this.inRemoveButton.setImage(DiagramImages.getImage("icons/controls/remove.png"));
        this.inRemoveButton.setToolTipText("Remove Selected In Parameters");
        this.inRemoveButton.setEnabled(false);
        this.inConfigureButton = factory.createButton(inControlsComposite, "", 8);
        this.inConfigureButton.setImage(DiagramImages.getImage("icons/controls/configure.png"));
        this.inConfigureButton.setToolTipText("Configure Selected In Parameter");
        this.inConfigureButton.setEnabled(false);
        Table inParametersTable = factory.createTable((Composite)inParametersGroup, 67586);
        inParametersTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)inParametersTable);
        this.inParametersViewer = new TableViewer(inParametersTable);
        this.inParametersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.inParametersViewer.setLabelProvider((IBaseLabelProvider)new EParametersLabelProvider());
        Composite inUpDownControlsComposite = factory.createFlatFormComposite((Composite)inParametersGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 6).margins(0, 0).applyTo(inUpDownControlsComposite);
        this.inUpButton = factory.createButton(inUpDownControlsComposite, "", 8);
        this.inUpButton.setImage(DiagramImages.getImage("icons/controls/up.png"));
        this.inUpButton.setToolTipText("Move Parameter Up");
        this.inUpButton.setEnabled(false);
        this.inDownButton = factory.createButton(inUpDownControlsComposite, "", 8);
        this.inDownButton.setImage(DiagramImages.getImage("icons/controls/down.png"));
        this.inDownButton.setToolTipText("Move Parameter Down");
        this.inDownButton.setEnabled(false);
        Group outParametersGroup = factory.createGroup(parent, "Out Parameters");
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo((Composite)outParametersGroup);
        Composite outControlsComposite = factory.createFlatFormComposite((Composite)outParametersGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).numColumns(4).applyTo(outControlsComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(131072, 4).applyTo((Control)outControlsComposite);
        factory.createFlatFormComposite((Composite)outParametersGroup);
        this.outAddButton = factory.createButton(outControlsComposite, "", 8);
        this.outAddButton.setImage(DiagramImages.getImage("icons/controls/add.png"));
        this.outAddButton.setToolTipText("Add Out Parameter");
        this.outRemoveButton = factory.createButton(outControlsComposite, "", 8);
        this.outRemoveButton.setImage(DiagramImages.getImage("icons/controls/remove.png"));
        this.outRemoveButton.setToolTipText("Remove Selected Out Parameters");
        this.outRemoveButton.setEnabled(false);
        this.outConfigureButton = factory.createButton(outControlsComposite, "", 8);
        this.outConfigureButton.setImage(DiagramImages.getImage("icons/controls/configure.png"));
        this.outConfigureButton.setToolTipText("Configure Selected Out Parameter");
        this.outConfigureButton.setEnabled(false);
        Table outParametersTable = factory.createTable((Composite)outParametersGroup, 67586);
        outParametersTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)outParametersTable);
        this.outParametersViewer = new TableViewer(outParametersTable);
        this.outParametersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.outParametersViewer.setLabelProvider((IBaseLabelProvider)new EParametersLabelProvider(true));
        Composite outUpDownControlsComposite = factory.createFlatFormComposite((Composite)outParametersGroup);
        GridLayoutFactory.fillDefaults().spacing(0, 6).margins(0, 0).applyTo(outUpDownControlsComposite);
        this.outUpButton = factory.createButton(outUpDownControlsComposite, "", 8);
        this.outUpButton.setImage(DiagramImages.getImage("icons/controls/up.png"));
        this.outUpButton.setToolTipText("Move Parameter Up");
        this.outUpButton.setEnabled(false);
        this.outDownButton = factory.createButton(outUpDownControlsComposite, "", 8);
        this.outDownButton.setImage(DiagramImages.getImage("icons/controls/down.png"));
        this.outDownButton.setToolTipText("Move Parameter Down");
        this.outDownButton.setEnabled(false);
    }

    protected void layoutWidgets() {
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(50, -6);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.inParametersViewer.getControl().getParent().setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(50, 6);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.outParametersViewer.getControl().getParent().setLayoutData((Object)data);
    }

    private void configure(final boolean isCreating, final boolean isOutgoing, final EParameter eParameter) {
        this.configureDialog.setCreating(isCreating);
        this.configureDialog.setOutgoing(isOutgoing);
        this.configureDialog.setName(eParameter.getName());
        this.configureDialog.setEClassifier(eParameter.getEType());
        this.configureDialog.setActivity(this.getElement());
        int result = this.configureDialog.open();
        if (result == 0) {
            final String name = this.configureDialog.getName();
            final EClassifier eClassifier = this.configureDialog.getEClassifier();
            RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

                public void doExecute() {
                    eParameter.setName(name);
                    eParameter.setEType(eClassifier);
                    if (isCreating) {
                        ActivityParametersSection.this.getElement().getContainedParameters().add((Object)eParameter);
                        EList list = isOutgoing ? ActivityParametersSection.this.getElement().getOutParameters() : ActivityParametersSection.this.getElement().getInParameters();
                        int insertionIndex = list.size();
                        if (isCreating) {
                            int index = 0;
                            IStructuredSelection selection = (IStructuredSelection)ActivityParametersSection.this.inParametersViewer.getSelection();
                            Object[] objectArray = selection.toArray();
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object element = objectArray[n2];
                                int currentIndex = list.indexOf(element) + 1;
                                if (currentIndex > index) {
                                    index = currentIndex;
                                }
                                ++n2;
                            }
                            insertionIndex = index;
                        }
                        list.add(insertionIndex, (Object)eParameter);
                    }
                }
            };
            this.execute((Command)command);
            this.refresh();
        }
    }

    public void refresh() {
        if (this.getElement() != null && ActivityUtil.isIndependent((Activity)this.getElement())) {
            if (this.inParametersViewer != null && !this.inParametersViewer.getTable().isDisposed()) {
                this.inParametersViewer.getControl().setEnabled(true);
                this.inParametersViewer.setInput((Object)this.getElement().getInParameters());
            }
            if (this.outParametersViewer != null && !this.outParametersViewer.getTable().isDisposed()) {
                this.outParametersViewer.getControl().setEnabled(true);
                this.outParametersViewer.setInput((Object)this.getElement().getOutParameters());
            }
            this.checkButtonStates();
        } else if (!this.inParametersViewer.getControl().isDisposed()) {
            this.inParametersViewer.setInput(null);
            this.outParametersViewer.setInput(null);
            this.inParametersViewer.getControl().setEnabled(false);
            this.inAddButton.setEnabled(false);
            this.inRemoveButton.setEnabled(false);
            this.inConfigureButton.setEnabled(false);
            this.inUpButton.setEnabled(false);
            this.inDownButton.setEnabled(false);
            this.outParametersViewer.getControl().setEnabled(false);
            this.outAddButton.setEnabled(false);
            this.outRemoveButton.setEnabled(false);
            this.outConfigureButton.setEnabled(false);
            this.outUpButton.setEnabled(false);
            this.outDownButton.setEnabled(false);
        }
    }

    private void checkButtonStates() {
        int currentIndex;
        Object element;
        int n;
        int n2;
        Object[] objectArray;
        int maxIndex;
        int minIndex;
        int index;
        int count;
        IStructuredSelection selection = (IStructuredSelection)this.inParametersViewer.getSelection();
        if (!selection.isEmpty()) {
            count = this.getElement().getInParameters().size();
            if (selection.size() == 1) {
                this.inConfigureButton.setEnabled(true);
                index = this.getElement().getInParameters().indexOf(selection.getFirstElement());
                this.inUpButton.setEnabled(index > 0);
                this.inDownButton.setEnabled(index < count - 1);
            } else {
                this.inConfigureButton.setEnabled(false);
                minIndex = count;
                maxIndex = 0;
                objectArray = selection.toArray();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    element = objectArray[n];
                    currentIndex = this.getElement().getInParameters().indexOf(element);
                    if (currentIndex > maxIndex) {
                        maxIndex = currentIndex;
                    }
                    if (currentIndex < minIndex) {
                        minIndex = currentIndex;
                    }
                    ++n;
                }
                this.inUpButton.setEnabled(minIndex > 0);
                this.inDownButton.setEnabled(maxIndex < count - 1);
            }
            this.inRemoveButton.setEnabled(true);
        }
        if (!(selection = (IStructuredSelection)this.outParametersViewer.getSelection()).isEmpty()) {
            count = this.getElement().getOutParameters().size();
            if (selection.size() == 1) {
                this.outConfigureButton.setEnabled(true);
                index = this.getElement().getOutParameters().indexOf(selection.getFirstElement());
                this.outUpButton.setEnabled(index > 0);
                this.outDownButton.setEnabled(index < count - 1);
            } else {
                this.outConfigureButton.setEnabled(false);
                minIndex = count;
                maxIndex = 0;
                objectArray = selection.toArray();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    element = objectArray[n];
                    currentIndex = this.getElement().getOutParameters().indexOf(element);
                    if (currentIndex > maxIndex) {
                        maxIndex = currentIndex;
                    }
                    if (currentIndex < minIndex) {
                        minIndex = currentIndex;
                    }
                    ++n;
                }
                this.outUpButton.setEnabled(minIndex > 0);
                this.outDownButton.setEnabled(maxIndex < count - 1);
            }
            this.outRemoveButton.setEnabled(true);
        }
    }

    protected Activity getElement() {
        return (Activity)super.getElement();
    }

    private void move(final IStructuredSelection selection, final boolean isOutgoing, final boolean down) {
        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

            public void doExecute() {
                EList list = isOutgoing ? ActivityParametersSection.this.getElement().getOutParameters() : ActivityParametersSection.this.getElement().getInParameters();
                Object[] parameters = selection.toArray();
                if (down) {
                    int i = parameters.length - 1;
                    while (i >= 0) {
                        int index = list.indexOf(parameters[i]);
                        list.move(index + 1, (Object)((EParameter)parameters[i]));
                        --i;
                    }
                } else {
                    int i = 0;
                    while (i < parameters.length) {
                        int index = list.indexOf(parameters[i]);
                        list.move(index - 1, (Object)((EParameter)parameters[i]));
                        ++i;
                    }
                }
            }
        };
        this.execute((Command)command);
    }

    private void remove(final IStructuredSelection selection, boolean isOutgoing) {
        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

            public void doExecute() {
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof EParameter) {
                        EcoreUtil.delete((EObject)((EParameter)element));
                    }
                    ++n2;
                }
            }
        };
        this.execute((Command)command);
    }

    private static EParameter getEParameter(ISelection selection) {
        Object element;
        if (!selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof EParameter) {
            return (EParameter)element;
        }
        return null;
    }
}

