/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.properties.sections;

import de.upb.swt.core.ui.properties.sections.AbstractPropertySection;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.custom.ResourceManager;
import org.storydriven.storydiagrams.diagram.custom.dialogs.SelectEPackageFromRegistryDialog;
import org.storydriven.storydiagrams.diagram.custom.dialogs.SelectEPackageFromWorkspaceDialog;
import org.storydriven.storydiagrams.diagram.custom.providers.ResourcesContentProvider;
import org.storydriven.storydiagrams.diagram.custom.providers.ResourcesLabelProvider;

public class ActivityTypeModelSection
extends AbstractPropertySection {
    private SelectEPackageFromWorkspaceDialog addWorkspaceDialog = new SelectEPackageFromWorkspaceDialog();
    private TreeViewer viewer;
    private Composite resourcesComposite;
    private Button addNamespaceButton;
    private Button addWorkspaceButton;
    private Button removeEPackageButton;
    private SelectEPackageFromRegistryDialog addRegisteredDialog = new SelectEPackageFromRegistryDialog();

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.viewer.setInput((Object)this.getElement());
    }

    protected ResourceManager getResourceManager() {
        return ResourceManager.get(this.getElement());
    }

    protected boolean isReferenced(EPackage ePackage) {
        TreeIterator it = EcoreUtil.getAllContents((EObject)this.getElement(), (boolean)true);
        while (it.hasNext()) {
            EObject element = (EObject)it.next();
            if (!ResourceManager.isReferencing(element, ePackage)) continue;
            return true;
        }
        return false;
    }

    private void removeSelected() {
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)this.getEditingDomain()){

            protected void doExecute() {
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof EPackage) {
                        EPackage ePackage = (EPackage)element;
                        Activity activity = ActivityTypeModelSection.this.getElement();
                        EAnnotation annotation = activity.getAnnotation("http://www.storydriven.org/storydiagrams/types");
                        annotation.getReferences().remove((Object)ePackage);
                        annotation.getDetails().remove((Object)ePackage.getNsURI());
                    }
                    ++n2;
                }
            }
        };
        this.execute((Command)command);
        ResourceManager.get(this.getElement()).recollect();
        this.viewer.refresh();
    }

    protected Activity getElement() {
        return (Activity)super.getElement();
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        this.viewer.refresh();
    }

    protected void layoutWidgets() {
        FormData data = new FormData();
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.top = new FormAttachment(0);
        data.bottom = new FormAttachment(100);
        this.resourcesComposite.setLayoutData((Object)data);
    }

    protected void createWidgets(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        this.resourcesComposite = factory.createFlatFormComposite(parent);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(this.resourcesComposite);
        Group resourcesGroup = factory.createGroup(this.resourcesComposite, "Packages building the Type Model");
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)resourcesGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)resourcesGroup);
        Tree tree = factory.createTree((Composite)resourcesGroup, 2050);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new ResourcesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourcesLabelProvider());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                boolean expanded = ActivityTypeModelSection.this.viewer.getExpandedState(element);
                ActivityTypeModelSection.this.viewer.setExpandedState(element, !expanded);
            }
        });
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof Resource || element instanceof EPackage || element instanceof EClassifier) {
                    return true;
                }
                Object[] objectArray = ((ITreeContentProvider)((TreeViewer)viewer).getContentProvider()).getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (!this.select(viewer, element, child)) {
                        return false;
                    }
                    ++n2;
                }
                return false;
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.viewer.getTree());
        Composite controlsComposite = factory.createFlatFormComposite((Composite)resourcesGroup);
        GridLayoutFactory.fillDefaults().applyTo(controlsComposite);
        GridDataFactory.fillDefaults().applyTo((Control)controlsComposite);
        this.addNamespaceButton = factory.createButton(controlsComposite, "URI", 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.addNamespaceButton);
        this.addNamespaceButton.setImage(DiagramImages.getImage("icons/controls/add.png"));
        this.addWorkspaceButton = factory.createButton(controlsComposite, "Resource", 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.addWorkspaceButton);
        this.addWorkspaceButton.setImage(DiagramImages.getImage("icons/controls/add.png"));
        this.removeEPackageButton = factory.createButton(controlsComposite, "Remove", 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.removeEPackageButton);
        this.removeEPackageButton.setImage(DiagramImages.getImage("icons/controls/remove.png"));
    }

    protected void hookWidgetListeners() {
        this.addNamespaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection ePackages;
                ActivityTypeModelSection.this.addRegisteredDialog.reset();
                ActivityTypeModelSection.this.addRegisteredDialog.setHiddenElements(ActivityTypeModelSection.this.getResourceManager().getAllEPackages());
                if (ActivityTypeModelSection.this.addRegisteredDialog.open() == 0 && (ePackages = ActivityTypeModelSection.this.addRegisteredDialog.getElements()) != null && !ePackages.isEmpty()) {
                    RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)ActivityTypeModelSection.this.getEditingDomain()){

                        protected void doExecute() {
                            Activity activity = ActivityTypeModelSection.this.getElement();
                            EAnnotation annotation = activity.getAnnotation("http://www.storydriven.org/storydiagrams/types");
                            if (annotation == null) {
                                annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                                annotation.setSource("http://www.storydriven.org/storydiagrams/types");
                                activity.getAnnotations().add((Object)annotation);
                            }
                            for (EPackage ePackage : ePackages) {
                                annotation.getDetails().put((Object)ePackage.getNsURI(), (Object)String.valueOf(true));
                            }
                        }
                    };
                    ActivityTypeModelSection.this.execute((Command)command);
                    ResourceManager.get(ActivityTypeModelSection.this.getElement()).recollect();
                    ActivityTypeModelSection.this.viewer.refresh();
                }
            }
        });
        this.addWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection files;
                ActivityTypeModelSection.this.addWorkspaceDialog.reset();
                if (ActivityTypeModelSection.this.addWorkspaceDialog.open() == 0 && (files = ActivityTypeModelSection.this.addWorkspaceDialog.getElements()) != null && !files.isEmpty()) {
                    final HashSet<EPackage> ePackages = new HashSet<EPackage>();
                    for (IFile file : files) {
                        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                        Resource resource = ActivityTypeModelSection.this.getEditingDomain().getResourceSet().getResource(uri, true);
                        if (resource == null) continue;
                        TreeIterator it = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
                        while (it.hasNext()) {
                            Object object = it.next();
                            if (!(object instanceof EPackage)) continue;
                            ePackages.add((EPackage)object);
                        }
                    }
                    if (!ePackages.isEmpty()) {
                        RecordingCommand command = new RecordingCommand((TransactionalEditingDomain)ActivityTypeModelSection.this.getEditingDomain()){

                            protected void doExecute() {
                                for (EPackage ePackage : ePackages) {
                                    if (ePackage == null) continue;
                                    Activity activity = ActivityTypeModelSection.this.getElement();
                                    EAnnotation annotation = activity.getAnnotation("http://www.storydriven.org/storydiagrams/types");
                                    if (annotation == null) {
                                        annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                                        annotation.setSource("http://www.storydriven.org/storydiagrams/types");
                                        activity.getAnnotations().add((Object)annotation);
                                    }
                                    annotation.getReferences().add((Object)ePackage);
                                }
                            }
                        };
                        ActivityTypeModelSection.this.execute((Command)command);
                        ResourceManager.get(ActivityTypeModelSection.this.getElement()).recollect();
                        ActivityTypeModelSection.this.viewer.refresh();
                    }
                }
            }
        });
        this.removeEPackageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityTypeModelSection.this.removeSelected();
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ActivityTypeModelSection.this.viewer.getSelection();
                boolean removeState = true;
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof EPackage) {
                        if (ActivityTypeModelSection.this.isReferenced((EPackage)element)) {
                            removeState = false;
                            break;
                        }
                    } else {
                        removeState = false;
                        break;
                    }
                    ++n2;
                }
                ActivityTypeModelSection.this.removeEPackageButton.setEnabled(removeState);
            }
        });
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f' && ActivityTypeModelSection.this.removeEPackageButton.isEnabled()) {
                    ActivityTypeModelSection.this.removeSelected();
                }
            }
        });
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }
}

