/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.providers;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.diagram.custom.DiagramImages;
import org.storydriven.storydiagrams.diagram.custom.util.EcoreTextUtil;

public class EParametersLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final boolean isOutgoing;

    public EParametersLabelProvider(boolean isOutgoing) {
        this.isOutgoing = isOutgoing;
    }

    public EParametersLabelProvider() {
        this(false);
    }

    public Image getColumnImage(Object element, int index) {
        if (element instanceof EParameter) {
            EParameter eParameter = (EParameter)element;
            if (eParameter.eContainer() instanceof Activity) {
                Activity activity = (Activity)eParameter.eContainer();
                if (this.isOutgoing && activity.getInParameters().contains((Object)eParameter)) {
                    return DiagramImages.getImage("icons/elements/ecore/EParameter_out_referenced.png");
                }
                if (!this.isOutgoing && activity.getOutParameters().contains((Object)eParameter)) {
                    return DiagramImages.getImage("icons/elements/ecore/EParameter_in_referenced.png");
                }
            }
            if (this.isOutgoing) {
                return DiagramImages.getImage("icons/elements/ecore/EParameter_out.png");
            }
            return DiagramImages.getImage("icons/elements/ecore/EParameter_in.png");
        }
        return null;
    }

    public String getColumnText(Object element, int index) {
        if (element instanceof EParameter) {
            EParameter eParameter = (EParameter)element;
            StringBuilder builder = new StringBuilder();
            builder.append(eParameter.getName());
            builder.append(' ');
            builder.append(':');
            builder.append(' ');
            return EcoreTextUtil.append((StringBuilder)builder, (EClassifier)eParameter.getEType()).toString();
        }
        return this.getText(element);
    }
}

