/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.custom.util;

import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.activities.EdgeGuard;
import org.storydriven.storydiagrams.activities.InitialNode;
import org.storydriven.storydiagrams.activities.StoryNode;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.BindingSemantics;
import org.storydriven.storydiagrams.patterns.BindingState;

public class ValidationUtil {
    public static boolean isValid(ActivityEdge edge, EdgeGuard guard) {
        ActivityNode source = edge.getSource();
        if (source instanceof InitialNode) {
            return EdgeGuard.NONE.equals((Object)guard);
        }
        if (EdgeGuard.EACH_TIME.equals((Object)guard) || EdgeGuard.END.equals((Object)guard)) {
            return source instanceof StoryNode && ((StoryNode)source).isForEach();
        }
        if (EdgeGuard.SUCCESS.equals((Object)guard) || EdgeGuard.FAILURE.equals((Object)guard)) {
            return source instanceof StoryNode && !((StoryNode)source).isForEach();
        }
        return true;
    }

    public static boolean isValid(BindingState state, BindingSemantics semantics, BindingOperator operator) {
        switch (state) {
            case UNBOUND: {
                switch (semantics) {
                    case NEGATIVE: {
                        switch (operator) {
                            case CREATE: 
                            case DESTROY: {
                                return false;
                            }
                        }
                        return true;
                    }
                }
                return true;
            }
            case BOUND: {
                switch (semantics) {
                    case MANDATORY: {
                        switch (operator) {
                            case CREATE: {
                                return false;
                            }
                        }
                        return true;
                    }
                    case NEGATIVE: 
                    case OPTIONAL: {
                        return false;
                    }
                }
                return true;
            }
            case MAYBE_BOUND: {
                switch (semantics) {
                    case MANDATORY: {
                        switch (operator) {
                            case CREATE: {
                                return false;
                            }
                        }
                        return true;
                    }
                    case NEGATIVE: 
                    case OPTIONAL: {
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    public static boolean isValidLink(BindingSemantics semantics, BindingOperator operator) {
        switch (semantics) {
            case NEGATIVE: {
                switch (operator) {
                    case CREATE: 
                    case DESTROY: {
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }
}

