/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.ocl;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.swt.graphics.Color;
import org.storydriven.storydiagrams.diagram.ocl.ColorManager;
import org.storydriven.storydiagrams.diagram.ocl.OCLDocument;

public class OCLIdentifierRule
extends WordRule {
    public OCLIdentifierRule(ColorManager colorManager, OCLDocument oclDocument) {
        super((IWordDetector)new OCLKeywordDetector(), (IToken)new Token((Object)new TextAttribute(null)));
        Color color = colorManager.getColor(ColorManager.KNOWN_VARIABLE);
        Token wordToken = new Token((Object)new TextAttribute(color, null, 0));
        for (Variable<EClassifier, EParameter> variable : oclDocument.getOCLContextInformation()) {
            this.addWord(variable.getName(), (IToken)wordToken);
        }
    }

    private static class OCLKeywordDetector
    implements IWordDetector {
        private OCLKeywordDetector() {
        }

        public boolean isWordPart(char c) {
            return this.isWordStart(c) || c == '$' || c >= '0' && c <= '9';
        }

        public boolean isWordStart(char c) {
            return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }
    }
}

