/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.storydriven.storydiagrams.diagram.edit.policies.StorydiagramsBaseItemSemanticEditPolicy;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.LinkVariable;
import org.storydriven.storydiagrams.patterns.ObjectVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;

public class LinkVariableReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public LinkVariableReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof LinkVariable)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ObjectVariable) || !(this.newEnd instanceof ObjectVariable)) {
            return false;
        }
        AbstractVariable target = this.getLink().getTarget();
        if (!(this.getLink().eContainer() instanceof StoryPattern)) {
            return false;
        }
        StoryPattern container = (StoryPattern)this.getLink().eContainer();
        return StorydiagramsBaseItemSemanticEditPolicy.getLinkConstraints().canExistLinkVariable_4002(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof AbstractVariable) || !(this.newEnd instanceof AbstractVariable)) {
            return false;
        }
        ObjectVariable source = this.getLink().getSource();
        if (!(this.getLink().eContainer() instanceof StoryPattern)) {
            return false;
        }
        StoryPattern container = (StoryPattern)this.getLink().eContainer();
        return StorydiagramsBaseItemSemanticEditPolicy.getLinkConstraints().canExistLinkVariable_4002(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected LinkVariable getLink() {
        return (LinkVariable)this.getElementToEdit();
    }

    protected ObjectVariable getOldSource() {
        return (ObjectVariable)this.oldEnd;
    }

    protected ObjectVariable getNewSource() {
        return (ObjectVariable)this.newEnd;
    }

    protected AbstractVariable getOldTarget() {
        return (AbstractVariable)this.oldEnd;
    }

    protected AbstractVariable getNewTarget() {
        return (AbstractVariable)this.newEnd;
    }
}

