/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.storydriven.storydiagrams.diagram.part.Messages;
import org.storydriven.storydiagrams.diagram.part.StorydiagramsCreationWizardPage;
import org.storydriven.storydiagrams.diagram.part.StorydiagramsDiagramEditorPlugin;
import org.storydriven.storydiagrams.diagram.part.StorydiagramsDiagramEditorUtil;

public class StorydiagramsCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected StorydiagramsCreationWizardPage diagramModelFilePage;
    protected StorydiagramsCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.StorydiagramsCreationWizardTitle);
        this.setDefaultPageImageDescriptor(StorydiagramsDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewActivitiesWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new StorydiagramsCreationWizardPage("DiagramModelFile", this.getSelection(), "sdm_diagram");
        this.diagramModelFilePage.setTitle(Messages.StorydiagramsCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.StorydiagramsCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new StorydiagramsCreationWizardPage("DomainModelFile", this.getSelection(), "sdm"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = StorydiagramsCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".sdm_diagram".length());
                    this.setFileName(StorydiagramsDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "sdm"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.StorydiagramsCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.StorydiagramsCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                StorydiagramsCreationWizard.this.diagram = StorydiagramsDiagramEditorUtil.createDiagram(StorydiagramsCreationWizard.this.diagramModelFilePage.getURI(), StorydiagramsCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (StorydiagramsCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && StorydiagramsCreationWizard.this.diagram != null) {
                    try {
                        StorydiagramsDiagramEditorUtil.openDiagram(StorydiagramsCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)StorydiagramsCreationWizard.this.getContainer().getShell(), (String)Messages.StorydiagramsCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.StorydiagramsCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                StorydiagramsDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

