/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.diagram.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.storydriven.core.expressions.common.provider.CommonExpressionsItemProviderAdapterFactory;
import org.storydriven.core.expressions.provider.ExpressionsItemProviderAdapterFactory;
import org.storydriven.core.provider.CoreItemProviderAdapterFactory;
import org.storydriven.storydiagrams.activities.expressions.provider.ActivitiesExpressionsItemProviderAdapterFactory;
import org.storydriven.storydiagrams.activities.provider.ActivitiesItemProviderAdapterFactory;
import org.storydriven.storydiagrams.calls.expressions.provider.CallsExpressionsItemProviderAdapterFactory;
import org.storydriven.storydiagrams.calls.provider.CallsItemProviderAdapterFactory;
import org.storydriven.storydiagrams.diagram.edit.policies.StorydiagramsBaseItemSemanticEditPolicy;
import org.storydriven.storydiagrams.diagram.part.StorydiagramsDocumentProvider;
import org.storydriven.storydiagrams.diagram.providers.ElementInitializers;
import org.storydriven.storydiagrams.patterns.expressions.provider.PatternsExpressionsItemProviderAdapterFactory;
import org.storydriven.storydiagrams.patterns.provider.PatternsItemProviderAdapterFactory;
import org.storydriven.storydiagrams.provider.StorydiagramsItemProviderAdapterFactory;
import org.storydriven.storydiagrams.templates.provider.TemplatesItemProviderAdapterFactory;

public class StorydiagramsDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "org.storydriven.storydiagrams.diagram";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("org.storydriven.storydiagrams.diagram");
    private static StorydiagramsDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    private StorydiagramsDocumentProvider documentProvider;
    private StorydiagramsBaseItemSemanticEditPolicy.LinkConstraints linkConstraints;
    private ElementInitializers initializers;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        this.linkConstraints = null;
        this.initializers = null;
        instance = null;
        super.stop(context);
    }

    public static StorydiagramsDiagramEditorPlugin getInstance() {
        return instance;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>();
        this.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List<AdapterFactory> factories) {
        factories.add((AdapterFactory)new StorydiagramsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ActivitiesItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ActivitiesExpressionsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new CallsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new CallsExpressionsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new PatternsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new PatternsExpressionsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new TemplatesItemProviderAdapterFactory());
        factories.add((AdapterFactory)new CoreItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ExpressionsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new CommonExpressionsItemProviderAdapterFactory());
        factories.add((AdapterFactory)new EcoreItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ResourceItemProviderAdapterFactory());
        factories.add((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return StorydiagramsDiagramEditorPlugin.getBundledImageDescriptor(p.makeAbsolute().toString());
    }

    public Image getBundledImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, StorydiagramsDiagramEditorPlugin.getBundledImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)StorydiagramsDiagramEditorPlugin.getInstance().getBundle(), (String)("%" + key));
    }

    public StorydiagramsDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = new StorydiagramsDocumentProvider();
        }
        return this.documentProvider;
    }

    public StorydiagramsBaseItemSemanticEditPolicy.LinkConstraints getLinkConstraints() {
        return this.linkConstraints;
    }

    public void setLinkConstraints(StorydiagramsBaseItemSemanticEditPolicy.LinkConstraints lc) {
        this.linkConstraints = lc;
    }

    public ElementInitializers getElementInitializers() {
        return this.initializers;
    }

    public void setElementInitializers(ElementInitializers i) {
        this.initializers = i;
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, error, throwable));
        this.debug(error, throwable);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, message, throwable));
        this.debug(message, throwable);
    }

    private void debug(String message, Throwable throwable) {
        if (!this.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }
}

