/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.interpreter.calls;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreter;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreterManager;
import de.mdelab.sdm.interpreter.core.notifications.NotificationEmitter;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import de.mdelab.sdm.interpreter.core.variables.VariablesScope;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.storydriven.core.expressions.Expression;
import org.storydriven.core.expressions.common.ArithmeticExpression;
import org.storydriven.core.expressions.common.ComparisonExpression;
import org.storydriven.core.expressions.common.LiteralExpression;
import org.storydriven.core.expressions.common.LogicalExpression;
import org.storydriven.core.expressions.common.UnaryExpression;
import org.storydriven.storydiagrams.activities.Activity;
import org.storydriven.storydiagrams.activities.ActivityEdge;
import org.storydriven.storydiagrams.activities.ActivityNode;
import org.storydriven.storydiagrams.calls.OpaqueCallable;
import org.storydriven.storydiagrams.calls.ParameterBinding;
import org.storydriven.storydiagrams.calls.expressions.MethodCallExpression;
import org.storydriven.storydiagrams.calls.expressions.ParameterExpression;
import org.storydriven.storydiagrams.interpreter.StoryDrivenInterpreter;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.StoryPattern;
import org.storydriven.storydiagrams.patterns.expressions.AttributeValueExpression;
import org.storydriven.storydiagrams.patterns.expressions.ObjectVariableExpression;

public class CallsInterpreter
extends ExpressionInterpreter<Expression, EClassifier> {
    private final List<EDataType> classifierSizeList = new ArrayList<EDataType>();

    public CallsInterpreter() {
        this.classifierSizeList.add(EcorePackage.Literals.ESHORT);
        this.classifierSizeList.add(EcorePackage.Literals.ESHORT_OBJECT);
        this.classifierSizeList.add(EcorePackage.Literals.EBYTE);
        this.classifierSizeList.add(EcorePackage.Literals.EBYTE_OBJECT);
        this.classifierSizeList.add(EcorePackage.Literals.EINT);
        this.classifierSizeList.add(EcorePackage.Literals.EINTEGER_OBJECT);
        this.classifierSizeList.add(EcorePackage.Literals.EFLOAT);
        this.classifierSizeList.add(EcorePackage.Literals.EFLOAT_OBJECT);
        this.classifierSizeList.add(EcorePackage.Literals.ELONG);
        this.classifierSizeList.add(EcorePackage.Literals.ELONG_OBJECT);
        this.classifierSizeList.add(EcorePackage.Literals.EDOUBLE);
        this.classifierSizeList.add(EcorePackage.Literals.EDOUBLE_OBJECT);
    }

    public Variable<EClassifier> evaluateExpression(Expression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        assert (expression != null);
        if (expression instanceof ArithmeticExpression) {
            return this.evaluate((ArithmeticExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        if (expression instanceof AttributeValueExpression) {
            return this.evaluate((AttributeValueExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        if (expression instanceof LogicalExpression) {
            return this.evaluate((LogicalExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        if (expression instanceof ComparisonExpression) {
            return this.evaluate((ComparisonExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        if (expression instanceof LiteralExpression) {
            return this.evaluate((LiteralExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        if (expression instanceof MethodCallExpression) {
            return this.evaluate((MethodCallExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        if (expression instanceof UnaryExpression) {
            return this.evaluate((UnaryExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        if (expression instanceof ObjectVariableExpression) {
            return this.evaluate((ObjectVariableExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        if (expression instanceof ParameterExpression) {
            return this.evaluate((ParameterExpression)expression, contextClassifier, contextInstance, variablesScope);
        }
        throw new UnsupportedOperationException();
    }

    private Variable<EClassifier> evaluate(ParameterExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) {
        String name = expression.getParameter().getVariableName();
        Variable var = variablesScope.getVariable(name);
        if (var == null) {
            EClassifier type = expression.getParameter().getType();
            var = new Variable("##internal_variable", (Object)type, null);
        }
        return var;
    }

    private Variable<EClassifier> evaluate(ArithmeticExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        Number finalResult;
        BigDecimal result;
        assert (expression.getLeftExpression() != null);
        assert (expression.getRightExpression() != null);
        Variable leftVariable = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getLeftExpression(), (Object)contextClassifier, contextInstance, variablesScope);
        Variable rightVariable = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getRightExpression(), (Object)contextClassifier, contextInstance, variablesScope);
        BigDecimal operand1 = new BigDecimal(leftVariable.getValue().toString());
        BigDecimal operand2 = new BigDecimal(rightVariable.getValue().toString());
        switch (expression.getOperator()) {
            case PLUS: {
                result = operand1.add(operand2);
                break;
            }
            case MINUS: {
                result = operand1.subtract(operand2);
                break;
            }
            case TIMES: {
                result = operand1.multiply(operand2);
                break;
            }
            case DIVIDE: {
                result = operand1.divide(operand2);
                break;
            }
            case MODULO: {
                result = operand1.remainder(operand2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        EClassifier classifier = (EClassifier)this.classifierSizeList.get(Math.max(this.classifierSizeList.indexOf(leftVariable.getClassifier()), this.classifierSizeList.indexOf(rightVariable.getClassifier())));
        if (classifier == EcorePackage.Literals.EBYTE || classifier == EcorePackage.Literals.EBYTE_OBJECT) {
            finalResult = result.byteValue();
        } else if (classifier == EcorePackage.Literals.EINT || classifier == EcorePackage.Literals.EINTEGER_OBJECT) {
            finalResult = result.intValue();
        } else if (classifier == EcorePackage.Literals.EDOUBLE || classifier == EcorePackage.Literals.EDOUBLE_OBJECT) {
            finalResult = result.doubleValue();
        } else if (classifier == EcorePackage.Literals.EFLOAT || classifier == EcorePackage.Literals.EFLOAT_OBJECT) {
            finalResult = Float.valueOf(result.floatValue());
        } else if (classifier == EcorePackage.Literals.ELONG || classifier == EcorePackage.Literals.ELONG_OBJECT) {
            finalResult = result.longValue();
        } else if (classifier == EcorePackage.Literals.ESHORT || classifier == EcorePackage.Literals.ESHORT_OBJECT) {
            finalResult = result.shortValue();
        } else {
            throw new UnsupportedOperationException();
        }
        return new Variable("##internal_variable", (Object)classifier, (Object)finalResult);
    }

    private Variable<EClassifier> evaluate(LogicalExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        Variable leftVariable = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getLeftExpression(), (Object)contextClassifier, contextInstance, variablesScope);
        assert (leftVariable != null);
        Variable rightVariable = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getRightExpression(), (Object)contextClassifier, contextInstance, variablesScope);
        assert (rightVariable != null);
        boolean operand1 = (Boolean)leftVariable.getValue();
        boolean operand2 = (Boolean)rightVariable.getValue();
        boolean result = false;
        switch (expression.getOperator()) {
            case AND: {
                result = operand1 && operand2;
                break;
            }
            case OR: {
                result = operand1 || operand2;
                break;
            }
            case EQUIVALENT: {
                result = operand1 && operand2 || !operand1 && !operand2;
                break;
            }
            case IMPLY: {
                result = operand1 && operand2 || !operand1;
                break;
            }
            case XOR: {
                result = operand1 && !operand2 || !operand1 && operand2;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new Variable("##internal_variable", (Object)EcorePackage.Literals.EBOOLEAN, (Object)result);
    }

    private Variable<EClassifier> evaluate(AttributeValueExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        try {
            Object result = null;
            if (contextInstance != null) {
                EAttribute attribute = expression.getAttribute();
                Variable var = variablesScope.getVariable(expression.getObject().getName());
                result = var != null ? ((EObject)var.getValue()).eGet((EStructuralFeature)attribute) : ((EObject)contextInstance).eGet((EStructuralFeature)attribute);
            } else {
                result = expression.getAttribute();
            }
            return new Variable("##internal_variable", (Object)EcorePackage.Literals.EJAVA_OBJECT, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SDMException("Could not evaluate AttributeValueExpression.", e);
        }
    }

    private Variable<EClassifier> evaluate(ObjectVariableExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) {
        String name = expression.getObject().getName();
        Variable var = variablesScope.getVariable(name);
        if (var == null) {
            EClassifier type = expression.getObject().getType();
            var = new Variable("##internal_variable", (Object)type, null);
        }
        return var;
    }

    private Variable<EClassifier> evaluate(MethodCallExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        block16: {
            assert (expression.getCallee() != null);
            try {
                StoryDrivenInterpreter sdi;
                Map returnValues;
                Variable returnVariable;
                if (expression.getCallee() instanceof OpaqueCallable) {
                    OpaqueCallable opaqueCallable = (OpaqueCallable)expression.getCallee();
                    String s = opaqueCallable.getName();
                    String className = s.substring(0, s.lastIndexOf(46));
                    String methodName = s.substring(s.lastIndexOf(46) + 1, s.length());
                    Class[] parameterTypes = new Class[expression.getOpaqueCallable().getInParameters().size()];
                    Object[] parameterValues = new Object[expression.getOpaqueCallable().getInParameters().size()];
                    int index = 0;
                    for (EParameter p : opaqueCallable.getInParameters()) {
                        parameterTypes[index] = p.getEType().getInstanceClass();
                        parameterValues[index] = this.getParameterValue(p, (Collection<ParameterBinding>)expression.getOwnedParameterBindings(), contextClassifier, contextInstance, variablesScope);
                        ++index;
                    }
                    assert (opaqueCallable.getOutParameters().size() == 1);
                    Class<?> clazz = Class.forName(className, true, (ClassLoader)this.getExpressionInterpreterManager().getClassLoader());
                    Method method = clazz.getMethod(methodName, parameterTypes);
                    Object instanceObject = null;
                    if (expression.getTarget() != null) {
                        Variable targetVariable = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getTarget(), (Object)contextClassifier, contextInstance, variablesScope);
                        assert (targetVariable != null);
                        instanceObject = targetVariable.getValue();
                    }
                    Object returnValue = method.invoke(instanceObject, parameterValues);
                    if (!((EParameter)opaqueCallable.getOutParameters().get(0)).getEType().isInstance(returnValue)) {
                        throw new SDMException("The return value '" + returnValue + "' is not an instance of the expected return type '" + ((EParameter)opaqueCallable.getOutParameters().get(0)).getEType() + "'.");
                    }
                    return new Variable("##internal_variable", (Object)((EParameter)opaqueCallable.getOutParameters().get(0)).getEType(), returnValue);
                }
                if (!(expression.getCallee() instanceof Activity)) break block16;
                Activity activity = (Activity)expression.getCallee();
                ArrayList<Variable> parameters = new ArrayList<Variable>();
                for (ParameterBinding parameterBinding : expression.getOwnedParameterBindings()) {
                    assert (parameterBinding.getValueExpression() != null);
                    Variable v = this.getExpressionInterpreterManager().evaluateExpression((Object)parameterBinding.getValueExpression(), (Object)contextClassifier, contextInstance, variablesScope);
                    assert (v != null);
                    v = new Variable(parameterBinding.getParameter().getName(), (Object)parameterBinding.getParameter().getEType(), v.getValue());
                    parameters.add(v);
                }
                if (expression.getTarget() != null) {
                    Variable targetVariable = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getTarget(), (Object)contextClassifier, contextInstance, variablesScope);
                    assert (targetVariable != null);
                    Variable thisParameter = new Variable("this", (Object)((EClassifier)targetVariable.getClassifier()), targetVariable.getValue());
                    parameters.add(thisParameter);
                }
                if ((returnVariable = (Variable)(returnValues = (sdi = new StoryDrivenInterpreter((ExpressionInterpreterManager<Activity, ActivityNode, ActivityEdge, StoryPattern, AbstractVariable, AbstractLinkVariable, EClassifier, EStructuralFeature, Expression>)this.getExpressionInterpreterManager(), (NotificationEmitter<Activity, ActivityNode, ActivityEdge, StoryPattern, AbstractVariable, AbstractLinkVariable, EClassifier, EStructuralFeature, Expression>)this.getExpressionInterpreterManager().getNotificationEmitter())).executeActivity(activity, parameters)).get(((EParameter)activity.getOutParameters().get(0)).getName())) != null) {
                    return new Variable("##internal_variable", (Object)((EClassifier)returnVariable.getClassifier()), returnVariable.getValue());
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SDMException("Could not evaluate MethodCallExpression.", e);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Object getParameterValue(EParameter p, Collection<ParameterBinding> parameterBindings, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        for (ParameterBinding b : parameterBindings) {
            if (b.getParameter() != p) continue;
            Variable var = this.getExpressionInterpreterManager().evaluateExpression((Object)b.getValueExpression(), (Object)contextClassifier, contextInstance, variablesScope);
            assert (var != null);
            return var.getValue();
        }
        throw new SDMException("There is no parameter binding for parameter '" + p.getName() + "'.");
    }

    private Variable<EClassifier> evaluate(ComparisonExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        int i;
        Variable leftVariable = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getLeftExpression(), (Object)contextClassifier, contextInstance, variablesScope);
        Variable rightVariable = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getRightExpression(), (Object)contextClassifier, contextInstance, variablesScope);
        Object operand1 = leftVariable.getValue();
        Object operand2 = rightVariable.getValue();
        boolean result = false;
        if (operand1 instanceof Number && operand2 instanceof Number) {
            i = new BigDecimal(operand1.toString()).compareTo(new BigDecimal(operand2.toString()));
        } else if (operand1.getClass() == operand2.getClass()) {
            i = ((Comparable)operand1).compareTo(operand2);
        } else {
            throw new SDMException("Cannot compare '" + operand1 + "' and '" + operand2 + "'.");
        }
        switch (expression.getOperator()) {
            case EQUAL: {
                result = i == 0;
                break;
            }
            case LESS: {
                result = i < 0;
                break;
            }
            case LESS_OR_EQUAL: {
                result = i <= 0;
                break;
            }
            case GREATER: {
                result = i > 0;
                break;
            }
            case GREATER_OR_EQUAL: {
                result = i >= 0;
                break;
            }
            case UNEQUAL: {
                result = i != 0;
                break;
            }
            case REGULAR_EXPRESSION: {
                result = operand1.toString().matches(operand2.toString());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new Variable("##internal_variable", (Object)EcorePackage.Literals.EBOOLEAN, (Object)result);
    }

    private Variable<EClassifier> evaluate(LiteralExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) {
        String v;
        assert (expression.getValue() != null);
        assert (!"".equals(expression.getValue()));
        EDataType type = null;
        Object value = null;
        type = EcorePackage.Literals.EBOOLEAN;
        try {
            value = EcoreFactory.eINSTANCE.createFromString(type, expression.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (value == null) {
            type = EcorePackage.Literals.EINT;
            try {
                value = EcoreFactory.eINSTANCE.createFromString(type, expression.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (value == null) {
            type = EcorePackage.Literals.EBIG_DECIMAL;
            try {
                value = EcoreFactory.eINSTANCE.createFromString(type, expression.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (value == null && ((v = expression.getValue()).startsWith("'") && v.endsWith("'") || v.startsWith("\"") && v.endsWith("\""))) {
            type = EcorePackage.Literals.ESTRING;
            value = EcoreFactory.eINSTANCE.createFromString(type, v.substring(1, v.length() - 1));
        }
        assert (type != null);
        assert (value != null);
        return new Variable("##internal_variable", (Object)type, value);
    }

    private Variable<EClassifier> evaluate(UnaryExpression expression, EClassifier contextClassifier, Object contextInstance, VariablesScope<?, ?, ?, ?, ?, ?, EClassifier, ?, Expression> variablesScope) throws SDMException {
        assert (expression.getEnclosedExpression() != null);
        Variable result = this.getExpressionInterpreterManager().evaluateExpression((Object)expression.getEnclosedExpression(), (Object)contextClassifier, contextInstance, variablesScope);
        assert (result.getValue() instanceof Boolean);
        return new Variable("##internal_variable", (Object)EcorePackage.Literals.EBOOLEAN, (Object)((Boolean)result.getValue() == false ? 1 : 0));
    }
}

