/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.interpreter.patternmatcher;

import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.notifications.Notifier;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.ECheckResult;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.EMatchType;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.MatchState;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.PatternPartBasedMatcher;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.storydriven.core.expressions.Expression;
import org.storydriven.storydiagrams.interpreter.patternmatcher.StoryDrivenInclusionLinkMatchState;
import org.storydriven.storydiagrams.interpreter.patternmatcher.StoryDrivenPatternPart;
import org.storydriven.storydiagrams.patterns.AbstractLinkVariable;
import org.storydriven.storydiagrams.patterns.AbstractVariable;
import org.storydriven.storydiagrams.patterns.BindingOperator;
import org.storydriven.storydiagrams.patterns.InclusionLink;
import org.storydriven.storydiagrams.patterns.ObjectVariable;

public class StoryDrivenInclusionLinkPatternPart
extends StoryDrivenPatternPart<AbstractVariable, InclusionLink> {
    public StoryDrivenInclusionLinkPatternPart(PatternPartBasedMatcher<?, ?, ?, ?, AbstractVariable, AbstractLinkVariable, EClassifier, ?, Expression> patternMatcher, InclusionLink link) {
        super(patternMatcher, (AbstractLinkVariable)link, new AbstractVariable[]{link.getSource(), link.getTarget()});
    }

    @Override
    protected EMatchType doGetMatchType() {
        switch (((InclusionLink)this.link).getBindingOperator()) {
            case CHECK_ONLY: {
                switch (((InclusionLink)this.link).getBindingSemantics()) {
                    case MANDATORY: {
                        return EMatchType.MANDATORY;
                    }
                    case OPTIONAL: {
                        return EMatchType.OPTIONAL;
                    }
                    case NEGATIVE: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            case CREATE: {
                throw new UnsupportedOperationException();
            }
            case DESTROY: {
                switch (((InclusionLink)this.link).getBindingSemantics()) {
                    case MANDATORY: {
                        return EMatchType.MANDATORY;
                    }
                    case OPTIONAL: {
                        return EMatchType.OPTIONAL;
                    }
                    case NEGATIVE: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doCreateLink() {
    }

    @Override
    protected void doDestroyLink(Map<AbstractVariable, Object> deletedObjects) {
        Variable sourceVariable;
        assert (((InclusionLink)this.link).getBindingOperator() == BindingOperator.DESTROY);
        ObjectVariable sourceVar = ((InclusionLink)this.link).getSource();
        AbstractVariable targetVar = ((InclusionLink)this.link).getTarget();
        assert (deletedObjects.get(targetVar) == null || deletedObjects.get(targetVar) instanceof EObject);
        Object sourceInstanceObject = deletedObjects.get(sourceVar);
        if (sourceInstanceObject == null && (sourceVariable = this.patternMatcher.getVariablesScope().getVariable(sourceVar.getName())) != null) {
            sourceInstanceObject = sourceVariable.getValue();
        }
        EObject targetInstanceObject = (EObject)deletedObjects.get(targetVar);
        if (sourceInstanceObject != null && targetInstanceObject == null) {
            Variable targetVariable = this.patternMatcher.getVariablesScope().getVariable(targetVar.getName());
            assert (targetVariable != null);
            assert (targetVariable.getValue() instanceof EObject);
            targetInstanceObject = (EObject)targetVariable.getValue();
            EObject container = targetInstanceObject.eContainer();
            if (!targetInstanceObject.eContainingFeature().isMany()) {
                container.eSet(targetInstanceObject.eContainingFeature(), null);
            } else {
                ((Collection)container.eGet(targetInstanceObject.eContainingFeature())).remove(targetInstanceObject);
            }
        }
        this.patternMatcher.getNotificationEmitter().instanceLinkDestroyed((Object)sourceVar, sourceInstanceObject, (Object)this.link, (Object)targetVar, (Object)targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
    }

    public ECheckResult check() throws SDMException {
        if (this.patternMatcher.isBound((Object)((InclusionLink)this.link).getSource()) && this.patternMatcher.isBound((Object)((InclusionLink)this.link).getTarget())) {
            ObjectVariable sourceVar = ((InclusionLink)this.link).getSource();
            AbstractVariable targetVar = ((InclusionLink)this.link).getTarget();
            Variable sourceVariable = this.patternMatcher.getVariablesScope().getVariable(sourceVar.getName());
            Variable targetVariable = this.patternMatcher.getVariablesScope().getVariable(targetVar.getName());
            if (sourceVariable != null && targetVariable != null) {
                assert (sourceVariable.getValue() != null);
                assert (targetVariable.getValue() != null);
                assert (sourceVariable.getValue() instanceof EObject);
                EObject sourceInstanceObject = (EObject)sourceVariable.getValue();
                Object targetInstanceObject = targetVariable.getValue();
                TreeIterator it = sourceInstanceObject.eAllContents();
                while (it.hasNext()) {
                    if (it.next() != targetInstanceObject) continue;
                    this.patternMatcher.getNotificationEmitter().linkCheckSuccessful((Object)sourceVar, (Object)sourceInstanceObject, (Object)this.link, (Object)targetVar, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                    return ECheckResult.OK;
                }
                this.patternMatcher.getNotificationEmitter().linkCheckFailed((Object)sourceVar, (Object)sourceInstanceObject, (Object)this.link, (Object)targetVar, targetInstanceObject, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
                return ECheckResult.FAIL;
            }
            return ECheckResult.UNKNOWN;
        }
        return ECheckResult.UNKNOWN;
    }

    public int calculateMatchingCost() {
        assert (!this.patternMatcher.isBound((Object)((InclusionLink)this.link).getSource()) || !this.patternMatcher.isBound((Object)((InclusionLink)this.link).getTarget()));
        if (this.patternMatcher.isBound((Object)((InclusionLink)this.link).getTarget())) {
            return 5;
        }
        if (this.patternMatcher.isBound((Object)((InclusionLink)this.link).getSource())) {
            return 0x7FFFFFFE;
        }
        return -1;
    }

    public boolean match(MatchState matchState) throws SDMException {
        assert (matchState != null);
        assert (matchState instanceof StoryDrivenInclusionLinkMatchState);
        StoryDrivenInclusionLinkMatchState ms = (StoryDrivenInclusionLinkMatchState)matchState;
        ObjectVariable sourceSpo = ((InclusionLink)this.link).getSource();
        AbstractVariable targetSpo = ((InclusionLink)this.link).getTarget();
        if (this.patternMatcher.isBound((Object)sourceSpo)) {
            assert (!this.patternMatcher.isBound((Object)targetSpo));
            EObject sourceInstanceObject = (EObject)this.patternMatcher.getInstanceObject((Object)sourceSpo);
            this.patternMatcher.getNotificationEmitter().traversingLink((Object)this.link, (Object)sourceSpo, (Object)sourceInstanceObject, (Object)targetSpo, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
            TreeIterator iterator = (TreeIterator)ms.getLinkIterator();
            if (iterator == null) {
                iterator = sourceInstanceObject.eAllContents();
                ms.setLinkIterator(iterator);
                ms.setSourceInstanceObject(sourceInstanceObject);
                ms.setLastContainer(null);
            }
            while (iterator.hasNext()) {
                Object targetObject = iterator.next();
                if (!this.patternMatcher.matchStoryPatternObject((Object)targetSpo, targetObject)) continue;
                return true;
            }
            this.patternMatcher.getNotificationEmitter().storyPatternObjectNotBound((Object)targetSpo, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        } else if (this.patternMatcher.isBound((Object)targetSpo)) {
            assert (!this.patternMatcher.isBound((Object)sourceSpo));
            EObject targetInstanceObject = (EObject)this.patternMatcher.getInstanceObject((Object)targetSpo);
            this.patternMatcher.getNotificationEmitter().traversingLink((Object)this.link, (Object)targetSpo, (Object)targetInstanceObject, (Object)sourceSpo, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
            EObject sourceInstanceObject = ms.getLastContainer();
            if (sourceInstanceObject == null) {
                sourceInstanceObject = targetInstanceObject.eContainer();
                ms.setLastContainer(sourceInstanceObject);
                ms.setLinkIterator(null);
                ms.setSourceInstanceObject(targetInstanceObject);
            }
            while (sourceInstanceObject != null) {
                if (this.patternMatcher.matchStoryPatternObject((Object)sourceSpo, (Object)sourceInstanceObject)) {
                    ms.setLastContainer(sourceInstanceObject);
                    return true;
                }
                sourceInstanceObject = sourceInstanceObject.eContainer();
            }
            ms.setLastContainer(null);
            this.patternMatcher.getNotificationEmitter().storyPatternObjectNotBound((Object)sourceSpo, this.patternMatcher.getVariablesScope(), (Notifier)this.patternMatcher);
        } else {
            throw new UnsupportedOperationException();
        }
        return false;
    }

    public MatchState createMatchState() {
        return new StoryDrivenInclusionLinkMatchState();
    }
}

