/*
 * Decompiled with CFR 0.152.
 */
package org.storydriven.storydiagrams.patterns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum BindingSemantics implements Enumerator
{
    MANDATORY(0, "MANDATORY", "MANDATORY"),
    NEGATIVE(1, "NEGATIVE", "NEGATIVE"),
    OPTIONAL(2, "OPTIONAL", "OPTIONAL");

    public static final int MANDATORY_VALUE = 0;
    public static final int NEGATIVE_VALUE = 1;
    public static final int OPTIONAL_VALUE = 2;
    private static final BindingSemantics[] VALUES_ARRAY;
    public static final List<BindingSemantics> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new BindingSemantics[]{MANDATORY, NEGATIVE, OPTIONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static BindingSemantics get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingSemantics result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingSemantics getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            BindingSemantics result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static BindingSemantics get(int value) {
        switch (value) {
            case 0: {
                return MANDATORY;
            }
            case 1: {
                return NEGATIVE;
            }
            case 2: {
                return OPTIONAL;
            }
        }
        return null;
    }

    private BindingSemantics(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

