/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.popup.actions;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import tools.descartes.dlim.exporter.utils.DlimFileUtils;
import tools.descartes.dlim.generator.editor.utils.ProjectManager;
import tools.descartes.dlim.presentation.DlimEditorPlugin;
import tools.descartes.dlim.reader.RequestTimeSeriesReader;

public class TimeSeriesReaderAction
implements IObjectActionDelegate {
    private Shell shell;
    private ISelection currentSelection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        ProjectManager pManager = new ProjectManager(this.currentSelection);
        IResource selectedResource = DlimFileUtils.getResourceFromSelection((ISelection)this.currentSelection);
        String filePath = selectedResource.getRawLocation().toString();
        File outputFolder = new File(String.valueOf(pManager.getProjectPath()) + "/arrivalRates");
        if (!outputFolder.exists()) {
            outputFolder.mkdir();
        }
        RequestTimeSeriesReader.createArrivalRatesFromSortedTimeStamps((String)filePath, (String)outputFolder.getAbsolutePath());
        MessageDialog.openInformation((Shell)this.shell, (String)"Dlim Editor", (String)("Reading time-series " + filePath + "."));
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                p.refreshLocal(2, null);
            }
            catch (CoreException e) {
                DlimEditorPlugin.INSTANCE.log(new Status(1, "tools.descartes.dlim.presentation.DlimEditorPlugin", "Failed to refresh Workspace", (Throwable)e));
            }
            ++n2;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.currentSelection = selection;
    }
}

