/*
 * Decompiled with CFR 0.152.
 */
package tools.descartes.dlim.generator.editor.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import tools.descartes.dlim.Sequence;
import tools.descartes.dlim.generator.ArrivalRateTuple;
import tools.descartes.dlim.generator.ModelEvaluator;
import tools.descartes.dlim.generator.util.ConcurrentModelEvaluator;
import tools.descartes.dlim.util.MathUtil;

public class PlotCanvas
extends Canvas {
    private double samplingStep = 1.0;
    private static final String XAXISLABEL = "time";
    private static final String YAXISLABEL_TOP = "   load";
    private static final String YAXISLABEL_BOTTOM = "intensity";
    private static final int YMARGIN = 10;
    private static final int XMARGIN = 10;
    private static final int AXISMARKERSIZE = 4;
    private int yTopMargin = 0;
    private int yAxisMargin = 0;
    private int xAxisMargin = 0;
    private int xRightMargin = 0;
    private Sequence rootSequence = null;
    private ArrayList<ArrivalRateTuple> arrivalRateList = new ArrayList();
    private ArrayList<ArrivalRateTuple> innerArrivalRateList = new ArrayList();
    private List<ArrivalRateTuple> arrivalRateFileList;
    private boolean drawAxes = false;
    private boolean drawCombinatorImpact = false;
    private boolean plottingFile = false;
    private boolean drawLegend = true;

    public PlotCanvas(Composite parent, int style, boolean drawAxis) {
        super(parent, style);
        this.drawAxes = drawAxis;
        if (this.drawAxes) {
            this.yTopMargin = 10;
            this.yAxisMargin = 34;
            this.xAxisMargin = 40;
        }
        this.setLayoutData(new GridData(4, 0x1000000));
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PlotCanvas.this.paintOnDisplay(e.display, (Drawable)PlotCanvas.this, PlotCanvas.this.getSize().x, PlotCanvas.this.getSize().y);
            }
        });
    }

    public void setRightMargin(int margin) {
        this.xRightMargin = margin;
    }

    public void setRootSequence(Sequence rootSequence) {
        this.rootSequence = rootSequence;
    }

    public void setDecompositionMode(boolean decompose) {
        this.drawCombinatorImpact = decompose;
    }

    public void setPlottingFile(boolean plottingFile) {
        this.plottingFile = plottingFile;
    }

    public void setArrivalRateFileList(List<ArrivalRateTuple> arrivalRateFileList) {
        this.arrivalRateFileList = arrivalRateFileList;
    }

    public boolean isDrawLegend() {
        return this.drawLegend;
    }

    public void setDrawLegend(boolean drawLegend) {
        this.drawLegend = drawLegend;
    }

    public void savePlotCanvasImage(String path, int width, int height) {
        Display display = this.getDisplay();
        Image image = new Image((Device)display, width, height);
        this.paintOnDisplay(display, (Drawable)image, width, height);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(path, 5);
        image.dispose();
    }

    protected void paintOnDisplay(Display display, Drawable parent, int width, int height) {
        this.arrivalRateList.clear();
        this.innerArrivalRateList.clear();
        double maxArrivalRate = 0.0;
        int maxY = height - 10 - this.yAxisMargin;
        int yHeight = maxY - this.yTopMargin - 10;
        int xOffset = 10 + this.xAxisMargin;
        int xWidth = width - xOffset - 10 - this.xRightMargin;
        GC gc = new GC(parent);
        gc.setBackground(display.getSystemColor(1));
        gc.setForeground(display.getSystemColor(1));
        gc.fillRectangle(0, 0, width, height);
        if (this.rootSequence != null) {
            gc.setForeground(display.getSystemColor(2));
            int lastY = maxY;
            int lastInnerY = maxY;
            ModelEvaluator evaluator = new ModelEvaluator(this.rootSequence, 5, "dlim:evaluation");
            this.samplingStep = evaluator.getTerminatingDuration() / (double)xWidth;
            ConcurrentModelEvaluator concEvaluator = new ConcurrentModelEvaluator(evaluator);
            this.arrivalRateList = concEvaluator.evaluateForTimeStamps(this.samplingStep / 2.0, evaluator.getTerminatingDuration(), this.samplingStep);
            maxArrivalRate = concEvaluator.getMax();
            double i = this.samplingStep / 2.0;
            while (i < evaluator.getTerminatingDuration()) {
                if (this.drawCombinatorImpact) {
                    double innerY = evaluator.getArrivalRateDelta(i, -1, new boolean[1]);
                    this.innerArrivalRateList.add(new ArrivalRateTuple(i, innerY));
                    if (innerY > maxArrivalRate) {
                        maxArrivalRate = innerY;
                    }
                }
                i += this.samplingStep;
            }
            if (this.plottingFile && this.arrivalRateFileList != null && this.arrivalRateFileList.size() > 1) {
                for (ArrivalRateTuple t : this.arrivalRateFileList) {
                    if (!(t.getArrivalRate() > maxArrivalRate)) continue;
                    if (t.getTimeStamp() > evaluator.getTerminatingDuration()) break;
                    maxArrivalRate = t.getArrivalRate();
                }
            }
            for (ArrivalRateTuple t : this.arrivalRateList) {
                int y = (int)((double)maxY - t.getArrivalRate() * (double)yHeight / maxArrivalRate);
                int x1 = xOffset + (int)((t.getTimeStamp() - this.samplingStep / 2.0) * (double)xWidth / evaluator.getTerminatingDuration());
                int x2 = xOffset + (int)((t.getTimeStamp() + this.samplingStep / 2.0) * (double)xWidth / evaluator.getTerminatingDuration());
                if (this.drawCombinatorImpact) {
                    double innerSequenceArrRate;
                    double cl = innerSequenceArrRate = this.innerArrivalRateList.get(this.arrivalRateList.indexOf(t)).getArrivalRate();
                    double cs = innerSequenceArrRate;
                    int i2 = 0;
                    while (i2 < this.rootSequence.getCombine().size()) {
                        int rectHeight;
                        int grayScale = 170 + (i2 + 1) * 85 / (this.rootSequence.getCombine().size() + 1);
                        boolean[] isMult = new boolean[1];
                        double delta = evaluator.getArrivalRateDelta(t.getTimeStamp(), i2, isMult);
                        Color rectColor = isMult[0] ? new Color((Device)display, grayScale, grayScale, 0) : new Color((Device)display, grayScale, 0, 0);
                        gc.setBackground(rectColor);
                        int innerY = (int)((double)maxY - innerSequenceArrRate * (double)yHeight / maxArrivalRate);
                        if (delta < 0.0) {
                            int csY = (int)((double)maxY - cs * (double)yHeight / maxArrivalRate);
                            rectHeight = (int)((double)maxY - (cs + delta) * (double)yHeight / maxArrivalRate) - csY;
                            gc.fillRectangle(x1, csY, x2 - x1, rectHeight);
                            cs += delta;
                        } else if (delta > 0.0) {
                            int clY = (int)((double)maxY - cl * (double)yHeight / maxArrivalRate);
                            rectHeight = (int)((double)maxY - (cl + delta) * (double)yHeight / maxArrivalRate) - clY;
                            gc.fillRectangle(x1, clY, x2 - x1, rectHeight);
                            cl += delta;
                        }
                        rectColor.dispose();
                        gc.setLineStyle(3);
                        Color functionColor = new Color((Device)display, 120, 120, 190);
                        gc.setForeground(functionColor);
                        gc.drawLine(x1, lastInnerY, x1, innerY);
                        gc.drawLine(x1, innerY, x2, innerY);
                        gc.setForeground(display.getSystemColor(2));
                        functionColor.dispose();
                        lastInnerY = innerY;
                        ++i2;
                    }
                }
                gc.setForeground(display.getSystemColor(2));
                gc.setBackground(display.getSystemColor(1));
                gc.setLineStyle(1);
                gc.drawLine(x1, lastY, x1, y);
                gc.drawLine(x1, y, x2, y);
                lastY = y;
            }
            if (this.plottingFile && this.arrivalRateFileList != null && this.arrivalRateFileList.size() > 1) {
                double step = this.arrivalRateFileList.get(0).getStep(this.arrivalRateFileList.get(1));
                for (ArrivalRateTuple t : this.arrivalRateFileList) {
                    int y = (int)((double)maxY - t.getArrivalRate() * (double)yHeight / maxArrivalRate);
                    int x1 = xOffset + (int)((t.getTimeStamp() - step / 2.0) * (double)xWidth / evaluator.getDuration());
                    int x2 = xOffset + (int)((t.getTimeStamp() + step / 2.0) * (double)xWidth / evaluator.getDuration());
                    gc.setForeground(display.getSystemColor(15));
                    gc.setBackground(display.getSystemColor(1));
                    gc.setLineStyle(1);
                    gc.drawLine(x1, lastY, x1, y);
                    gc.drawLine(x1, y, x2, y);
                    lastY = y;
                }
            }
            if (this.drawAxes) {
                gc.setForeground(display.getSystemColor(2));
                gc.setBackground(display.getSystemColor(1));
                gc.setLineStyle(1);
                gc.drawText(this.rootSequence.getName(), 10, height - 10 - 4);
                gc.drawText("0", xOffset - 16, maxY - 7);
                gc.drawText("0", xOffset - 2, maxY + 10);
                gc.drawLine(xOffset - 4, maxY, width - 10 - this.xRightMargin, maxY);
                gc.drawLine(xOffset, maxY + 4, xOffset, 10 + this.yTopMargin);
                gc.drawLine(xOffset + xWidth, maxY - 4, xOffset + xWidth, maxY + 4);
                gc.drawLine(xOffset - 4, 10 + this.yTopMargin, xOffset + 4, 10 + this.yTopMargin);
                gc.drawText(YAXISLABEL_TOP, 2, maxY - yHeight / 2 - 15);
                gc.drawText(YAXISLABEL_BOTTOM, 2, maxY - yHeight / 2 + 1);
                gc.drawText(XAXISLABEL, xOffset + xWidth / 2 - 8, maxY + 6);
                String durationString = MathUtil.formatDoubleForDecimalPlaces((double)evaluator.getTerminatingDuration(), (int)2);
                String maxArrivalRateString = MathUtil.formatDoubleForDecimalPlaces((double)maxArrivalRate, (int)2);
                gc.drawText(durationString, width - this.xRightMargin - durationString.length() * 6 - 2, maxY + 10);
                gc.drawText(maxArrivalRateString, Math.max(0, xOffset - 12 - 6 * maxArrivalRateString.length()), 10 + this.yTopMargin - 7, true);
                if (this.plottingFile) {
                    gc.setForeground(display.getSystemColor(2));
                    gc.setBackground(display.getSystemColor(1));
                    gc.drawText("arrival rates from file", width - 10 - 120, height - 10 - 8, true);
                    gc.setForeground(display.getSystemColor(15));
                    gc.setLineStyle(1);
                    gc.drawLine(width - 10 - 124, height - 10 - 1, width - 10 - 148, height - 10 - 1);
                }
                if (this.drawCombinatorImpact && this.drawLegend) {
                    int grayScale = 212;
                    gc.setForeground(display.getSystemColor(2));
                    gc.setBackground(display.getSystemColor(1));
                    gc.drawText("impact of additive Combinator", width - 10 - 340, height - 10 - 8, true);
                    gc.drawText("impact of multiplicative Combinator", width - 10 - 593, height - 10 - 8, true);
                    gc.drawText("original function", width - 10 - 736, height - 10 - 8, true);
                    Color functionColor = new Color((Device)display, grayScale, 0, 0);
                    gc.setBackground(functionColor);
                    gc.fillRectangle(width - 10 - 358, height - 10 - 6, 12, 12);
                    functionColor.dispose();
                    functionColor = new Color((Device)display, grayScale, grayScale, 0);
                    gc.setBackground(functionColor);
                    gc.fillRectangle(width - 10 - 611, height - 10 - 6, 12, 12);
                    functionColor.dispose();
                    gc.setBackground(display.getSystemColor(1));
                    gc.setLineStyle(3);
                    functionColor = new Color((Device)display, 120, 120, 190);
                    gc.setForeground(functionColor);
                    gc.drawLine(width - 10 - 740, height - 10 - 1, width - 10 - 764, height - 10 - 1);
                    gc.setForeground(display.getSystemColor(2));
                    functionColor.dispose();
                    gc.setLineStyle(1);
                }
            }
        }
        gc.dispose();
    }
}

