/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.core;

import de.mdelab.sdm.interpreter.core.AbortInterpretationException;
import de.mdelab.sdm.interpreter.core.SDMException;
import de.mdelab.sdm.interpreter.core.expressions.ExpressionInterpreterManager;
import de.mdelab.sdm.interpreter.core.facade.IActivityEdgeFacade;
import de.mdelab.sdm.interpreter.core.facade.IActivityFacade;
import de.mdelab.sdm.interpreter.core.facade.IDecisionNodeFacade;
import de.mdelab.sdm.interpreter.core.facade.IExpressionNodeFacade;
import de.mdelab.sdm.interpreter.core.facade.IStoryNodeFacade;
import de.mdelab.sdm.interpreter.core.facade.IUnspecificActivityNodeFacade;
import de.mdelab.sdm.interpreter.core.facade.MetamodelFacadeFactory;
import de.mdelab.sdm.interpreter.core.notifications.NotificationEmitter;
import de.mdelab.sdm.interpreter.core.notifications.Notifier;
import de.mdelab.sdm.interpreter.core.patternmatcher.StoryPatternMatcher;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.DefaultMatchingStrategyWithLog;
import de.mdelab.sdm.interpreter.core.patternmatcher.patternPartBased.LogReproducingMatchingStrategy;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import de.mdelab.sdm.interpreter.core.variables.VariablesScope;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class SDMInterpreter<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>
extends Notifier<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> {
    private final ExpressionInterpreterManager<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> expressionInterpreterManager;
    private final MetamodelFacadeFactory<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> facadeFactory;
    private ActivityNode nextNode;
    private final Map<ActivityNode, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>> variableScopes;
    private final Map<StoryPattern, StoryPatternMatcher<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>> storyPatternMatchers;

    public SDMInterpreter(MetamodelFacadeFactory<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> facadeFactory, ExpressionInterpreterManager<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> expressionInterpreterManager, NotificationEmitter<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> notificationEmitter) {
        super(notificationEmitter);
        assert (facadeFactory != null);
        assert (expressionInterpreterManager != null);
        this.expressionInterpreterManager = expressionInterpreterManager;
        this.facadeFactory = facadeFactory;
        this.variableScopes = new HashMap<ActivityNode, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>>();
        this.storyPatternMatchers = new HashMap<StoryPattern, StoryPatternMatcher<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>>();
    }

    public ExpressionInterpreterManager<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> getExpressionInterpreterManager() {
        return this.expressionInterpreterManager;
    }

    public MetamodelFacadeFactory<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> getFacadeFactory() {
        return this.facadeFactory;
    }

    public Map<String, Variable<Classifier>> executeActivity(Activity activity, Collection<Variable<Classifier>> parameters) throws SDMException {
        if (activity == null) {
            throw new SDMException("activity is null.");
        }
        IActivityFacade<Activity, ActivityNode> activityFacade = this.facadeFactory.getActivityFacade();
        VariablesScope variableScope = new VariablesScope(this.getNotificationEmitter(), null, activityFacade.getExpressionImports(activity));
        this.getNotificationEmitter().activityExecutionStarted(activity, parameters, variableScope, this);
        if (parameters != null) {
            for (Variable<Classifier> variable : parameters) {
                assert (variable.getName() != null);
                assert (!"".equals(variable.getName()));
                assert (variable.getClassifier() != null);
                variableScope.createVariable(variable.getName(), variable.getClassifier(), variable.getValue());
            }
        }
        this.nextNode = activityFacade.getInitialNode(activity);
        if (this.nextNode == null) {
            throw new SDMException("The activity " + activity + " does not contain an initial node.");
        }
        this.variableScopes.put(this.nextNode, variableScope);
        Object lastNode = null;
        Object n = null;
        do {
            block12: {
                lastNode = this.nextNode;
                this.nextNode = null;
                try {
                    n = this.executeActivityNode(lastNode, this.variableScopes.get(lastNode));
                }
                catch (AbortInterpretationException e) {
                    if (e.getTargetInterpreter() == this) break block12;
                    throw e;
                }
            }
            if (this.nextNode != null) continue;
            this.nextNode = n;
        } while (this.nextNode != null);
        HashMap returnValues = new HashMap();
        Map<String, Expression> outParameterExpressions = this.facadeFactory.getFinalNodeFacade().getOutParameterExpressions(lastNode);
        if (outParameterExpressions != null) {
            for (Map.Entry<String, Expression> entry : outParameterExpressions.entrySet()) {
                Variable<Object> result = this.getExpressionInterpreterManager().evaluateExpression(entry.getValue(), null, null, variableScope);
                Variable<Object> resultVar = new Variable<Object>(entry.getKey(), result.getClassifier(), result.getValue());
                returnValues.put(resultVar.getName(), resultVar);
            }
        }
        this.getNotificationEmitter().activityExecutionFinished(activity, returnValues, variableScope, this);
        this.variableScopes.clear();
        this.storyPatternMatchers.clear();
        return returnValues;
    }

    protected ActivityNode executeActivityNode(ActivityNode node, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> variablesScope) throws SDMException {
        assert (node != null);
        assert (variablesScope != null);
        IUnspecificActivityNodeFacade<ActivityNode, ActivityEdge> unspecificActivityNodeFacade = this.facadeFactory.getUnspecificActivityNodeFacade();
        ActivityNode nextNode = null;
        switch (unspecificActivityNodeFacade.getActivityNodeType(node)) {
            case NON_EXECUTABLE_NODE: {
                this.getNotificationEmitter().activityNodeExecutionStarted(node, variablesScope, this);
                ActivityEdge nextEdge = unspecificActivityNodeFacade.getNextActivityEdge(node);
                this.getNotificationEmitter().activityNodeExecutionFinished(node, variablesScope, this);
                nextNode = this.executeActivityEdge(nextEdge, variablesScope);
                break;
            }
            case STORY_NODE: {
                nextNode = this.executeStoryNode(node, variablesScope);
                break;
            }
            case DECISION_NODE: {
                nextNode = this.executeDecisionNode(node, variablesScope);
                break;
            }
            case ACTIVITY_FINAL_NODE: 
            case FLOW_FINAL_NODE: {
                this.getNotificationEmitter().activityNodeExecutionStarted(node, variablesScope, this);
                this.getNotificationEmitter().activityNodeExecutionFinished(node, variablesScope, this);
                return null;
            }
            case STATEMENT_NODE: {
                nextNode = this.executeStatementNode(node, variablesScope);
                break;
            }
            case CUSTOM_NODE: {
                nextNode = this.executeCustomNode(node, variablesScope);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (nextNode == null) {
            throw new SDMException("Node '" + unspecificActivityNodeFacade.getName(node) + "' has no successor node.");
        }
        this.variableScopes.put(nextNode, variablesScope);
        return nextNode;
    }

    protected ActivityNode executeStatementNode(ActivityNode node, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> variablesScope) throws SDMException {
        this.getNotificationEmitter().activityNodeExecutionStarted(node, variablesScope, this);
        IExpressionNodeFacade<ActivityNode, ActivityEdge, Expression> expressionNodeFacade = this.getFacadeFactory().getExpressionNodeFacade();
        for (Expression expression : expressionNodeFacade.getExpressions(node)) {
            this.getExpressionInterpreterManager().evaluateExpression(expression, null, null, variablesScope);
        }
        this.getNotificationEmitter().activityNodeExecutionFinished(node, variablesScope, this);
        return this.executeActivityEdge(expressionNodeFacade.getNextActivityEdge(node), variablesScope);
    }

    protected ActivityNode executeStoryNode(ActivityNode node, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> variablesScope) throws SDMException {
        switch (this.facadeFactory.getStoryNodeFacade().getForEachSemantics(node)) {
            case SINGLE_MATCH: {
                return this.executeSingleMatchStoryNode(node, variablesScope);
            }
            case FRESH_MATCH: {
                return this.executeForEachFreshMatchStoryNode(node, variablesScope);
            }
        }
        throw new UnsupportedOperationException();
    }

    protected ActivityNode executeSingleMatchStoryNode(ActivityNode node, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> variablesScope) throws SDMException {
        this.getNotificationEmitter().activityNodeExecutionStarted(node, variablesScope, this);
        StoryPatternMatcher<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> storyPatternMatcher = this.createStoryPatternMatcher(this.facadeFactory.getStoryNodeFacade().getStoryPattern(node), variablesScope);
        boolean success = storyPatternMatcher.findNextMatch();
        if (success) {
            storyPatternMatcher.applyMatch();
        }
        IStoryNodeFacade<ActivityNode, ActivityEdge, StoryPattern> storyNodeFacade = this.facadeFactory.getStoryNodeFacade();
        this.getNotificationEmitter().activityNodeExecutionFinished(node, variablesScope, this);
        ActivityEdge nextEdge = success ? storyNodeFacade.getSuccessNextEdge(node) : storyNodeFacade.getFailureNextEdge(node);
        return this.executeActivityEdge(nextEdge, variablesScope);
    }

    protected ActivityNode executeForEachFreshMatchStoryNode(ActivityNode node, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> variablesScope) throws SDMException {
        this.getNotificationEmitter().activityNodeExecutionStarted(node, variablesScope, this);
        IStoryNodeFacade<ActivityNode, ActivityEdge, StoryPattern> storyNodeFacade = this.facadeFactory.getStoryNodeFacade();
        StoryPattern storyPattern = storyNodeFacade.getStoryPattern(node);
        StoryPatternMatcher<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> storyPatternMatcher = this.storyPatternMatchers.get(storyPattern);
        if (storyPatternMatcher == null) {
            storyPatternMatcher = this.createStoryPatternMatcher(storyPattern, variablesScope);
            this.storyPatternMatchers.put(storyPattern, storyPatternMatcher);
            DefaultMatchingStrategyWithLog<StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> matchingStrategy = new DefaultMatchingStrategyWithLog<StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>(this.facadeFactory);
            storyPatternMatcher.setMatchingStrategy(matchingStrategy);
        } else if (storyPatternMatcher.getMatchingStrategy() instanceof DefaultMatchingStrategyWithLog) {
            storyPatternMatcher.setMatchingStrategy(new LogReproducingMatchingStrategy<StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>(this.facadeFactory, ((DefaultMatchingStrategyWithLog)storyPatternMatcher.getMatchingStrategy()).getLog()));
        }
        ActivityNode nextNode = node;
        if (storyPatternMatcher.findNextMatch()) {
            storyPatternMatcher.applyMatch();
            this.getNotificationEmitter().activityNodeExecutionFinished(node, variablesScope, this);
            ActivityEdge nextEdge = storyNodeFacade.getSuccessNextEdge(node);
            if (nextEdge != null) {
                nextNode = this.executeActivityEdge(nextEdge, variablesScope);
            }
        } else {
            this.getNotificationEmitter().activityNodeExecutionFinished(node, variablesScope, this);
            ActivityEdge nextEdge = storyNodeFacade.getFailureNextEdge(node);
            if (nextEdge == null) {
                throw new SDMException("Missing outgoing link to next node from " + node.toString());
            }
            nextNode = this.executeActivityEdge(nextEdge, variablesScope);
            this.storyPatternMatchers.remove(storyPattern);
        }
        return nextNode;
    }

    protected ActivityNode executeActivityEdge(ActivityEdge nextEdge, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> variablesScope) {
        IActivityEdgeFacade<ActivityNode, ActivityEdge> activityEdgeFacade = this.facadeFactory.getActivityEdgeFacade();
        this.getNotificationEmitter().traversingActivityEdge(nextEdge, variablesScope, this);
        ActivityNode nextNode = activityEdgeFacade.getTarget(nextEdge);
        return nextNode;
    }

    protected ActivityNode executeDecisionNode(ActivityNode node, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> variablesScope) throws SDMException {
        this.getNotificationEmitter().activityNodeExecutionStarted(node, variablesScope, this);
        IDecisionNodeFacade<ActivityNode, ActivityEdge, Expression> decisionNodeFacade = this.getFacadeFactory().getDecisionNodeFacade();
        ActivityEdge nextEdge = null;
        for (Map.Entry<Expression, ActivityEdge> entry : decisionNodeFacade.getConditionalNextEdges(node).entrySet()) {
            Variable<Object> result = this.getExpressionInterpreterManager().evaluateExpression(entry.getKey(), null, null, variablesScope);
            assert (result != null);
            if (!result.getValue().equals(Boolean.TRUE)) continue;
            nextEdge = entry.getValue();
            break;
        }
        this.getNotificationEmitter().activityNodeExecutionFinished(node, variablesScope, this);
        if (nextEdge == null) {
            nextEdge = decisionNodeFacade.getUnconditionalNextEdge(node);
        }
        return this.executeActivityEdge(nextEdge, variablesScope);
    }

    public void setNextNode(ActivityNode nextNode) {
        this.nextNode = nextNode;
    }

    public Map<StoryPattern, StoryPatternMatcher<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>> getStoryPatternMatchers() {
        return this.storyPatternMatchers;
    }

    public Map<ActivityNode, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>> getVariableScopes() {
        return this.variableScopes;
    }

    protected abstract StoryPatternMatcher<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> createStoryPatternMatcher(StoryPattern var1, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> var2) throws SDMException;

    protected abstract ActivityNode executeCustomNode(ActivityNode var1, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> var2) throws SDMException;
}

