/*
 * Decompiled with CFR 0.152.
 */
package de.mdelab.sdm.interpreter.core.variables;

import de.mdelab.sdm.interpreter.core.notifications.NotificationEmitter;
import de.mdelab.sdm.interpreter.core.notifications.Notifier;
import de.mdelab.sdm.interpreter.core.variables.Variable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression>
extends Notifier<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> {
    public static final String INTERNAL_VARIABLE_NAME = "##internalVariable##";
    private final Map<String, Variable<Classifier>> variables = new HashMap<String, Variable<Classifier>>();
    private final Map<String, Map<String, List<String>>> expressionImports;
    private final VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> parentScope;

    public VariablesScope(NotificationEmitter<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> notificationEmitter) {
        this(notificationEmitter, null, Collections.EMPTY_MAP);
    }

    public VariablesScope(NotificationEmitter<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> notificationEmitter, VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> parentScope, Map<String, Map<String, List<String>>> expressionImports) {
        super(notificationEmitter);
        this.expressionImports = expressionImports;
        this.parentScope = parentScope;
    }

    public Variable<Classifier> getVariable(String name) {
        Variable<Classifier> variable = this.variables.get(name);
        if (variable == null && this.parentScope != null) {
            return this.parentScope.getVariable(name);
        }
        return variable;
    }

    public boolean variableExists(String name) {
        if (this.variables.containsKey(name)) {
            return true;
        }
        if (this.parentScope != null) {
            return this.parentScope.variableExists(name);
        }
        return false;
    }

    public Variable<Classifier> deleteVariable(String name) {
        Variable<Classifier> variable = this.variables.remove(name);
        if (variable != null) {
            this.getNotificationEmitter().variableDeleted(variable, this);
        }
        return variable;
    }

    public Variable<Classifier> createVariable(String name, Classifier classifier, Object value) {
        assert (name != null);
        assert (!"".equals(name));
        assert (classifier != null);
        this.deleteVariable(name);
        Variable<Classifier> variable = new Variable<Classifier>(name, classifier, value);
        this.variables.put(name, variable);
        this.getNotificationEmitter().variableCreated(variable, this);
        return variable;
    }

    public Collection<Variable<Classifier>> getVariables() {
        if (this.parentScope == null) {
            return Collections.unmodifiableCollection(this.variables.values());
        }
        LinkedList<Variable<Classifier>> variables = new LinkedList<Variable<Classifier>>(this.variables.values());
        variables.addAll(this.parentScope.getVariables());
        return Collections.unmodifiableCollection(variables);
    }

    public List<String> getExpressionImports(String expressionLanguage, String expressionLanguageVersion) {
        List<String> m2;
        assert (expressionLanguage != null);
        assert (expressionLanguageVersion != null);
        assert (!"".equals(expressionLanguage));
        assert (!"".equals(expressionLanguageVersion));
        Map<String, List<String>> m1 = this.expressionImports.get(expressionLanguage);
        if (m1 != null && (m2 = m1.get(expressionLanguageVersion)) != null) {
            return m2;
        }
        return Collections.emptyList();
    }

    public void changeVariableValue(String name, Object value) {
        assert (this.variableExists(name));
        if (this.variables.containsKey(name)) {
            Variable<Classifier> variable = this.variables.get(name);
            Object oldValue = variable.getValue();
            variable.setValue(value);
            this.getNotificationEmitter().variableValueChanged(variable, oldValue, this);
        } else {
            this.parentScope.changeVariableValue(name, value);
        }
    }

    public VariablesScope<Activity, ActivityNode, ActivityEdge, StoryPattern, StoryPatternObject, StoryPatternLink, Classifier, Feature, Expression> getParentScope() {
        return this.parentScope;
    }

    public void mergeIntoParentScope() throws NullPointerException {
        if (this.parentScope == null) {
            throw new NullPointerException();
        }
        for (Variable<Classifier> variable : this.variables.values()) {
            this.parentScope.variables.put(variable.getName(), variable);
        }
        this.variables.clear();
    }
}

