/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.analysis.reliability;

import de.uka.ipd.sdq.dsexplore.analysis.AbstractAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.AnalysisFailedException;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysis;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.analysis.IAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.analysis.reliability.ReliabilityAnalysisResult;
import de.uka.ipd.sdq.dsexplore.analysis.reliability.ReliabilitySolverQualityAttributeDeclaration;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.UsageScenarioBasedCriterion;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.Criterion;
import org.palladiosimulator.analyzer.workflow.configurations.PCMWorkflowConfigurationBuilder;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.solver.reliability.pcm2markov.MarkovTransformationResult;
import org.palladiosimulator.solver.reliability.pcm2markov.Pcm2MarkovStrategy;
import org.palladiosimulator.solver.reliability.runconfig.PCMSolverReliabilityConfigurationBasedConfigBuilder;
import org.palladiosimulator.solver.reliability.runconfig.RunPCMReliabilityAnalysisJob;
import org.palladiosimulator.solver.runconfig.PCMSolverConfigurationBasedConfigBuilder;
import org.palladiosimulator.solver.runconfig.PCMSolverWorkflowRunConfiguration;

public class ReliabilityAnalysis
extends AbstractAnalysis
implements IAnalysis {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore.analysis.reliability.ReliabilityAnalysis");
    private DSEWorkflowConfiguration config;
    private PCMSolverWorkflowRunConfiguration lastPCMSolverConfiguration;
    private Map<Long, List<MarkovTransformationResult>> previousReliabilityResults = new HashMap<Long, List<MarkovTransformationResult>>();

    public ReliabilityAnalysis() {
        super((IAnalysisQualityAttributeDeclaration)new ReliabilitySolverQualityAttributeDeclaration());
    }

    public void analyse(PCMPhenotype pheno, IProgressMonitor monitor) throws CoreException, JobFailedException, UserCanceledException {
        this.launchReliabilitySolver(pheno, monitor);
    }

    private IAnalysisResult retrieveReliabilitySolverResults(PCMPhenotype pheno, UsageScenario scenario) throws AnalysisFailedException {
        List<MarkovTransformationResult> results = this.previousReliabilityResults.get(pheno.getNumericID());
        MarkovTransformationResult resultForScenario = null;
        for (MarkovTransformationResult markovTransformationResult : results) {
            if (!EMFHelper.checkIdentity((EObject)markovTransformationResult.getScenario(), (EObject)scenario)) continue;
            resultForScenario = markovTransformationResult;
            break;
        }
        if (resultForScenario == null) {
            throw new AnalysisFailedException("Cannot find reliability results. Contact developers.");
        }
        ReliabilityAnalysisResult result = new ReliabilityAnalysisResult(resultForScenario.getSuccessProbability(), this.lastPCMSolverConfiguration);
        return result;
    }

    private void launchReliabilitySolver(PCMPhenotype pheno, IProgressMonitor monitor) throws CoreException, JobFailedException, UserCanceledException {
        PCMSolverWorkflowRunConfiguration solverConfiguration = new PCMSolverWorkflowRunConfiguration();
        PCMWorkflowConfigurationBuilder builder = new PCMWorkflowConfigurationBuilder(this.config.getRawConfiguration(), "run");
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)solverConfiguration);
        builder = new PCMSolverConfigurationBasedConfigBuilder(this.config.getRawConfiguration(), "run");
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)solverConfiguration);
        builder = new PCMSolverReliabilityConfigurationBasedConfigBuilder(this.config.getRawConfiguration(), "run");
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)solverConfiguration);
        solverConfiguration.setShowHtmlResults(false);
        solverConfiguration.setInteractive(false);
        this.lastPCMSolverConfiguration = solverConfiguration;
        RunPCMReliabilityAnalysisJob solverJob = new RunPCMReliabilityAnalysisJob(solverConfiguration);
        solverJob.setBlackboard(this.blackboard);
        solverJob.execute(monitor);
        this.previousReliabilityResults.put(pheno.getNumericID(), ((Pcm2MarkovStrategy)solverJob.getStrategy()).getAllSolvedValues());
        logger.debug((Object)"Finished reliability solver analysis");
    }

    public void initialise(DSEWorkflowConfiguration configuration) throws CoreException {
        this.config = configuration;
        this.initialiseCriteria(configuration);
    }

    public boolean hasStatisticResults() throws CoreException {
        return false;
    }

    public IAnalysisResult retrieveResultsFor(PCMPhenotype pheno, Criterion criterion) throws AnalysisFailedException {
        if (criterion instanceof UsageScenarioBasedCriterion) {
            IAnalysisResult result = this.retrieveReliabilitySolverResults(pheno, ((UsageScenarioBasedCriterion)criterion).getUsageScenario());
            return result;
        }
        throw new RuntimeException("Reliability criteria need to be defined for a usage scenario");
    }

    public boolean hasObjectivePerUsageScenario() throws CoreException {
        return true;
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

