/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.gdof;

import de.uka.ipd.sdq.pcm.designdecision.Candidate;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.gdof.ChangeableElementDescription;
import de.uka.ipd.sdq.pcm.designdecision.gdof.DegreeOfFreedom;
import de.uka.ipd.sdq.pcm.designdecision.gdof.HelperOCLDefinition;
import de.uka.ipd.sdq.pcm.designdecision.gdof.InstanceSelectionRule;
import de.uka.ipd.sdq.pcm.designdecision.gdof.OCLRule;
import de.uka.ipd.sdq.pcm.designdecision.gdof.SelectionRule;
import de.uka.ipd.sdq.pcm.designdecision.gdof.StaticSelectionRule;
import de.uka.ipd.sdq.pcm.designdecision.gdof.ValueRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.SemanticException;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.expressions.OCLExpression;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.solver.models.PCMInstance;

public class GenomeToCandidateModelTransformation {
    private static final OCL OCL_ENV = OCL.newInstance();

    public List<Choice> transform(List<EObject> rootElements, Candidate candidate) {
        EList choices = candidate.getChoices();
        ArrayList<Choice> notTransformedChoices = new ArrayList<Choice>(choices.size());
        for (Choice choice : choices) {
            boolean transSuccessful = this.transformChoice(rootElements, choice);
            if (transSuccessful) continue;
            notTransformedChoices.add(choice);
        }
        return notTransformedChoices;
    }

    public boolean transformChoice(List<EObject> rootElements, Choice choice) {
        if (choice.isActive()) {
            DegreeOfFreedomInstance dofi = choice.getDegreeOfFreedomInstance();
            DegreeOfFreedom gdof = dofi.getDof();
            if (gdof != null) {
                HashMap<ChangeableElementDescription, Collection<EObject>> selectedModelElements = new HashMap<ChangeableElementDescription, Collection<EObject>>();
                EObject modelElement = dofi.getPrimaryChanged();
                EStructuralFeature property = gdof.getPrimaryChangeable().getChangeable();
                GenomeToCandidateModelTransformation.setProperty(modelElement, property, choice.getValue());
                ArrayList<EObject> modelElementList = new ArrayList<EObject>(1);
                modelElementList.add(modelElement);
                selectedModelElements.put(gdof.getPrimaryChangeable(), modelElementList);
                for (ChangeableElementDescription ced : gdof.getChangeableElementDescriptions()) {
                    if (ced == gdof.getPrimaryChangeable()) continue;
                    Collection<EObject> changeableElements = this.selectionRule(ced, rootElements, selectedModelElements);
                    selectedModelElements.put(ced, changeableElements);
                    EStructuralFeature changeableProperty = ced.getChangeable();
                    for (EObject changeableElement : changeableElements) {
                        Object newValue = GenomeToCandidateModelTransformation.valueRule(ced, changeableElement, rootElements);
                        if (newValue instanceof HashSet) {
                            HashSet s = (HashSet)newValue;
                            for (Object val : s) {
                                GenomeToCandidateModelTransformation.setProperty(changeableElement, changeableProperty, val);
                            }
                            continue;
                        }
                        GenomeToCandidateModelTransformation.setProperty(changeableElement, changeableProperty, newValue);
                    }
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static void setProperty(EObject changeableElement, EStructuralFeature property, Object value) {
        EStructuralFeature propertyInLoadedPCM = changeableElement.eClass().getEStructuralFeature(property.getName());
        changeableElement.eSet(propertyInLoadedPCM, value);
    }

    public static Object getProperty(EObject changeableElement, EStructuralFeature property) {
        EStructuralFeature propertyInLoadedPCM = changeableElement.eClass().getEStructuralFeature(property.getName());
        return changeableElement.eGet(propertyInLoadedPCM);
    }

    public static Object valueRule(ChangeableElementDescription ced, EObject changeableElement, List<EObject> rootElements) {
        ValueRule oclValueRule = ced.getValueRule();
        OCL.Query parsedQuery = GenomeToCandidateModelTransformation.parseInstanceContextOCL((OCLRule)oclValueRule, changeableElement, rootElements);
        return parsedQuery.evaluate((Object)changeableElement);
    }

    public static Collection<Object> valueRuleForCollection(ChangeableElementDescription ced, EObject changeableElement, List<EObject> rootElements) {
        Object object = GenomeToCandidateModelTransformation.valueRule(ced, changeableElement, rootElements);
        if (object instanceof Collection) {
            return (Collection)object;
        }
        ArrayList<Object> result = new ArrayList<Object>(1);
        result.add(object);
        return result;
    }

    private Collection<EObject> selectionRule(ChangeableElementDescription ced, List<EObject> rootElements, Map<ChangeableElementDescription, Collection<EObject>> selectedModelElements) {
        SelectionRule oclSelectionRule = ced.getSelectionRule();
        if (oclSelectionRule == null) {
            return this.selectAllInstancesOf(ced.getChangeable().getEContainingClass(), rootElements);
        }
        if (oclSelectionRule instanceof StaticSelectionRule) {
            EClass contextClass = ((StaticSelectionRule)oclSelectionRule).getContextClass();
            OCL.Query parsedQuery = this.parseClassContextOCL((OCLRule)oclSelectionRule, contextClass, rootElements);
            Object result = parsedQuery.evaluate();
            return this.extractEObjectCollection(result);
        }
        if (oclSelectionRule instanceof InstanceSelectionRule) {
            ChangeableElementDescription referencedCED = ((InstanceSelectionRule)oclSelectionRule).getContextInstance();
            Collection<EObject> contextInstances = selectedModelElements.get(referencedCED);
            OCL.Query parsedQuery = this.parseInstanceContextOCL((OCLRule)oclSelectionRule, contextInstances, rootElements);
            Object singleResult = null;
            ArrayList<EObject> resultList = new ArrayList<EObject>(contextInstances.size());
            for (EObject eObject : contextInstances) {
                singleResult = parsedQuery.evaluate((Object)eObject);
                resultList.addAll(this.extractEObjectCollection(singleResult));
            }
            return resultList;
        }
        throw new RuntimeException("Unknown type of selection rule " + oclSelectionRule.getClass().getName());
    }

    private Collection<EObject> extractEObjectCollection(Object result) {
        if (result instanceof ECollections || result instanceof Collection) {
            return (Collection)result;
        }
        if (result instanceof EObject) {
            ArrayList<EObject> list = new ArrayList<EObject>(1);
            list.add((EObject)result);
            return list;
        }
        return null;
    }

    private OCL.Query parseInstanceContextOCL(OCLRule oclRule, Collection<EObject> contextInstances, List<EObject> rootElements) {
        return GenomeToCandidateModelTransformation.parseInstanceContextOCL(oclRule, contextInstances.iterator().next(), rootElements);
    }

    private static OCL.Query parseInstanceContextOCL(OCLRule oclRule, EObject contextInstance, List<EObject> rootElements) {
        OCL.Helper helper = OCL_ENV.createOCLHelper();
        EList helpers = oclRule.getHelperDefinition();
        helper.setInstanceContext((Object)contextInstance);
        GenomeToCandidateModelTransformation.defineHelpers(helper, (List<HelperOCLDefinition>)helpers);
        OCL.Query query = GenomeToCandidateModelTransformation.createOCLQuery(oclRule, helper);
        return query;
    }

    private OCL.Query parseClassContextOCL(OCLRule oclRule, EClass contextClass, List<EObject> rootElements) {
        OCL.Helper helper = OCL_ENV.createOCLHelper();
        EList helpers = oclRule.getHelperDefinition();
        GenomeToCandidateModelTransformation.defineHelpers(helper, (List<HelperOCLDefinition>)helpers);
        helper.setContext((Object)contextClass);
        OCL.Query query = GenomeToCandidateModelTransformation.createOCLQuery(oclRule, helper);
        return query;
    }

    private static void defineHelpers(OCL.Helper helper, List<HelperOCLDefinition> helpers) {
        try {
            for (HelperOCLDefinition helperOCLDefinition : helpers) {
                helper.setContext((Object)helperOCLDefinition.getContextClass());
                try {
                    helper.defineOperation(helperOCLDefinition.getMainOclQuery());
                }
                catch (SemanticException e) {
                    if (!e.getMessage().contains("already defined in type")) {
                        throw e;
                    }
                    System.out.println("already defined in type");
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static OCL.Query createOCLQuery(OCLRule oclRule, OCL.Helper helper) {
        try {
            org.eclipse.ocl.ecore.OCLExpression oclExpresssion = helper.createQuery(oclRule.getMainOclQuery());
            OCL.Query query = OCL_ENV.createQuery((OCLExpression)oclExpresssion);
            return query;
        }
        catch (ParserException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private List<EObject> selectAllInstancesOf(EClass eClass, List<EObject> rootElements) {
        ArrayList<EObject> results = new ArrayList<EObject>();
        for (EObject rootNamedElement : rootElements) {
            TreeIterator iterator = rootNamedElement.eAllContents();
            while (iterator.hasNext()) {
                EObject namedElement = (EObject)iterator.next();
                if (!eClass.isInstance((Object)namedElement)) continue;
                results.add(namedElement);
            }
        }
        return results;
    }

    public List<Choice> transform(PCMInstance pcm, Candidate candidate) {
        List<EObject> rootElements = GenomeToCandidateModelTransformation.getPCMRootElements(pcm);
        return this.transform(rootElements, candidate);
    }

    public static List<EObject> getPCMRootElements(PCMInstance pcm) {
        ArrayList<EObject> rootElements = new ArrayList<EObject>();
        List repos = pcm.getRepositories();
        for (Repository repository : repos) {
            rootElements.add((EObject)repository);
        }
        rootElements.add((EObject)pcm.getSystem());
        rootElements.add((EObject)pcm.getResourceEnvironment());
        rootElements.add((EObject)pcm.getAllocation());
        return rootElements;
    }

    public boolean transformChoice(PCMInstance pcm, Choice choice) {
        List<EObject> rootElements = GenomeToCandidateModelTransformation.getPCMRootElements(pcm);
        return this.transformChoice(rootElements, choice);
    }
}

