/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.dsexplore.helper.ExtensionHelper;
import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DSEAnalysisMethodTab
extends AbstractLaunchConfigurationTab {
    private StackLayout layout;
    private Composite tabFolderContainer;
    private Combo methodCombo;
    private boolean methodComboEnabled = true;
    private Map<String, IConfigurationElement> nameExtensionElementMap;
    private Map<IConfigurationElement, CTabFolder> extensionElementTabFolderMap;
    private Map<IConfigurationElement, ILaunchConfigurationTabGroup> extensionElementTabGroupMap;
    private AnalysisMethodListener listener = new AnalysisMethodListener();
    private DSEConstantsContainer.QualityAttribute qualityAttributeId;

    public DSEAnalysisMethodTab(DSEConstantsContainer.QualityAttribute qualityAttribute) {
        this.qualityAttributeId = qualityAttribute;
    }

    public String getId() {
        return this.qualityAttributeId.getName();
    }

    public void createControl(Composite parent) {
        List<IExtension> extensions = ExtensionHelper.loadAnalysisExtensions(this.qualityAttributeId);
        this.nameExtensionElementMap = new HashMap<String, IConfigurationElement>();
        for (IExtension ext : extensions) {
            IConfigurationElement[] elements;
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String name = this.loadAnalysisMethodName(element);
                this.nameExtensionElementMap.put(name, element);
                ++n2;
            }
        }
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, true));
        List<String> methodNames = this.loadAnalysisMethodNames(extensions);
        Collections.sort(methodNames);
        this.methodCombo = new Combo(container, 8);
        this.methodCombo.setItems(methodNames.toArray(this.methodCombo.getItems()));
        this.methodCombo.addSelectionListener((SelectionListener)this.listener);
        this.methodCombo.setLayoutData((Object)new GridData(4, 128, true, false));
        this.tabFolderContainer = new Composite(container, 0);
        this.layout = new StackLayout();
        this.tabFolderContainer.setLayout((Layout)this.layout);
        this.tabFolderContainer.setLayoutData((Object)new GridData(4, 128, true, true));
        this.extensionElementTabFolderMap = new HashMap<IConfigurationElement, CTabFolder>();
        for (Map.Entry<IConfigurationElement, ILaunchConfigurationTabGroup> entry : this.getExtensionElementTabGroupMap().entrySet()) {
            IConfigurationElement element = entry.getKey();
            ILaunchConfigurationTabGroup tabGroup = entry.getValue();
            CTabFolder tabFolder = TabHelper.createTabFolder((ILaunchConfigurationTabGroup)tabGroup, (ILaunchConfigurationDialog)this.getLaunchConfigurationDialog(), (String)this.getLaunchConfigurationDialog().getMode(), (Composite)this.tabFolderContainer, (int)0x800800);
            this.extensionElementTabFolderMap.put(element, tabFolder);
        }
    }

    private Map<IConfigurationElement, ILaunchConfigurationTabGroup> getExtensionElementTabGroupMap() {
        if (this.extensionElementTabGroupMap == null) {
            this.extensionElementTabGroupMap = new HashMap<IConfigurationElement, ILaunchConfigurationTabGroup>();
            List<IExtension> extensions = ExtensionHelper.loadAnalysisExtensions(this.qualityAttributeId);
            for (IExtension ext : extensions) {
                try {
                    IConfigurationElement[] elements;
                    IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement element = iConfigurationElementArray[n2];
                        ILaunchConfigurationTabGroup tabGroup = (ILaunchConfigurationTabGroup)ExtensionHelper.loadExecutableAttribute(element, "launchConfigContribution");
                        tabGroup.createTabs(this.getLaunchConfigurationDialog(), this.getLaunchConfigurationDialog().getMode());
                        this.extensionElementTabGroupMap.put(element, tabGroup);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.extensionElementTabGroupMap;
    }

    private void setVisibleMethodOptions(String name) {
        IConfigurationElement selElement = this.nameExtensionElementMap.get(name);
        CTabFolder selTabFolder = this.extensionElementTabFolderMap.get(selElement);
        this.layout.topControl = selTabFolder;
        this.tabFolderContainer.layout();
    }

    private List<String> loadAnalysisMethodNames(List<IExtension> extensions) {
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < extensions.size()) {
            IConfigurationElement[] elements;
            IExtension extension = extensions.get(i);
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("analysis")) {
                    names.add(element.getAttribute("name"));
                }
                ++n2;
            }
            ++i;
        }
        return names;
    }

    private String loadAnalysisMethodName(IConfigurationElement element) {
        return element.getAttribute("name");
    }

    public String getName() {
        return String.valueOf(this.qualityAttributeId.getPrettyName()) + " Analysis Method";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String method = configuration.getAttribute(DSEConstantsContainer.getAnalysisMethod(this.qualityAttributeId), "none");
            String[] items = this.methodCombo.getItems();
            int i = 0;
            while (i < items.length) {
                String str = items[i];
                if (str.equals(method)) {
                    this.methodCombo.select(i);
                    if (this.methodComboEnabled) {
                        this.setVisibleMethodOptions(method);
                    } else {
                        this.setVisibleMethodOptions("none");
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            this.methodCombo.select(0);
        }
        Iterator<Map.Entry<IConfigurationElement, ILaunchConfigurationTabGroup>> it = this.getExtensionElementTabGroupMap().entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().initializeFrom(configuration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(DSEConstantsContainer.getAnalysisMethod(this.qualityAttributeId), this.methodCombo.getText());
        String methodStr = this.methodCombo.getText();
        ILaunchConfigurationTabGroup tabGroup = this.getExtensionElementTabGroupMap().get(this.nameExtensionElementMap.get(methodStr));
        if (tabGroup != null) {
            tabGroup.performApply(configuration);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        List<IExtension> extensions = ExtensionHelper.loadAnalysisExtensions(this.qualityAttributeId);
        Iterator<Map.Entry<IConfigurationElement, ILaunchConfigurationTabGroup>> it = this.getExtensionElementTabGroupMap().entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().setDefaults(configuration);
        }
        if (extensions.size() > 0) {
            IConfigurationElement defaultElement = extensions.get(0).getConfigurationElements()[0];
            configuration.setAttribute(DSEConstantsContainer.getAnalysisMethod(this.qualityAttributeId), this.loadAnalysisMethodName(defaultElement));
        } else {
            configuration.setAttribute(DSEConstantsContainer.getAnalysisMethod(this.qualityAttributeId), "none");
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String methodStr = this.methodCombo.getText();
        IConfigurationElement methodElement = this.nameExtensionElementMap.get(methodStr);
        if (methodElement == null && !methodStr.equals("none")) {
            this.setErrorMessage("Choose an analysis method.");
            return false;
        }
        ILaunchConfigurationTabGroup tabGroup = this.getExtensionElementTabGroupMap().get(this.nameExtensionElementMap.get(methodStr));
        if (tabGroup != null) {
            ILaunchConfigurationTab[] tabs;
            ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = tabGroup.getTabs();
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                boolean valid = tab.isValid(launchConfig);
                if (!valid) {
                    if (tab.getErrorMessage() != null) {
                        this.setErrorMessage("[" + tab.getName() + "]: " + tab.getErrorMessage());
                    }
                    return false;
                }
                ++n2;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivate() {
        if (!this.methodComboEnabled) {
            return;
        }
        this.methodCombo.removeAll();
        this.methodCombo.add("none");
        this.methodCombo.select(0);
        this.methodCombo.setEnabled(false);
        this.setVisibleMethodOptions("none");
        this.methodComboEnabled = false;
    }

    public void activate(List<IExtension> extensions) {
        List<String> methodNames = this.loadAnalysisMethodNames(extensions);
        Collections.sort(methodNames);
        this.methodCombo.setItems(methodNames.toArray(new String[1]));
        if (this.methodComboEnabled) {
            return;
        }
        this.methodCombo.setEnabled(true);
        int selection = this.methodCombo.getSelectionIndex();
        if (this.methodCombo.getSelectionIndex() > -1) {
            this.setVisibleMethodOptions(this.methodCombo.getItem(selection));
        }
        this.methodComboEnabled = true;
    }

    private class AnalysisMethodListener
    extends SelectionAdapter {
        private AnalysisMethodListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            String selectedText = ((Combo)e.getSource()).getText();
            IConfigurationElement selElement = (IConfigurationElement)DSEAnalysisMethodTab.this.nameExtensionElementMap.get(selectedText);
            if (selElement != ((DSEAnalysisMethodTab)DSEAnalysisMethodTab.this).layout.topControl) {
                DSEAnalysisMethodTab.this.setVisibleMethodOptions(selectedText);
                DSEAnalysisMethodTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

