/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.dsexplore.launch.DSEConstantsContainer;
import de.uka.ipd.sdq.dsexplore.launch.QMLManager;
import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.FileNamesInputTab;

public class DSEFileNamesInputTab
extends FileNamesInputTab {
    protected Text textQMLDefinitionFile;
    protected QMLManager qmlManager;

    public DSEFileNamesInputTab(QMLManager qmlManager) {
        this.qmlManager = qmlManager;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DSEFileNamesInputTab.this.setDirty(true);
                DSEFileNamesInputTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.textQMLDefinitionFile = new Text(this.container, 2052);
        String[] qmlExtension = new String[]{DSEConstantsContainer.QML_DEFINITION_EXTENSION};
        TabHelper.createFileInputSection((Composite)this.container, (ModifyListener)modifyListener, (String)"QML Criteria Definitions", (String[])qmlExtension, (Text)this.textQMLDefinitionFile, (Shell)this.getShell(), (String)"");
    }

    protected void loadQML() {
        this.qmlManager.processQMLFile(this.textQMLDefinitionFile.getText(), this.textUsage.getText());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            String currentQMLPath = configuration.getAttribute("qmlDefinitionFile", "");
            this.textQMLDefinitionFile.setText(currentQMLPath);
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)"qmlDefinitionFile", (String)e.getMessage());
        }
        this.loadQML();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        configuration.setAttribute("qmlDefinitionFile", this.textQMLDefinitionFile.getText());
        this.loadQML();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.qmlManager.isQMLLoaded()) {
            String errorMessage = "Select Usage Model and load QML Definition! For help, click the help button (?) in the bottom-left corner.";
            if (this.qmlManager.getDiagnosis() != null) {
                errorMessage = String.valueOf(errorMessage) + " " + this.qmlManager.getDiagnosis();
            }
            this.setErrorMessage(errorMessage);
            return false;
        }
        if (!this.qmlManager.hasActivatedObjectives()) {
            this.setErrorMessage("No objectives for specified UsageModel found in QML Definition. Make sure the right UsageModel is referenced and objectives are defined.");
            return false;
        }
        return super.isValid(launchConfig);
    }
}

