/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfiguration;
import de.uka.ipd.sdq.dsexplore.launch.DSEWorkflowConfigurationBuilder;
import de.uka.ipd.sdq.dsexplore.launch.PerOpteryxJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.logging.console.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.ui.WorkflowProcess;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMLaunchConfigurationDelegate;
import org.palladiosimulator.analyzer.workflow.configurations.PCMWorkflowConfigurationBuilder;

public class DSELaunch
extends AbstractPCMLaunchConfigurationDelegate<DSEWorkflowConfiguration> {
    WorkflowProcess myWorkflowProcess;
    private static Logger logger = Logger.getLogger(DSELaunch.class);
    private ILaunchConfiguration originalConfiguration;
    private ILaunch originalLaunch;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.originalConfiguration = configuration;
        this.originalLaunch = launch;
        int iterations = this.getNumberOfDSEIterations(configuration);
        logger.warn((Object)("Will start " + iterations + " analysis runs. Only first one may be visible on the console."));
        int i = 0;
        while (i < iterations) {
            super.launch(configuration, mode, launch, monitor);
            ++i;
        }
    }

    private int getNumberOfDSEIterations(ILaunchConfiguration configuration) {
        try {
            String stringValue = configuration.getAttribute("number of DSE iterations", "0");
            if (!stringValue.equals("")) {
                int i = Integer.parseInt(stringValue);
                return i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList loggerList = super.setupLogging(logLevel);
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.dsexplore", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.reliability.solver", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.pcmsolver", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.simucomframework.variables", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.stoex.analyser", logLevel, Level.DEBUG == logLevel ? "%-8r [%-10t] %-5p: %m [%c]%n" : "[%-10t] %-5p: %m%n"));
        return loggerList;
    }

    protected IJob createWorkflowJob(DSEWorkflowConfiguration config, ILaunch launch) throws CoreException {
        return new PerOpteryxJob(config, this);
    }

    protected DSEWorkflowConfiguration deriveConfiguration(ILaunchConfiguration configuration, String mode) throws CoreException {
        Object builder = new PCMWorkflowConfigurationBuilder(configuration, mode);
        DSEWorkflowConfiguration config = new DSEWorkflowConfiguration();
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)config);
        builder = new DSEWorkflowConfigurationBuilder(configuration, mode, this);
        builder.fillConfiguration((AbstractWorkflowBasedRunConfiguration)config);
        config.setRawConfig(configuration);
        return config;
    }

    public void resetLoggers() throws CoreException {
    }

    public ILaunch getOriginalLaunch() {
        return this.originalLaunch;
    }

    public ILaunchConfiguration getOriginalConfiguration() {
        return this.originalConfiguration;
    }

    protected WorkflowProcess getProcess(ILaunch launch) {
        if (this.myWorkflowProcess == null) {
            this.myWorkflowProcess = new WorkflowProcess(launch);
        }
        return this.myWorkflowProcess;
    }
}

