/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.launch;

import de.uka.ipd.sdq.workflow.launchconfig.LaunchConfigPlugin;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.runconfig.FileNamesInputTab;

public class StartingPopulationHeuristicTab
extends FileNamesInputTab {
    static final String TAB_NAME = "Starting Population Heuristic";
    private static final int DEFAULT_MARGIN = 15;
    private static final int DEFAULT_HORIZONTAL_SPACING = 30;
    private ModifyListener modifyListener;
    static final String STARTING_POPULATION_GROUP_NAME = "Starting Population Heuristic";
    static final String USE_STARTING_POPULATION_HEURISTIC = "Use starting population heuristic";
    static final String MAX_NUMBER_RESOURCE_CONTAINERS = "Maximum number of resource containers";
    static final String MIN_NUMBER_RESOURCE_CONTAINERS = "Minimum number of resource containers";
    static final String NUMBER_OF_CANDIDATES_PER_ALLOCATION_LEVEL = "Number of candidates per allocation level";
    private Button useStartingPopulationHeuristicButton;
    private Text minNumberOfResourceContainers;
    private Text maxNumberOfResourceContainers;
    private Text numberOfCandidatesPerAllocationLevel;
    private Label minNumberOfResourceContainersLabel;
    private Label maxNumberOfResourceContainersLabel;
    private Label numberOfCandidatesPerAllocationLevelLabel;
    static final boolean USE_STARTING_POPULATION_HEURISTIC_DEFAULT = false;
    static final int MIN_NUMBER_OF_RESOURCE_CONTAINERS_DEFAULT = 2;
    static final int MAX_NUMBER_OF_RESOURCE_CONTAINERS_DEFAULT = 9;
    static final int NUMBER_OF_CANDIDATES_PER_ALLOCATION_LEVEL_DEFAULT = 10;

    public void createControl(Composite parent) {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StartingPopulationHeuristicTab.this.setDirty(true);
                StartingPopulationHeuristicTab.this.updateLaunchConfigurationDialog();
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StartingPopulationHeuristicTab.this.setDirty(true);
                StartingPopulationHeuristicTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetSelected(SelectionEvent e) {
                StartingPopulationHeuristicTab.this.setDirty(true);
                StartingPopulationHeuristicTab.this.updateLaunchConfigurationDialog();
            }
        };
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout());
        Group startingPopulationGroup = new Group(container, 0);
        GridLayout startingPopulationGroupLayout = new GridLayout();
        startingPopulationGroupLayout.numColumns = 4;
        startingPopulationGroupLayout.horizontalSpacing = 30;
        startingPopulationGroupLayout.marginHeight = 15;
        startingPopulationGroupLayout.marginWidth = 15;
        startingPopulationGroup.setLayout((Layout)startingPopulationGroupLayout);
        startingPopulationGroup.setText("Starting Population Heuristic");
        startingPopulationGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.useStartingPopulationHeuristicButton = new Button((Composite)startingPopulationGroup, 32);
        this.useStartingPopulationHeuristicButton.setEnabled(true);
        this.useStartingPopulationHeuristicButton.setSelection(true);
        this.useStartingPopulationHeuristicButton.setText(USE_STARTING_POPULATION_HEURISTIC);
        this.useStartingPopulationHeuristicButton.addSelectionListener(selectionListener);
        this.useStartingPopulationHeuristicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StartingPopulationHeuristicTab.this.updateStartingPopulationSelection();
            }
        });
        new Label((Composite)startingPopulationGroup, 0);
        new Label((Composite)startingPopulationGroup, 0);
        new Label((Composite)startingPopulationGroup, 0);
        this.maxNumberOfResourceContainersLabel = new Label((Composite)startingPopulationGroup, 0);
        this.maxNumberOfResourceContainersLabel.setText(MAX_NUMBER_RESOURCE_CONTAINERS);
        this.maxNumberOfResourceContainers = new Text((Composite)startingPopulationGroup, 2052);
        this.maxNumberOfResourceContainers.setEnabled(true);
        this.maxNumberOfResourceContainers.addModifyListener(this.modifyListener);
        this.minNumberOfResourceContainersLabel = new Label((Composite)startingPopulationGroup, 0);
        this.minNumberOfResourceContainersLabel.setText(MIN_NUMBER_RESOURCE_CONTAINERS);
        this.minNumberOfResourceContainers = new Text((Composite)startingPopulationGroup, 2052);
        this.minNumberOfResourceContainers.setEnabled(true);
        this.minNumberOfResourceContainers.addModifyListener(this.modifyListener);
        this.numberOfCandidatesPerAllocationLevelLabel = new Label((Composite)startingPopulationGroup, 0);
        this.numberOfCandidatesPerAllocationLevelLabel.setText(NUMBER_OF_CANDIDATES_PER_ALLOCATION_LEVEL);
        this.numberOfCandidatesPerAllocationLevel = new Text((Composite)startingPopulationGroup, 2052);
        this.numberOfCandidatesPerAllocationLevel.setEnabled(true);
        this.numberOfCandidatesPerAllocationLevel.addModifyListener(this.modifyListener);
    }

    public String getName() {
        return "Starting Population Heuristic";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.useStartingPopulationHeuristicButton.setSelection(configuration.getAttribute(USE_STARTING_POPULATION_HEURISTIC, false));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)USE_STARTING_POPULATION_HEURISTIC, (String)e.getMessage());
        }
        try {
            this.maxNumberOfResourceContainers.setText(configuration.getAttribute(MAX_NUMBER_RESOURCE_CONTAINERS, ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)MAX_NUMBER_RESOURCE_CONTAINERS, (String)e.getMessage());
        }
        try {
            this.minNumberOfResourceContainers.setText(configuration.getAttribute(MIN_NUMBER_RESOURCE_CONTAINERS, ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)MIN_NUMBER_RESOURCE_CONTAINERS, (String)e.getMessage());
        }
        try {
            this.numberOfCandidatesPerAllocationLevel.setText(configuration.getAttribute(NUMBER_OF_CANDIDATES_PER_ALLOCATION_LEVEL, ""));
        }
        catch (CoreException e) {
            LaunchConfigPlugin.errorLogger((String)this.getName(), (String)NUMBER_OF_CANDIDATES_PER_ALLOCATION_LEVEL, (String)e.getMessage());
        }
        this.updateSelections();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(USE_STARTING_POPULATION_HEURISTIC, this.useStartingPopulationHeuristicButton.getSelection());
        configuration.setAttribute(MAX_NUMBER_RESOURCE_CONTAINERS, this.maxNumberOfResourceContainers.getText());
        configuration.setAttribute(MIN_NUMBER_RESOURCE_CONTAINERS, this.minNumberOfResourceContainers.getText());
        configuration.setAttribute(NUMBER_OF_CANDIDATES_PER_ALLOCATION_LEVEL, this.numberOfCandidatesPerAllocationLevel.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(USE_STARTING_POPULATION_HEURISTIC, false);
        configuration.setAttribute(MIN_NUMBER_RESOURCE_CONTAINERS, Integer.toString(2));
        configuration.setAttribute(MAX_NUMBER_RESOURCE_CONTAINERS, Integer.toString(9));
        configuration.setAttribute(NUMBER_OF_CANDIDATES_PER_ALLOCATION_LEVEL, Integer.toString(10));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.useStartingPopulationHeuristicButton.getSelection()) {
            return true;
        }
        try {
            String startingPopulationFileName = launchConfig.getAttribute("predefinedInstances", "");
            if (startingPopulationFileName != null && !"".equals(startingPopulationFileName)) {
                this.setErrorMessage("Starting population heuristics cannot be enabled if a starting population has been predefined in the DSE Options Tab");
                return false;
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        Hashtable<Text, String> valuesToCheck = new Hashtable<Text, String>();
        valuesToCheck.put(this.minNumberOfResourceContainers, "Minimum number of resouce containers");
        valuesToCheck.put(this.maxNumberOfResourceContainers, MAX_NUMBER_RESOURCE_CONTAINERS);
        valuesToCheck.put(this.numberOfCandidatesPerAllocationLevel, "Number of candidates per processing rate level");
        for (Text text : valuesToCheck.keySet()) {
            try {
                int i = Integer.parseInt(text.getText());
                if (i > 0) continue;
                throw new NumberFormatException();
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(String.valueOf((String)valuesToCheck.get(text)) + " (" + text.getText() + ") must be an integer value >0 or empty.");
                return false;
            }
        }
        try {
            int min = Integer.parseInt(this.minNumberOfResourceContainers.getText());
            int max = Integer.parseInt(this.maxNumberOfResourceContainers.getText());
            if (min > max) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.setErrorMessage("Minimum number of resource containers must not be larger than maxmimum number of resource containers.");
            return false;
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private void updateSelections() {
        this.updateStartingPopulationSelection();
    }

    private void updateStartingPopulationSelection() {
        boolean selected = this.useStartingPopulationHeuristicButton.getSelection();
        this.maxNumberOfResourceContainersLabel.setEnabled(selected);
        this.maxNumberOfResourceContainers.setEnabled(selected);
        this.minNumberOfResourceContainersLabel.setEnabled(selected);
        this.minNumberOfResourceContainers.setEnabled(selected);
        this.numberOfCandidatesPerAllocationLevelLabel.setEnabled(selected);
        this.numberOfCandidatesPerAllocationLevel.setEnabled(selected);
        this.updateLaunchConfigurationDialog();
    }
}

