/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.representation;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.gdof.GenomeToCandidateModelTransformation;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.representation.DSEProblem;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.designdecisionFactory;
import de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionFactoryImpl;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.OrderedIntegerDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.opt4j.core.problem.Creator;

public class DSECreator
implements Creator<DesignDecisionGenotype> {
    private DSEProblem problem = Opt4JStarter.getProblem();
    private Random random = new Random();
    private int numberOfNotEvaluatedPredefinedOnes = this.problem.getInitialGenotypeList().size();

    @Inject
    public DSECreator() {
    }

    public DesignDecisionGenotype create() {
        if (this.numberOfNotEvaluatedPredefinedOnes > 0) {
            DesignDecisionGenotype genome = this.problem.getInitialGenotypeList().get(this.problem.getInitialGenotypeList().size() - this.numberOfNotEvaluatedPredefinedOnes);
            --this.numberOfNotEvaluatedPredefinedOnes;
            return genome;
        }
        DesignDecisionGenotype genotype = new DesignDecisionGenotype();
        List<DegreeOfFreedomInstance> degrees = this.problem.getDesignDecisions();
        for (DegreeOfFreedomInstance DegreeOfFreedomInstance2 : degrees) {
            genotype.add(this.createRandomChoice(DegreeOfFreedomInstance2));
        }
        return genotype;
    }

    private int createIntegerValue(DiscreteDegree discDegree) {
        if (discDegree instanceof DiscreteRangeDegree) {
            DiscreteRangeDegree dicRangeDegree = (DiscreteRangeDegree)discDegree;
            int range = dicRangeDegree.getTo() - dicRangeDegree.getFrom();
            if (!dicRangeDegree.isLowerBoundIncluded()) {
                --range;
            }
            if (!dicRangeDegree.isUpperBoundIncluded()) {
                --range;
            }
            int value = dicRangeDegree.getFrom() + this.random.nextInt(range + 1);
            return value;
        }
        if (discDegree instanceof OrderedIntegerDegree) {
            OrderedIntegerDegree orderedIntegerDegree = (OrderedIntegerDegree)discDegree;
            int randomIndex = this.random.nextInt(orderedIntegerDegree.getListOfIntegers().size());
            return (Integer)orderedIntegerDegree.getListOfIntegers().get(randomIndex);
        }
        throw new RuntimeException("Unknown degree " + discDegree.getClass().getName());
    }

    private double createDoubleValue(ContinuousRangeDegree contDegree) {
        double lowerMargin = 0.0;
        if (contDegree.isLowerBoundIncluded()) {
            lowerMargin = Double.MIN_VALUE;
        }
        double upperMargin = 0.0;
        if (contDegree.isUpperBoundIncluded()) {
            upperMargin = Double.MIN_VALUE;
        }
        double factor = contDegree.getTo() - upperMargin - contDegree.getFrom() - lowerMargin;
        return contDegree.getFrom() + lowerMargin + this.random.nextDouble() * factor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Choice createRandomChoice(DegreeOfFreedomInstance degree) {
        DiscreteRangeChoice choice;
        designdecisionFactory factory = designdecisionFactoryImpl.init();
        if (degree instanceof DiscreteDegree) {
            DiscreteRangeChoice discChoice = factory.createDiscreteRangeChoice();
            discChoice.setChosenValue(this.createIntegerValue((DiscreteDegree)degree));
            choice = discChoice;
        } else if (degree instanceof ContinuousRangeDegree) {
            ContinousRangeChoice contChoice = factory.createContinousRangeChoice();
            contChoice.setChosenValue(this.createDoubleValue((ContinuousRangeDegree)degree));
            choice = contChoice;
        } else if (degree instanceof ClassDegree) {
            ClassChoice enumChoice = factory.createClassChoice();
            enumChoice.setChosenValue(this.createRandomEntity((ClassDegree)degree));
            choice = enumChoice;
        } else {
            if (degree.getDof() == null) throw new RuntimeException("Unknown degree " + degree.getClass().getName());
            Object chosenValue = this.createRandomValue(degree);
            if (chosenValue instanceof EObject) {
                ClassChoice classChoice = factory.createClassChoice();
                classChoice.setChosenValue((EObject)chosenValue);
                choice = classChoice;
            } else if (chosenValue instanceof Double) {
                ContinousRangeChoice continuousNumberChoice = factory.createContinousRangeChoice();
                continuousNumberChoice.setChosenValue(((Double)chosenValue).doubleValue());
                choice = continuousNumberChoice;
            } else {
                if (!(chosenValue instanceof Integer)) throw new RuntimeException("Cannot handle choice returned by GDoF transformation " + chosenValue.getClass().getName());
                DiscreteRangeChoice integerNumberChoice = factory.createDiscreteRangeChoice();
                integerNumberChoice.setChosenValue(((Integer)chosenValue).intValue());
                choice = integerNumberChoice;
            }
        }
        choice.setDegreeOfFreedomInstance(degree);
        return choice;
    }

    private Object createRandomValue(DegreeOfFreedomInstance degree) {
        Collection<Object> possibleValues = GenomeToCandidateModelTransformation.valueRuleForCollection(degree.getDof().getPrimaryChangeable(), degree.getPrimaryChanged(), GenomeToCandidateModelTransformation.getPCMRootElements(Opt4JStarter.getProblem().getInitialInstance()));
        ArrayList<Object> list = possibleValues instanceof List ? (ArrayList<Object>)possibleValues : new ArrayList<Object>(possibleValues);
        int index = this.random.nextInt(list.size());
        return list.get(index);
    }

    private EObject createRandomEntity(ClassDegree enumDegree) {
        EList domain = enumDegree.getClassDesignOptions();
        int index = this.random.nextInt(domain.size());
        return (EObject)domain.get(index);
    }

    public void setNumberOfNotEvaluatedPredefinedOnes(int numberOfNotEvaluatedPredefinedOnes) {
        this.numberOfNotEvaluatedPredefinedOnes = numberOfNotEvaluatedPredefinedOnes;
    }

    public int getNumberOfNotEvaluatedPredefinedOnes() {
        return this.numberOfNotEvaluatedPredefinedOnes;
    }
}

