/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.opt4j.representation;

import com.google.inject.Inject;
import de.uka.ipd.sdq.dsexplore.analysis.PCMPhenotype;
import de.uka.ipd.sdq.dsexplore.designdecisions.alternativecomponents.AlternativeComponent;
import de.uka.ipd.sdq.dsexplore.exception.ChoiceOutOfBoundsException;
import de.uka.ipd.sdq.dsexplore.exception.ExceptionHelper;
import de.uka.ipd.sdq.dsexplore.exception.InvalidChoiceForDegreeException;
import de.uka.ipd.sdq.dsexplore.gdof.GenomeToCandidateModelTransformation;
import de.uka.ipd.sdq.dsexplore.helper.DegreeOfFreedomHelper;
import de.uka.ipd.sdq.dsexplore.helper.EMFHelper;
import de.uka.ipd.sdq.dsexplore.opt4j.genotype.DesignDecisionGenotype;
import de.uka.ipd.sdq.dsexplore.opt4j.start.Opt4JStarter;
import de.uka.ipd.sdq.pcm.cost.helper.CostUtil;
import de.uka.ipd.sdq.pcm.designdecision.Choice;
import de.uka.ipd.sdq.pcm.designdecision.ClassChoice;
import de.uka.ipd.sdq.pcm.designdecision.ContinousRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.DegreeOfFreedomInstance;
import de.uka.ipd.sdq.pcm.designdecision.DiscreteRangeChoice;
import de.uka.ipd.sdq.pcm.designdecision.designdecisionFactory;
import de.uka.ipd.sdq.pcm.designdecision.impl.designdecisionFactoryImpl;
import de.uka.ipd.sdq.pcm.designdecision.specific.ATNumberOfReplicaDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.AllocationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.AssembledComponentDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.CapacityDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ClassDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ContinuousRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteProcessingRateDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.DiscreteRangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ExchangeComponentRule;
import de.uka.ipd.sdq.pcm.designdecision.specific.MonitoringDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.NumberOfCoresDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ProcessingRateDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ProcessingResourceDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.RangeDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ResourceContainerReplicationDegree;
import de.uka.ipd.sdq.pcm.designdecision.specific.ResourceContainerReplicationDegreeWithComponentChange;
import de.uka.ipd.sdq.pcm.designdecision.specific.SchedulingPolicyDegree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.opt4j.core.problem.Decoder;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;
import org.palladiosimulator.solver.models.PCMInstance;

public class DSEDecoder
implements Decoder<DesignDecisionGenotype, PCMPhenotype> {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.dsexplore");
    private double initialMTTF = Double.NaN;
    private double initialRate = Double.NaN;
    private static double intervalTime = 0.0;

    @Inject
    public DSEDecoder() {
    }

    public PCMPhenotype decode(DesignDecisionGenotype genotype) {
        Object notTransformedChoices;
        PCMInstance pcm = Opt4JStarter.getProblem().getInitialInstance();
        GenomeToCandidateModelTransformation trans = new GenomeToCandidateModelTransformation();
        try {
            notTransformedChoices = trans.transform(pcm, genotype.getEMFCandidate());
        }
        catch (Exception e) {
            logger.warn((Object)"Error when executing GDoF transformation. I will try to ignore it and continue. Failure was:");
            e.printStackTrace();
            notTransformedChoices = genotype;
        }
        Iterator<Choice> iterator = notTransformedChoices.iterator();
        while (iterator.hasNext()) {
            Choice doubleGene = iterator.next();
            this.applyChange(doubleGene.getDegreeOfFreedomInstance(), doubleGene, trans, pcm);
        }
        String genotypeString = DSEDecoder.getGenotypeString(genotype);
        return new PCMPhenotype(pcm, genotypeString, genotype.getNumericID());
    }

    private void applyChange(DegreeOfFreedomInstance designDecision, Choice choice, GenomeToCandidateModelTransformation trans, PCMInstance pcm) {
        if (ProcessingRateDegree.class.isInstance(designDecision)) {
            this.applyChangeProcessingRateDecision((ProcessingRateDegree)designDecision, choice);
        } else if (MonitoringDegree.class.isInstance(designDecision)) {
            this.applyChangeMonitoringDecision((MonitoringDegree)designDecision, choice);
        } else if (AssembledComponentDegree.class.isInstance(designDecision)) {
            this.applyChangeAssembledComponentDecision((AssembledComponentDegree)designDecision, choice);
        } else if (AllocationDegree.class.isInstance(designDecision)) {
            this.applyChangeAllocationDecision((AllocationDegree)designDecision, choice);
        } else if (SchedulingPolicyDegree.class.isInstance(designDecision)) {
            this.applyChangeSchedulingDecision((SchedulingPolicyDegree)designDecision, choice);
        } else if (CapacityDegree.class.isInstance(designDecision)) {
            this.applyChangeCapacityDecision((CapacityDegree)designDecision, choice);
        } else if (NumberOfCoresDegree.class.isInstance(designDecision)) {
            this.applyChangeNumberOfCoresDecision((NumberOfCoresDegree)designDecision, choice);
        } else if (ResourceContainerReplicationDegree.class.isInstance(designDecision)) {
            this.applyChangeResourceContainerReplicationDegree((ResourceContainerReplicationDegree)designDecision, choice);
        } else if (ATNumberOfReplicaDegree.class.isInstance(designDecision)) {
            this.applyChangeATNumberOfReplicaDegree((ATNumberOfReplicaDegree)designDecision, choice);
        } else {
            try {
                trans.transformChoice(pcm, choice);
            }
            catch (Exception e) {
                logger.error((Object)("There was an unrecognised design decision " + designDecision.getClass() + " or a problem when handling a generic DoF"));
                e.printStackTrace();
            }
        }
    }

    private void applyChangeATNumberOfReplicaDegree(ATNumberOfReplicaDegree designDecision, Choice choice) {
        if (!(choice instanceof DiscreteRangeChoice)) {
            this.throwNewInvalidChoiceException((DegreeOfFreedomInstance)designDecision, choice);
        }
        DiscreteRangeChoice discreteChoice = (DiscreteRangeChoice)choice;
        EObject changeableEntity = designDecision.getPrimaryChanged();
        if (changeableEntity instanceof ResourceContainer) {
            ResourceContainer resourceContainer = (ResourceContainer)changeableEntity;
            if (StereotypeAPI.isStereotypeApplied((EObject)resourceContainer, (String)"ReplicableResourceContainer")) {
                int min = designDecision.getFrom();
                int max = designDecision.getTo();
                int newNumberOfReplicas = ThreadLocalRandom.current().nextInt(min, max + 1);
                StereotypeAPI.setTaggedValue((EObject)resourceContainer, (Object)newNumberOfReplicas, (String)"ReplicableResourceContainer", (String)"numberOfReplicas");
                discreteChoice.setChosenValue(newNumberOfReplicas);
            }
        } else {
            boolean cfr_ignored_0 = changeableEntity instanceof AssemblyContext;
        }
    }

    private void applyChangeResourceContainerReplicationDegree(ResourceContainerReplicationDegree designDecision, Choice choice) {
        if (!(choice instanceof DiscreteRangeChoice)) {
            this.throwNewInvalidChoiceException((DegreeOfFreedomInstance)designDecision, choice);
        }
        DiscreteRangeChoice discreteChoice = (DiscreteRangeChoice)choice;
        int numberOfServers = discreteChoice.getChosenValue();
        EObject changeableEntity = designDecision.getPrimaryChanged();
        if (!(changeableEntity instanceof ResourceContainer)) {
            this.throwInvalidEntityException((DegreeOfFreedomInstance)designDecision, changeableEntity, ResourceContainer.class);
        }
        ResourceContainer server = (ResourceContainer)changeableEntity;
        if (numberOfServers < 1) {
            throw new ChoiceOutOfBoundsException(discreteChoice);
        }
        PCMInstance pcm = Opt4JStarter.getProblem().getInitialInstance();
        boolean unrollReplication = true;
        if (unrollReplication) {
            EList allServers = pcm.getResourceEnvironment().getResourceContainer_ResourceEnvironment();
            ArrayList previousReplicasToRemove = new ArrayList();
            for (ResourceContainer resourceContainer : allServers) {
                if (!resourceContainer.getId().contains(server.getId()) || !resourceContainer.getEntityName().contains("Replica")) continue;
                previousReplicasToRemove.add(resourceContainer);
            }
            allServers.removeAll(previousReplicasToRemove);
            EList linkingResources = pcm.getResourceEnvironment().getLinkingResources__ResourceEnvironment();
            for (LinkingResource linkingResource : linkingResources) {
                linkingResource.getConnectedResourceContainers_LinkingResource().removeAll((Collection)previousReplicasToRemove);
            }
            ArrayList<AllocationContext> allocationContextsToRemove = new ArrayList<AllocationContext>();
            for (AllocationContext allocationContext : pcm.getAllocation().getAllocationContexts_Allocation()) {
                if (!previousReplicasToRemove.contains(allocationContext.getResourceContainer_AllocationContext())) continue;
                allocationContextsToRemove.add(allocationContext);
            }
            pcm.getAllocation().getAllocationContexts_Allocation().removeAll(allocationContextsToRemove);
            if (numberOfServers != 1) {
                EList allocationContexts = pcm.getAllocation().getAllocationContexts_Allocation();
                List<AllocationContext> allocationContextsOnServer = this.getAllocationContextsOnServer((List<AllocationContext>)allocationContexts, server);
                int i = 1;
                while (i < numberOfServers) {
                    ResourceContainer serverCopy = (ResourceContainer)EcoreUtil.copy((EObject)server);
                    serverCopy.setId(String.valueOf(serverCopy.getId()) + i);
                    serverCopy.setEntityName(String.valueOf(serverCopy.getEntityName()) + "Replica" + i);
                    for (ProcessingResourceSpecification processor : serverCopy.getActiveResourceSpecifications_ResourceContainer()) {
                        processor.setId(String.valueOf(processor.getId()) + i);
                    }
                    pcm.getResourceEnvironment().getResourceContainer_ResourceEnvironment().add((Object)serverCopy);
                    for (LinkingResource linkingResource : linkingResources) {
                        if (!linkingResource.getConnectedResourceContainers_LinkingResource().contains((Object)server)) continue;
                        linkingResource.getConnectedResourceContainers_LinkingResource().add((Object)serverCopy);
                    }
                    for (AllocationContext allocationContext : allocationContextsOnServer) {
                        AllocationContext allocationContextCopy = (AllocationContext)EcoreUtil.copy((EObject)allocationContext);
                        allocationContextCopy.setId(String.valueOf(allocationContextCopy.getId()) + i);
                        allocationContextCopy.setEntityName(String.valueOf(allocationContextCopy.getEntityName()) + "Replica" + i);
                        allocationContextCopy.setResourceContainer_AllocationContext(serverCopy);
                        pcm.getAllocation().getAllocationContexts_Allocation().add((Object)allocationContextCopy);
                    }
                    ++i;
                }
            }
        } else {
            for (ProcessingResourceSpecification processingResourceSpec : server.getActiveResourceSpecifications_ResourceContainer()) {
                processingResourceSpec.setNumberOfReplicas(processingResourceSpec.getNumberOfReplicas() * numberOfServers);
            }
        }
        if (designDecision instanceof ResourceContainerReplicationDegreeWithComponentChange) {
            EList exchangeComponentRules = ((ResourceContainerReplicationDegreeWithComponentChange)designDecision).getExchangeComponentRule();
            int index = numberOfServers - designDecision.getFrom();
            for (ExchangeComponentRule exchangeComponentRule : exchangeComponentRules) {
                if (index >= 0 && index < exchangeComponentRule.getRepositoryComponent().size()) {
                    RepositoryComponent repoCompToUse = (RepositoryComponent)exchangeComponentRule.getRepositoryComponent().get(index);
                    AssemblyContext assemblyContextToChange = exchangeComponentRule.getAllocationContext().getAssemblyContext_AllocationContext();
                    RepositoryComponent currentComponent = assemblyContextToChange.getEncapsulatedComponent__AssemblyContext();
                    if (EMFHelper.checkIdentity((EObject)currentComponent, (EObject)repoCompToUse)) continue;
                    AlternativeComponent.getInstance().applyChange(assemblyContextToChange, repoCompToUse);
                    continue;
                }
                throw new ChoiceOutOfBoundsException(discreteChoice, "Looking for index " + index + "in RepositoryComponents of ResourceContainerReplicationDegreeWithComponentChange " + "degree for number of servers " + numberOfServers + ", but no such component available");
            }
        }
    }

    private List<AllocationContext> getAllocationContextsOnServer(List<AllocationContext> allocationContexts, ResourceContainer server) {
        LinkedList<AllocationContext> allocationContextsOnThisServer = new LinkedList<AllocationContext>();
        for (AllocationContext allocationContext : allocationContexts) {
            if (!EMFHelper.checkIdentity((EObject)allocationContext.getResourceContainer_AllocationContext(), (EObject)server)) continue;
            allocationContextsOnThisServer.add(allocationContext);
        }
        return allocationContextsOnThisServer;
    }

    private void applyChangeNumberOfCoresDecision(NumberOfCoresDegree designDecision, Choice choice) {
        if (!(choice instanceof DiscreteRangeChoice)) {
            this.throwNewInvalidChoiceException((DegreeOfFreedomInstance)designDecision, choice);
        }
        DiscreteRangeChoice discreteChoice = (DiscreteRangeChoice)choice;
        ProcessingResourceSpecification rightPrs = this.getProcessingRateSpecification((ProcessingResourceDegree)designDecision);
        rightPrs.setNumberOfReplicas(discreteChoice.getChosenValue());
    }

    private void applyChangeCapacityDecision(CapacityDegree designDecision, Choice choice) {
        if (!(choice instanceof DiscreteRangeChoice)) {
            this.throwNewInvalidChoiceException((DegreeOfFreedomInstance)designDecision, choice);
        }
        DiscreteRangeChoice discreteChoice = (DiscreteRangeChoice)choice;
        PassiveResource passiveResource = (PassiveResource)designDecision.getPrimaryChanged();
        passiveResource.getCapacity_PassiveResource().setSpecification(String.valueOf(discreteChoice.getChosenValue()));
    }

    private void applyChangeAllocationDecision(AllocationDegree designDecision, Choice choice) {
        ClassChoice enumChoice;
        EObject entity;
        if (!(choice instanceof ClassChoice)) {
            this.throwNewInvalidChoiceException((DegreeOfFreedomInstance)designDecision, choice);
        }
        if (!((entity = (enumChoice = (ClassChoice)choice).getChosenValue()) instanceof ResourceContainer)) {
            this.throwInvalidEntityException((DegreeOfFreedomInstance)designDecision, entity, ResourceContainer.class);
        }
        ResourceContainer rc = (ResourceContainer)entity;
        ((AllocationContext)designDecision.getPrimaryChanged()).setResourceContainer_AllocationContext(rc);
        logger.debug((Object)("Handling a " + designDecision.getClass() + ", setting resource container to " + rc.getEntityName() + " for allocation context " + designDecision.getPrimaryChanged()));
    }

    private void applyChangeSchedulingDecision(SchedulingPolicyDegree designDecision, Choice choice) {
        if (!(choice instanceof ClassChoice)) {
            this.throwNewInvalidChoiceException((DegreeOfFreedomInstance)designDecision, choice);
        }
        ClassChoice schedChoice = (ClassChoice)choice;
        SchedulingPolicy chosenPolicy = (SchedulingPolicy)schedChoice.getChosenValue();
        ProcessingResourceSpecification rightPrs = this.getProcessingRateSpecification((ProcessingResourceDegree)designDecision);
        rightPrs.setSchedulingPolicy(chosenPolicy);
    }

    private void applyChangeProcessingRateDecision(ProcessingRateDegree designDecision, Choice choice) {
        ContinousRangeChoice doubleGene;
        if (!(choice instanceof ContinousRangeChoice) && !(choice instanceof DiscreteRangeChoice)) {
            this.throwNewInvalidChoiceException((DegreeOfFreedomInstance)designDecision, choice);
        }
        double newRate = 0.0;
        if (choice instanceof ContinousRangeChoice) {
            doubleGene = (ContinousRangeChoice)choice;
            newRate = doubleGene.getChosenValue();
        } else {
            doubleGene = (DiscreteRangeChoice)choice;
            DiscreteProcessingRateDegree degree = (DiscreteProcessingRateDegree)designDecision;
            newRate = degree.getFrom() + (degree.getTo() - degree.getFrom()) / degree.getNumberOfSteps() * doubleGene.getChosenValue();
        }
        ProcessingResourceSpecification rightPrs = this.getProcessingRateSpecification((ProcessingResourceDegree)designDecision);
        if (Double.isNaN(this.initialRate)) {
            String oldRateString = rightPrs.getProcessingRate_ProcessingResourceSpecification().getSpecification();
            this.initialRate = CostUtil.getInstance().getDoubleFromSpecification(oldRateString);
        }
        if (Double.isNaN(this.initialMTTF)) {
            this.initialMTTF = rightPrs.getMTTF();
        }
        double mttf = this.initialMTTF * newRate / this.initialRate;
        rightPrs.getProcessingRate_ProcessingResourceSpecification().setSpecification(String.valueOf(newRate));
        rightPrs.setMTTF(mttf);
        logger.debug((Object)("Handling a " + designDecision.getClass() + ", setting rate to " + newRate + " and MTTF to " + mttf + " (inital MTTF: " + this.initialMTTF + ")"));
    }

    private void applyChangeMonitoringDecision(MonitoringDegree designDecision, Choice choice) {
        double newinterval = 0.0;
        if (choice instanceof ContinousRangeChoice) {
            ContinousRangeChoice doubleGene = (ContinousRangeChoice)choice;
            intervalTime = newinterval = doubleGene.getChosenValue();
            throw new UnsupportedOperationException("MonitoringDegree is not supported anymore after recent SimuLizar refactoring renaming the pms package to psm. Please update DSEDecoder.class and import the required Inervall file from where it is located now. Please also restore the Simulizar plugin dependencies as needed.");
        }
    }

    public static double returnInterval() {
        return intervalTime;
    }

    private ProcessingResourceSpecification getProcessingRateSpecification(ProcessingResourceDegree designDecision) {
        ResourceContainer rc = (ResourceContainer)designDecision.getPrimaryChanged();
        ProcessingResourceType prt = designDecision.getProcessingresourcetype();
        ProcessingResourceSpecification rightPrs = null;
        for (ProcessingResourceSpecification prs : rc.getActiveResourceSpecifications_ResourceContainer()) {
            if (!EMFHelper.checkIdentity((EObject)prs.getActiveResourceType_ActiveResourceSpecification(), (EObject)prt)) continue;
            rightPrs = prs;
            break;
        }
        if (rightPrs == null) {
            throw new RuntimeException("Invalid degree of freedom " + designDecision.toString() + ". The references ProcessingResourceType is not available in the given ResourceContainer.");
        }
        return rightPrs;
    }

    private void throwNewInvalidChoiceException(DegreeOfFreedomInstance designDecision, Choice choice) {
        throw new InvalidChoiceForDegreeException(choice);
    }

    private void applyChangeAssembledComponentDecision(AssembledComponentDegree designDecision, Choice choice) {
        ClassChoice enumChoice;
        EObject entity;
        if (!(choice instanceof ClassChoice)) {
            this.throwNewInvalidChoiceException((DegreeOfFreedomInstance)designDecision, choice);
        }
        if (!((entity = (enumChoice = (ClassChoice)choice).getChosenValue()) instanceof RepositoryComponent)) {
            this.throwInvalidEntityException((DegreeOfFreedomInstance)designDecision, entity, RepositoryComponent.class);
        }
        RepositoryComponent componentToBeAssembled = (RepositoryComponent)entity;
        AssemblyContext changedAssemblyContext = (AssemblyContext)designDecision.getPrimaryChanged();
        RepositoryComponent currentComponent = changedAssemblyContext.getEncapsulatedComponent__AssemblyContext();
        if (!EMFHelper.checkIdentity((EObject)currentComponent, (EObject)componentToBeAssembled)) {
            AlternativeComponent.getInstance().applyChange(changedAssemblyContext, componentToBeAssembled);
        }
        logger.debug((Object)("Handling a " + designDecision.getClass() + ", using component " + componentToBeAssembled.getEntityName()));
    }

    private void throwInvalidEntityException(DegreeOfFreedomInstance designDecision, EObject changeableEntity, Class<?> expectedClass) {
        throw new RuntimeException("Entity " + changeableEntity + " of type " + changeableEntity.getClass().getName() + " is not an applicable value for degree of freedom " + designDecision.getClass().getName() + ", required type is " + expectedClass.getName());
    }

    public static String getGenotypeString(DesignDecisionGenotype genotype) {
        StringBuilder genotypeStringBuilder = new StringBuilder(100);
        Iterator<Choice> iterator = genotype.iterator();
        while (iterator.hasNext()) {
            Choice choice = iterator.next();
            genotypeStringBuilder.append(String.valueOf(DSEDecoder.getDecisionString(choice)) + ";");
        }
        return genotypeStringBuilder.toString();
    }

    public static String getDecisionString(Choice choice) {
        String result = choice.getValue().toString();
        if (choice.getValue() instanceof Entity) {
            result = DSEDecoder.getDecisionString((Entity)choice.getValue());
        }
        return result;
    }

    private static String getDecisionString(Entity entity) {
        return String.valueOf(entity.getEntityName()) + " (ID: " + entity.getId() + ")";
    }

    public static Choice getChoiceForIndex(int index, String decisionString) throws CoreException {
        DegreeOfFreedomInstance designDecision = Opt4JStarter.getProblem().getDesignDecision(index);
        Choice value = DSEDecoder.getChoiceFor(decisionString, designDecision);
        return value;
    }

    public static Choice getChoiceFor(String decisionString, DegreeOfFreedomInstance designDecision) throws CoreException {
        ClassChoice choice;
        designdecisionFactory factory = designdecisionFactoryImpl.init();
        if (designDecision instanceof ContinuousRangeDegree) {
            ContinuousRangeDegree contDegree = (ContinuousRangeDegree)designDecision;
            double d = Double.parseDouble(decisionString);
            if (!DSEDecoder.validRange(d, (RangeDegree)contDegree, contDegree.getFrom(), contDegree.getTo())) {
                throw ExceptionHelper.createNewCoreException("Error: Value " + d + " is not a valid value for degree " + designDecision + " " + DegreeOfFreedomHelper.getDegreeDescription(designDecision));
            }
            ContinousRangeChoice contChoice = factory.createContinousRangeChoice();
            contChoice.setChosenValue(d);
            choice = contChoice;
        } else if (designDecision instanceof DiscreteRangeDegree) {
            DiscreteRangeDegree discDegree = (DiscreteRangeDegree)designDecision;
            int i = Integer.parseInt(decisionString);
            if (!DSEDecoder.validRange(i, (RangeDegree)discDegree, discDegree.getFrom(), discDegree.getTo())) {
                throw ExceptionHelper.createNewCoreException("Error: Value " + i + "\" is not a valid value for degree " + designDecision + " " + DegreeOfFreedomHelper.getDegreeDescription(designDecision));
            }
            DiscreteRangeChoice discChoice = factory.createDiscreteRangeChoice();
            discChoice.setChosenValue(i);
            choice = discChoice;
        } else if (designDecision instanceof ClassDegree) {
            ClassChoice enumChoice = factory.createClassChoice();
            Entity entity = DSEDecoder.getEntityFor((ClassDegree)designDecision, decisionString);
            if (entity == null) {
                throw ExceptionHelper.createNewCoreException("Error: Decision string \"" + decisionString + "\" is not a valid value for degree " + designDecision + " " + DegreeOfFreedomHelper.getDegreeDescription(designDecision));
            }
            enumChoice.setChosenValue((EObject)entity);
            choice = enumChoice;
        } else if (designDecision instanceof SchedulingPolicyDegree) {
            ClassChoice schedChoice = factory.createClassChoice();
            SchedulingPolicy chosenPolicy = null;
            EList options = ((SchedulingPolicyDegree)designDecision).getClassDesignOptions();
            for (EObject option : options) {
                SchedulingPolicy policy;
                if (!(option instanceof SchedulingPolicy) || !(policy = (SchedulingPolicy)option).toString().equals(decisionString)) continue;
                chosenPolicy = policy;
            }
            if (chosenPolicy == null) {
                throw ExceptionHelper.createNewCoreException("Error: Decision string \"" + decisionString + "\" is not a valid value for degree " + designDecision + " " + DegreeOfFreedomHelper.getDegreeDescription(designDecision));
            }
            schedChoice.setChosenValue(chosenPolicy);
            choice = schedChoice;
        } else if (designDecision instanceof NumberOfCoresDegree) {
            NumberOfCoresDegree numOfCoresDegree = (NumberOfCoresDegree)designDecision;
            DiscreteRangeChoice discreteRangeChoice = factory.createDiscreteRangeChoice();
            int numberOfCores = Integer.parseInt(decisionString);
            discreteRangeChoice.setChosenValue(numberOfCores);
            choice = discreteRangeChoice;
        } else {
            logger.warn((Object)("There was an unrecognised design decision " + designDecision.getClass()));
            return null;
        }
        choice.setDegreeOfFreedomInstance(designDecision);
        return choice;
    }

    private static boolean validRange(double value, RangeDegree designDecision, double from, double to) {
        return value >= from && value <= to;
    }

    private static Entity getEntityFor(ClassDegree designDecision, String decisionString) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (EObject entity : designDecision.getClassDesignOptions()) {
            if (!(entity instanceof Entity)) continue;
            entities.add((Entity)entity);
        }
        return DSEDecoder.getEntityByName(entities, decisionString);
    }

    private static Entity getEntityByName(List<Entity> entities, String decisionString) {
        for (Entity entity : entities) {
            if (!DSEDecoder.getDecisionString(entity).equals(decisionString)) continue;
            return entity;
        }
        return null;
    }

    public static void applyChangeToGenotype(DesignDecisionGenotype genotype, DegreeOfFreedomInstance degree, Choice choice) {
        int index = Opt4JStarter.getProblem().getDesignDecisions().indexOf(degree);
        genotype.set(index, choice);
    }
}

