/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.codegen.simucom.transformations;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import de.uka.ipd.sdq.pcm.codegen.simucom.helper.M2TFileSystemAccess;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.JavaNamesExt;
import de.uka.ipd.sdq.pcm.codegen.simucom.transformations.PCMext;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.ProvidedDelegationConnector;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.InfrastructureInterface;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class BuildXpt {
    @Inject
    private M2TFileSystemAccess fsa;
    @Inject
    @Extension
    private JavaNamesExt _javaNamesExt;
    @Inject
    @Extension
    private PCMext _pCMext;

    public void buildScripts(UsageModel um) {
        this.buildProperties(um);
        this.fileList(um);
        this.clientXML(um);
        this.applicationXML(um);
    }

    private void buildProperties(UsageModel um) {
        String fileName = "build.properties";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"# Name of the application to build");
        _builder.newLine();
        _builder.append((Object)"projectname=pcm-generated-default-name");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Source Directory");
        _builder.newLine();
        _builder.append((Object)"src=src");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Class Directory");
        _builder.newLine();
        _builder.append((Object)"build=bin");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Directory in which the jar contents are collected");
        _builder.newLine();
        _builder.append((Object)"dist-dir=dist");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Path to a folder containing all additionally needed libs");
        _builder.newLine();
        _builder.append((Object)"lib-dir=libs");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Path to the SUN Appserver Bin Directory");
        _builder.newLine();
        _builder.append((Object)"sun-appserver-dir=C:/sun/sdk/bin");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"# Name of the Directory in which to place the final jars/ears");
        _builder.newLine();
        _builder.append((Object)"output=output");
        _builder.newLine();
        String fileContent = _builder.toString();
        this.fsa.generateFile("build.properties", fileContent);
    }

    private void fileList(UsageModel um) {
        String fileName = "generated-filesets.xml";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<project name=\"generated-filesets\">");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<fileset id=\"client-classes\" dir=\"${dist-dir}\">");
        _builder.newLine();
        EList _usageScenario_UsageModel = um.getUsageScenario_UsageModel();
        for (UsageScenario us : _usageScenario_UsageModel) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"<include name=\"");
            String _basePackageName = this._javaNamesExt.basePackageName((Entity)us);
            String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_basePackageName);
            _builder.append((Object)_fqnToDirectoryPath, "\t\t");
            _builder.append((Object)"/**/*.class\" />");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<include name=\"*.class\" />");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<include name=\"META-INF/application-client.xml\" />");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"</fileset>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<fileset id=\"ejb-classes\" dir=\"${dist-dir}\">");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList _usageScenario_UsageModel_1 = um.getUsageScenario_UsageModel();
        Functions.Function1<UsageScenario, EList<AbstractUserAction>> _function = new Functions.Function1<UsageScenario, EList<AbstractUserAction>>(){

            public EList<AbstractUserAction> apply(UsageScenario it) {
                ScenarioBehaviour _scenarioBehaviour_UsageScenario = it.getScenarioBehaviour_UsageScenario();
                return _scenarioBehaviour_UsageScenario.getActions_ScenarioBehaviour();
            }
        };
        List _map = ListExtensions.map((List)_usageScenario_UsageModel_1, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        Iterable _filter = Iterables.filter((Iterable)_flatten, EntryLevelSystemCall.class);
        Functions.Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function_1 = new Functions.Function1<EntryLevelSystemCall, InterfaceProvidingEntity>(){

            public InterfaceProvidingEntity apply(EntryLevelSystemCall it) {
                OperationProvidedRole _providedRole_EntryLevelSystemCall = it.getProvidedRole_EntryLevelSystemCall();
                return _providedRole_EntryLevelSystemCall.getProvidingEntity_ProvidedRole();
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Iterable _filter_1 = Iterables.filter((Iterable)_map_1, System.class);
        Set systems = IterableExtensions.toSet((Iterable)_filter_1);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        for (System system : systems) {
            String _includeClasses = this.includeClasses((CDOObject)system);
            _builder.append((Object)_includeClasses, "\t\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"<include name=\"META-INF/ejb-jar.xml\" />");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"</fileset>");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"</project>\t");
        _builder.newLine();
        String fileContent = _builder.toString();
        this.fsa.generateFile("generated-filesets.xml", fileContent);
    }

    private void applicationXML(UsageModel um) {
        String fileName = "META-INF/application.xml";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<application version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd\">");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<display-name>@@projectname@@</display-name>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<module>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<java>@@projectname@@-client.jar</java>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"</module>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"<module>");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<ejb>@@projectname@@-ejb.jar</ejb>");
        _builder.newLine();
        _builder.append((Object)"  ");
        _builder.append((Object)"</module>");
        _builder.newLine();
        _builder.append((Object)"</application>");
        _builder.newLine();
        String fileContent = _builder.toString();
        this.fsa.generateFile("META-INF/application.xml", fileContent);
    }

    private void clientXML(UsageModel um) {
        String fileName = "META-INF/application-client.xml";
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        _builder.newLine();
        _builder.append((Object)"<application-client version=\"5\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application-client_5.xsd\">");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"<display-name>@@projectname@@-Client</display-name>");
        _builder.newLine();
        _builder.append((Object)"    ");
        EList _usageScenario_UsageModel = um.getUsageScenario_UsageModel();
        Functions.Function1<UsageScenario, EList<AbstractUserAction>> _function = new Functions.Function1<UsageScenario, EList<AbstractUserAction>>(){

            public EList<AbstractUserAction> apply(UsageScenario it) {
                ScenarioBehaviour _scenarioBehaviour_UsageScenario = it.getScenarioBehaviour_UsageScenario();
                return _scenarioBehaviour_UsageScenario.getActions_ScenarioBehaviour();
            }
        };
        List _map = ListExtensions.map((List)_usageScenario_UsageModel, (Functions.Function1)_function);
        Iterable _flatten = Iterables.concat((Iterable)_map);
        Iterable _filter = Iterables.filter((Iterable)_flatten, EntryLevelSystemCall.class);
        Functions.Function1<EntryLevelSystemCall, OperationProvidedRole> _function_1 = new Functions.Function1<EntryLevelSystemCall, OperationProvidedRole>(){

            public OperationProvidedRole apply(EntryLevelSystemCall it) {
                return it.getProvidedRole_EntryLevelSystemCall();
            }
        };
        Iterable _map_1 = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Set systemCalls = IterableExtensions.toSet((Iterable)_map_1);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"   ");
        for (OperationProvidedRole systemCall : systemCalls) {
            CharSequence _ejbClientRef = this.ejbClientRef((ProvidedRole)systemCall);
            _builder.append((Object)_ejbClientRef, "   ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"    ");
        _builder.append((Object)".providedRole_EntryLevelSystemCall.toSet()\u00bb");
        _builder.newLine();
        _builder.append((Object)"</application-client>");
        _builder.newLine();
        String fileContent = _builder.toString();
        this.fsa.generateFile("META-INF/application-client.xml", fileContent);
    }

    protected String _includeClasses(Repository repository) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<include name=\"");
        String _javaName = this._javaNamesExt.javaName((Entity)repository);
        String _lowerCase = _javaName.toLowerCase();
        String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_lowerCase);
        _builder.append((Object)_fqnToDirectoryPath, "");
        _builder.append((Object)"\"/**/*.class\" />");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected String _includeClasses(System system) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<include name=\"");
        String _javaName = this._javaNamesExt.javaName((Entity)system);
        String _lowerCase = _javaName.toLowerCase();
        String _fqnToDirectoryPath = this._javaNamesExt.fqnToDirectoryPath(_lowerCase);
        _builder.append((Object)_fqnToDirectoryPath, "");
        _builder.append((Object)"\"/**/*.class\" />");
        _builder.newLineIfNotEmpty();
        Set<Entity> _collectRepositories = this._pCMext.collectRepositories((CDOObject)system);
        for (Entity repository : _collectRepositories) {
            String _includeClasses = this.includeClasses((CDOObject)repository);
            _builder.append((Object)_includeClasses, "");
        }
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    protected CharSequence _ejbClientRef(final OperationProvidedRole role) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<ejb-ref>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<ejb-ref-name>ejb/");
        OperationInterface _providedInterface__OperationProvidedRole = role.getProvidedInterface__OperationProvidedRole();
        String _javaName = this._javaNamesExt.javaName((Entity)_providedInterface__OperationProvidedRole);
        _builder.append((Object)_javaName, "\t");
        _builder.append((Object)"</ejb-ref-name>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<ejb-ref-type>Session</ejb-ref-type> ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<remote>");
        OperationInterface _providedInterface__OperationProvidedRole_1 = role.getProvidedInterface__OperationProvidedRole();
        String _fqn = this._javaNamesExt.fqn((Entity)_providedInterface__OperationProvidedRole_1);
        _builder.append((Object)_fqn, "\t");
        _builder.append((Object)"</remote>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        InterfaceProvidingEntity _providingEntity_ProvidedRole = role.getProvidingEntity_ProvidedRole();
        EList _connectors__ComposedStructure = ((System)_providingEntity_ProvidedRole).getConnectors__ComposedStructure();
        Iterable _filter = Iterables.filter((Iterable)_connectors__ComposedStructure, ProvidedDelegationConnector.class);
        Functions.Function1<ProvidedDelegationConnector, Boolean> _function = new Functions.Function1<ProvidedDelegationConnector, Boolean>(){

            public Boolean apply(ProvidedDelegationConnector it) {
                OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = it.getOuterProvidedRole_ProvidedDelegationConnector();
                return Objects.equal((Object)_outerProvidedRole_ProvidedDelegationConnector, (Object)role);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        ProvidedDelegationConnector delegationConnector = (ProvidedDelegationConnector)IterableExtensions.head((Iterable)_filter_1);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        AssemblyContext componentContext = delegationConnector.getAssemblyContext_ProvidedDelegationConnector();
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<ejb-link>");
        RepositoryComponent _encapsulatedComponent__AssemblyContext = componentContext.getEncapsulatedComponent__AssemblyContext();
        String _javaName_1 = this._javaNamesExt.javaName((Entity)_encapsulatedComponent__AssemblyContext);
        _builder.append((Object)_javaName_1, "\t");
        _builder.append((Object)"_");
        OperationInterface _providedInterface__OperationProvidedRole_2 = role.getProvidedInterface__OperationProvidedRole();
        String _javaName_2 = this._javaNamesExt.javaName((Entity)_providedInterface__OperationProvidedRole_2);
        _builder.append((Object)_javaName_2, "\t");
        _builder.append((Object)"_");
        String _id = componentContext.getId();
        _builder.append((Object)_id, "\t");
        _builder.append((Object)"</ejb-link> ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</ejb-ref>");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence _ejbClientRef(final InfrastructureProvidedRole role) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"<ejb-ref>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"<ejb-ref-name>ejb/");
        InfrastructureInterface _providedInterface__InfrastructureProvidedRole = role.getProvidedInterface__InfrastructureProvidedRole();
        String _javaName = this._javaNamesExt.javaName((Entity)_providedInterface__InfrastructureProvidedRole);
        _builder.append((Object)_javaName, "\t");
        _builder.append((Object)"</ejb-ref-name>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t   ");
        _builder.append((Object)"<ejb-ref-type>Session</ejb-ref-type> ");
        _builder.newLine();
        _builder.append((Object)"\t   ");
        _builder.append((Object)"<remote>");
        InfrastructureInterface _providedInterface__InfrastructureProvidedRole_1 = role.getProvidedInterface__InfrastructureProvidedRole();
        String _fqn = this._javaNamesExt.fqn((Entity)_providedInterface__InfrastructureProvidedRole_1);
        _builder.append((Object)_fqn, "\t   ");
        _builder.append((Object)"</remote>");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t   ");
        InterfaceProvidingEntity _providingEntity_ProvidedRole = role.getProvidingEntity_ProvidedRole();
        EList _connectors__ComposedStructure = ((System)_providingEntity_ProvidedRole).getConnectors__ComposedStructure();
        Iterable _filter = Iterables.filter((Iterable)_connectors__ComposedStructure, ProvidedDelegationConnector.class);
        Functions.Function1<ProvidedDelegationConnector, Boolean> _function = new Functions.Function1<ProvidedDelegationConnector, Boolean>(){

            public Boolean apply(ProvidedDelegationConnector it) {
                OperationProvidedRole _outerProvidedRole_ProvidedDelegationConnector = it.getOuterProvidedRole_ProvidedDelegationConnector();
                return Objects.equal((Object)_outerProvidedRole_ProvidedDelegationConnector, (Object)role);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        ProvidedDelegationConnector delegationConnector = (ProvidedDelegationConnector)IterableExtensions.head((Iterable)_filter_1);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        AssemblyContext componentContext = delegationConnector.getAssemblyContext_ProvidedDelegationConnector();
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"<ejb-link>");
        RepositoryComponent _encapsulatedComponent__AssemblyContext = componentContext.getEncapsulatedComponent__AssemblyContext();
        String _javaName_1 = this._javaNamesExt.javaName((Entity)_encapsulatedComponent__AssemblyContext);
        _builder.append((Object)_javaName_1, "\t");
        _builder.append((Object)"_");
        InfrastructureInterface _providedInterface__InfrastructureProvidedRole_2 = role.getProvidedInterface__InfrastructureProvidedRole();
        String _javaName_2 = this._javaNamesExt.javaName((Entity)_providedInterface__InfrastructureProvidedRole_2);
        _builder.append((Object)_javaName_2, "\t");
        _builder.append((Object)"_");
        String _id = componentContext.getId();
        _builder.append((Object)_id, "\t");
        _builder.append((Object)"</ejb-link> ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"</ejb-ref>");
        _builder.newLine();
        return _builder;
    }

    public String includeClasses(CDOObject system) {
        if (system instanceof System) {
            return this._includeClasses((System)system);
        }
        if (system instanceof Repository) {
            return this._includeClasses((Repository)system);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(system).toString());
    }

    public CharSequence ejbClientRef(ProvidedRole role) {
        if (role instanceof InfrastructureProvidedRole) {
            return this._ejbClientRef((InfrastructureProvidedRole)role);
        }
        if (role instanceof OperationProvidedRole) {
            return this._ejbClientRef((OperationProvidedRole)role);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(role).toString());
    }
}

