/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.cost.helper;

import de.uka.ipd.sdq.pcm.cost.Cost;
import de.uka.ipd.sdq.pcm.cost.CostRepository;
import de.uka.ipd.sdq.pcm.cost.ScalarFunction;
import de.uka.ipd.sdq.pcm.cost.VariableProcessingResourceCost;
import de.uka.ipd.sdq.pcm.cost.helper.CostStoExCache;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityFunctionFactoryImpl;
import de.uka.ipd.sdq.simucomframework.SimuComDefaultRandomNumberGenerator;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCacheEntry;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.PCMStoExEvaluationVisitor;
import de.uka.ipd.sdq.simucomframework.variables.stoexvisitor.VariableMode;
import de.uka.ipd.sdq.stoex.Expression;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class CostUtil {
    private static Logger logger = Logger.getLogger((String)"de.uka.ipd.sdq.pcm.cost.helper.CostUtil");
    private static final String PROCESSING_RATE_VARIABLE = "procRate.VALUE";
    private static final String NUMBER_OF_CORES_VARIABLE = "numberOfReplicas.VALUE";
    private CostStoExCache stoExCache;
    private IRandomGenerator randomGenerator = new SimuComDefaultRandomNumberGenerator(null);
    private IProbabilityFunctionFactory probFunctionFactory = ProbabilityFunctionFactoryImpl.getInstance();
    private static CostUtil singletonInstance = null;

    public static CostUtil getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new CostUtil();
        }
        return singletonInstance;
    }

    private CostUtil() {
        this.probFunctionFactory.setRandomGenerator(this.randomGenerator);
        this.stoExCache = new CostStoExCache(this.probFunctionFactory);
    }

    public double getDoubleFromSpecification(String specification) {
        if (StoExCache.singleton() == null) {
            StoExCache.initialiseStoExCache((IProbabilityFunctionFactory)this.probFunctionFactory);
        }
        Object rate = StackContext.evaluateStatic((String)specification);
        return CostUtil.toDoubleOrZero(rate);
    }

    private static double toDoubleOrZero(Object number) {
        if (Double.class.isInstance(number)) {
            return (Double)number;
        }
        if (Integer.class.isInstance(number)) {
            return ((Integer)number).doubleValue();
        }
        return 0.0;
    }

    public double getOperatingCost(VariableProcessingResourceCost varCost) {
        double functionValue = this.solveFunctionExpression(varCost, varCost.getProcessingRateOperatingFunction());
        double cost = varCost.getFixedOperatingCost() + functionValue;
        return cost;
    }

    private double solveFunctionExpression(VariableProcessingResourceCost varCost, ScalarFunction scalarFunction) {
        if (scalarFunction == null || scalarFunction.getSpecification() == "") {
            return 0.0;
        }
        double processingRate = this.getProcessingRate(varCost);
        int numberOfCores = this.getNumberOfReplicas(varCost);
        String specification = scalarFunction.getSpecification();
        SimulatedStackframe stackframe = new SimulatedStackframe();
        stackframe.addValue(PROCESSING_RATE_VARIABLE, (Object)processingRate);
        stackframe.addValue(NUMBER_OF_CORES_VARIABLE, (Object)numberOfCores);
        try {
            StoExCacheEntry stoExEntry = this.stoExCache.getEntry(specification);
            Expression parsedExpression = stoExEntry.getParsedExpression();
            PCMStoExEvaluationVisitor visitor = new PCMStoExEvaluationVisitor(stoExEntry, stackframe, VariableMode.RETURN_DEFAULT_ON_NOT_FOUND, this.probFunctionFactory);
            Object number = visitor.doSwitch((EObject)parsedExpression);
            return CostUtil.toDoubleOrZero(number);
        }
        catch (RuntimeException e) {
            logger.warn((Object)("Error when evaluating processing rate cost function: " + e.getMessage()));
            e.printStackTrace();
            return 0.0;
        }
    }

    public double getInitialCost(VariableProcessingResourceCost varCost) {
        double functionValue = this.solveFunctionExpression(varCost, varCost.getProcessingRateInitialFunction());
        double cost = varCost.getFixedInitialCost() + functionValue;
        return cost;
    }

    private double getProcessingRate(VariableProcessingResourceCost varCost) {
        if (varCost.getProcessingresourcespecification() != null && varCost.getProcessingresourcespecification().getProcessingRate_ProcessingResourceSpecification() != null && varCost.getProcessingresourcespecification().getProcessingRate_ProcessingResourceSpecification().getSpecification() != null) {
            return this.getDoubleFromSpecification(varCost.getProcessingresourcespecification().getProcessingRate_ProcessingResourceSpecification().getSpecification());
        }
        return 0.0;
    }

    private int getNumberOfReplicas(VariableProcessingResourceCost varCost) {
        if (varCost.getProcessingresourcespecification() != null) {
            return varCost.getProcessingresourcespecification().getNumberOfReplicas();
        }
        return 0;
    }

    public void resetCache() {
        this.stoExCache = new CostStoExCache(this.probFunctionFactory);
    }

    public static double getTotalCost(Cost cost) {
        CostRepository costRepository = CostUtil.getCostRepository(cost);
        double interest = costRepository.getInterest();
        int numberOfYears = costRepository.getTimePeriodYears();
        double operatingCost = cost.getOperatingCost();
        double initialCost = cost.getInitialCost();
        return CostUtil.getTotalCost(initialCost, operatingCost, interest, numberOfYears);
    }

    public static double getTotalCost(double initialCost, double operatingCost, double interest, int numberOfYears) {
        double operatingCostWithInterest = 0.0;
        if (interest < 0.0) {
            logger.error((Object)"Negative interest rate not supported by cost evaluator");
            return Double.NaN;
        }
        if (numberOfYears == 0) {
            if (interest == 0.0) {
                if (operatingCost > 0.0) {
                    logger.warn((Object)"Interest rate of 0, no time period, and positive operating cost lead to infinite costs over time: Setting total cost to infinity.");
                    return Double.POSITIVE_INFINITY;
                }
                operatingCostWithInterest = 0.0;
            } else {
                operatingCostWithInterest = operatingCost / interest;
            }
        } else {
            operatingCostWithInterest = interest == 0.0 ? operatingCost * (double)numberOfYears : operatingCost * ((1.0 - Math.pow(1.0 + interest, -1 * numberOfYears)) / interest);
        }
        return initialCost + operatingCostWithInterest;
    }

    private static CostRepository getCostRepository(EObject object) {
        EObject container = object.eContainer();
        if (container == null) {
            return null;
        }
        if (container instanceof CostRepository) {
            return (CostRepository)container;
        }
        return CostUtil.getCostRepository(container);
    }
}

