/**
 */
package de.uka.ipd.sdq.pcm.designdecision.gdof.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.uka.ipd.sdq.pcm.designdecision.gdof.util.gdofAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class gdofItemProviderAdapterFactory extends gdofAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public gdofItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.ChangeableElementDescription} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ChangeableElementDescriptionItemProvider changeableElementDescriptionItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.ChangeableElementDescription}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createChangeableElementDescriptionAdapter() {
        if (this.changeableElementDescriptionItemProvider == null) {
            this.changeableElementDescriptionItemProvider = new ChangeableElementDescriptionItemProvider(this);
        }

        return this.changeableElementDescriptionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.ValueRule} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected ValueRuleItemProvider valueRuleItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.designdecision.gdof.ValueRule}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createValueRuleAdapter() {
        if (this.valueRuleItemProvider == null) {
            this.valueRuleItemProvider = new ValueRuleItemProvider(this);
        }

        return this.valueRuleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.OCLRule} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    protected OCLRuleItemProvider oclRuleItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.designdecision.gdof.OCLRule}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createOCLRuleAdapter() {
        if (this.oclRuleItemProvider == null) {
            this.oclRuleItemProvider = new OCLRuleItemProvider(this);
        }

        return this.oclRuleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.HelperOCLDefinition} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected HelperOCLDefinitionItemProvider helperOCLDefinitionItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.HelperOCLDefinition}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createHelperOCLDefinitionAdapter() {
        if (this.helperOCLDefinitionItemProvider == null) {
            this.helperOCLDefinitionItemProvider = new HelperOCLDefinitionItemProvider(this);
        }

        return this.helperOCLDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.DoFRepository} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DoFRepositoryItemProvider doFRepositoryItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.designdecision.gdof.DoFRepository}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDoFRepositoryAdapter() {
        if (this.doFRepositoryItemProvider == null) {
            this.doFRepositoryItemProvider = new DoFRepositoryItemProvider(this);
        }

        return this.doFRepositoryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.InstanceSelectionRule} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InstanceSelectionRuleItemProvider instanceSelectionRuleItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.InstanceSelectionRule}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createInstanceSelectionRuleAdapter() {
        if (this.instanceSelectionRuleItemProvider == null) {
            this.instanceSelectionRuleItemProvider = new InstanceSelectionRuleItemProvider(this);
        }

        return this.instanceSelectionRuleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.StaticSelectionRule} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected StaticSelectionRuleItemProvider staticSelectionRuleItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.StaticSelectionRule}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createStaticSelectionRuleAdapter() {
        if (this.staticSelectionRuleItemProvider == null) {
            this.staticSelectionRuleItemProvider = new StaticSelectionRuleItemProvider(this);
        }

        return this.staticSelectionRuleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.DegreeOfFreedom} instances. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DegreeOfFreedomItemProvider degreeOfFreedomItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.pcm.designdecision.gdof.DegreeOfFreedom}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDegreeOfFreedomAdapter() {
        if (this.degreeOfFreedomItemProvider == null) {
            this.degreeOfFreedomItemProvider = new DegreeOfFreedomItemProvider(this);
        }

        return this.degreeOfFreedomItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.DecoratorModelDescription} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DecoratorModelDescriptionItemProvider decoratorModelDescriptionItemProvider;

    /**
     * This creates an adapter for a
     * {@link de.uka.ipd.sdq.pcm.designdecision.gdof.DecoratorModelDescription}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDecoratorModelDescriptionAdapter() {
        if (this.decoratorModelDescriptionItemProvider == null) {
            this.decoratorModelDescriptionItemProvider = new DecoratorModelDescriptionItemProvider(this);
        }

        return this.decoratorModelDescriptionItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.changeableElementDescriptionItemProvider != null) {
            this.changeableElementDescriptionItemProvider.dispose();
        }
        if (this.valueRuleItemProvider != null) {
            this.valueRuleItemProvider.dispose();
        }
        if (this.oclRuleItemProvider != null) {
            this.oclRuleItemProvider.dispose();
        }
        if (this.helperOCLDefinitionItemProvider != null) {
            this.helperOCLDefinitionItemProvider.dispose();
        }
        if (this.doFRepositoryItemProvider != null) {
            this.doFRepositoryItemProvider.dispose();
        }
        if (this.instanceSelectionRuleItemProvider != null) {
            this.instanceSelectionRuleItemProvider.dispose();
        }
        if (this.staticSelectionRuleItemProvider != null) {
            this.staticSelectionRuleItemProvider.dispose();
        }
        if (this.degreeOfFreedomItemProvider != null) {
            this.degreeOfFreedomItemProvider.dispose();
        }
        if (this.decoratorModelDescriptionItemProvider != null) {
            this.decoratorModelDescriptionItemProvider.dispose();
        }
    }

}
