/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.composite.custom;

import de.uka.ipd.sdq.pcm.gmf.composite.custom.AbstractBorderFigure;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class BallFigure
extends AbstractBorderFigure {
    public BallFigure(int logicalSize, AbstractBorderFigure.POSITION_TYPE posType) {
        super(logicalSize, posType);
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.getBorderItemLocator() == null) {
            System.out.println("border item locator null in BallFigure.paintFigure");
        }
        int side = this.getBorderItemLocator() == null ? 8 : this.getBorderItemLocator().getCurrentSideOfParent();
        Rectangle rect = new Rectangle();
        graphics.getClip(rect);
        rect.shrink(1, 1);
        switch (side) {
            case 16: {
                graphics.drawLine(rect.getLeft().x, rect.getCenter().y, rect.getCenter().x, rect.getCenter().y);
                graphics.drawOval(rect.getCenter().x, rect.getTop().y + rect.height / 4, rect.height / 2, rect.height / 2);
                break;
            }
            case 8: {
                graphics.drawLine(rect.getRight().x, rect.getCenter().y, rect.getCenter().x, rect.getCenter().y);
                graphics.drawOval(rect.getLeft().x, rect.getTop().y + rect.height / 4, rect.height / 2, rect.height / 2);
                break;
            }
            case 1: {
                graphics.drawLine(rect.getCenter().x, rect.getBottom().y, rect.getCenter().x, rect.getCenter().y);
                graphics.drawOval(rect.getCenter().x - rect.width / 4, rect.getTop().y, rect.height / 2, rect.height / 2);
                break;
            }
            case 4: {
                graphics.drawLine(rect.getCenter().x, rect.getTop().y, rect.getCenter().x, rect.getCenter().y);
                graphics.drawOval(rect.getCenter().x - rect.width / 4, rect.getCenter().y, rect.height / 2, rect.height / 2);
            }
        }
    }

    private Rectangle getBallBounds() {
        int side = this.getBorderItemLocator() == null ? 8 : this.getBorderItemLocator().getCurrentSideOfParent();
        Rectangle rect = this.getBounds();
        Rectangle result = null;
        switch (side) {
            case 16: {
                result = new Rectangle(rect.getCenter().x, rect.getTop().y + rect.height / 4, rect.height / 2, rect.height / 2);
                break;
            }
            case 8: {
                result = new Rectangle(rect.getLeft().x, rect.getTop().y + rect.height / 4, rect.height / 2, rect.height / 2);
                break;
            }
            case 1: {
                result = new Rectangle(rect.getCenter().x - rect.width / 4, rect.getTop().y, rect.height / 2, rect.height / 2);
                break;
            }
            case 4: {
                result = new Rectangle(rect.getCenter().x - rect.width / 4, rect.getCenter().y, rect.height / 2, rect.height / 2);
            }
        }
        return result;
    }

    @Override
    protected ConnectionAnchor createAnchorInternal() {
        return new BallAnchor((IFigure)this);
    }

    @Override
    protected ConnectionAnchor createAnchorExternal() {
        return new AbstractBorderFigure.StemAnchor((IFigure)this);
    }

    private class BallAnchor
    extends AbstractConnectionAnchor {
        public BallAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = this.getAnchorPoint(reference);
            return p;
        }

        private Point getAnchorPoint(Point reference) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(BallFigure.this.getBallBounds());
            r.translate(-1, -1);
            r.resize(1, 1);
            this.getOwner().translateToAbsolute((Translatable)r);
            Point ref = r.getCenter().negate().translate(reference);
            if (ref.x == 0) {
                return new Point(reference.x, ref.y > 0 ? r.bottom() : r.y);
            }
            if (ref.y == 0) {
                return new Point(ref.x > 0 ? r.right() : r.x, reference.y);
            }
            float dx = ref.x > 0 ? 0.5f : -0.5f;
            float dy = ref.y > 0 ? 0.5f : -0.5f;
            float k = (float)(ref.y * r.width) / (float)(ref.x * r.height);
            k *= k;
            return r.getCenter().translate((int)((double)((float)r.width * dx) / Math.sqrt(1.0f + k)), (int)((double)((float)r.height * dy) / Math.sqrt(1.0f + 1.0f / k)));
        }
    }
}

