/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.pcm.gmf.composite.custom;

import de.uka.ipd.sdq.pcm.gmf.composite.custom.AbstractBorderFigure;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public class SinkFigure
extends AbstractBorderFigure {
    public SinkFigure(int logicalSize, AbstractBorderFigure.POSITION_TYPE posType) {
        super(logicalSize, posType);
    }

    @Override
    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.getBorderItemLocator() == null) {
            System.out.println("border item locator null in SocketFigure.paintFigure");
        }
        int side = this.getBorderItemLocator() == null ? 8 : this.getBorderItemLocator().getCurrentSideOfParent();
        Rectangle rect = new Rectangle();
        graphics.getClip(rect);
        switch (side) {
            case 16: {
                graphics.drawLine(rect.getLeft().x, rect.getCenter().y, rect.getCenter().x - rect.width / 4, rect.getCenter().y);
                graphics.drawLine(rect.getCenter().x - rect.width / 4, rect.getTop().y + rect.height / 4, rect.getCenter().x - rect.width / 4, rect.getBottom().y - rect.height / 4);
                graphics.drawLine(rect.getCenter().x - rect.width / 4, rect.getTop().y + rect.height / 4, rect.getRight().x - rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getCenter().x - rect.width / 4, rect.getBottom().y - rect.height / 4, rect.getRight().x - rect.width / 4, rect.getBottom().y - rect.height / 4);
                graphics.drawLine(rect.getCenter().x, rect.getCenter().y, rect.getRight().x - rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getCenter().x, rect.getCenter().y, rect.getRight().x - rect.width / 4, rect.getBottom().y - rect.height / 4);
                break;
            }
            case 8: {
                graphics.drawLine(rect.getRight().x, rect.getCenter().y, rect.getCenter().x + rect.width / 4, rect.getCenter().y);
                graphics.drawLine(rect.getCenter().x + rect.width / 4, rect.getTop().y + rect.height / 4, rect.getCenter().x + rect.width / 4, rect.getBottom().y - rect.height / 4);
                graphics.drawLine(rect.getLeft().x + rect.width / 4, rect.getTop().y + rect.height / 4, rect.getCenter().x + rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getLeft().x + rect.width / 4, rect.getBottom().y - rect.height / 4, rect.getCenter().x + rect.width / 4, rect.getBottom().y - rect.height / 4);
                graphics.drawLine(rect.getCenter().x, rect.getCenter().y, rect.getLeft().x + rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getCenter().x, rect.getCenter().y, rect.getLeft().x + rect.width / 4, rect.getBottom().y - rect.height / 4);
                break;
            }
            case 1: {
                graphics.drawLine(rect.getCenter().x, rect.getBottom().y, rect.getCenter().x, rect.getCenter().y + rect.height / 4);
                graphics.drawLine(rect.getLeft().x + rect.width / 4, rect.getCenter().y + rect.height / 4, rect.getRight().x - rect.width / 4, rect.getCenter().y + rect.height / 4);
                graphics.drawLine(rect.getLeft().x + rect.width / 4, rect.getCenter().y + rect.height / 4, rect.getLeft().x + rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getRight().x - rect.width / 4, rect.getCenter().y + rect.height / 4, rect.getRight().x - rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getCenter().x, rect.getCenter().y, rect.getLeft().x + rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getCenter().x, rect.getCenter().y, rect.getRight().x - rect.width / 4, rect.getTop().y + rect.height / 4);
                break;
            }
            case 4: {
                graphics.drawLine(rect.getCenter().x, rect.getTop().y, rect.getCenter().x, rect.getCenter().y - rect.height / 4);
                graphics.drawLine(rect.getLeft().x + rect.width / 4, rect.getCenter().y - rect.height / 4, rect.getRight().x - rect.width / 4, rect.getCenter().y - rect.height / 4);
                graphics.drawLine(rect.getLeft().x + rect.width / 4, rect.getCenter().y + rect.height / 4, rect.getLeft().x + rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getRight().x - rect.width / 4, rect.getCenter().y + rect.height / 4, rect.getRight().x - rect.width / 4, rect.getTop().y + rect.height / 4);
                graphics.drawLine(rect.getLeft().x + rect.width / 4, rect.getBottom().y - rect.height / 4, rect.getCenter().x, rect.getCenter().y);
                graphics.drawLine(rect.getCenter().x, rect.getCenter().y, rect.getRight().x - rect.width / 4, rect.getBottom().y - rect.height / 4);
            }
        }
    }

    private Point getSinkCenter() {
        int side = this.getBorderItemLocator() == null ? 8 : this.getBorderItemLocator().getCurrentSideOfParent();
        Rectangle rect = this.getBounds();
        Point result = null;
        switch (side) {
            case 16: {
                result = new Point(rect.getCenter().x, rect.getCenter().y);
                break;
            }
            case 8: {
                result = new Point(rect.getCenter().x, rect.getCenter().y);
                break;
            }
            case 1: {
                result = new Point(rect.getCenter().x, rect.getCenter().y);
                break;
            }
            case 4: {
                result = new Point(rect.getCenter().x, rect.getCenter().y);
            }
        }
        return result;
    }

    @Override
    protected ConnectionAnchor createAnchorInternal() {
        return new SinkAnchor((IFigure)this);
    }

    @Override
    protected ConnectionAnchor createAnchorExternal() {
        return new AbstractBorderFigure.StemAnchor((IFigure)this);
    }

    private class SinkAnchor
    extends AbstractConnectionAnchor {
        public SinkAnchor(IFigure owner) {
            super(owner);
        }

        public Point getLocation(Point reference) {
            Point p = SinkFigure.this.getSinkCenter();
            this.getOwner().translateToAbsolute((Translatable)p);
            return p;
        }
    }
}

