/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.qvtrengine.medini.impl;

import de.ikv.emf.qvt.EMFQvtProcessorImpl;
import de.ikv.medini.qvt.execution.QvtSemanticAnalyserThreadPool;
import de.ikv.medini.qvt.execution.debug.QVTExitDebugSessionException;
import de.ikv.medini.qvt.model.qvtbase.Transformation;
import de.ikv.medini.qvt.model.qvtbase.TypedModel;
import de.uka.ipd.sdq.qvtrengine.medini.impl.LogWrapper;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.AbstractQVTREngine;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.QVTRScript;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import uk.ac.kent.cs.kmf.util.ILog;

public class MediniQVTREngine
extends AbstractQVTREngine {
    private final Boolean enforce = true;
    private QVTRScript qvtScript;
    private EMFQvtProcessorImpl processorImpl = new EMFQvtProcessorImpl((ILog)new LogWrapper(AbstractQVTREngine.class.getName()));
    private Collection<Collection<Resource>> modelResources = new ArrayList<Collection<Resource>>();
    private Collection<Resource> oldTraces = new ArrayList<Resource>();
    private StringWriter logs = new StringWriter();
    private PrintStream extendedDebuggingLog = null;

    public MediniQVTREngine() {
        Logger.getLogger((String)MediniQVTREngine.class.getName()).addAppender((Appender)new WriterAppender((Layout)new PatternLayout("%-5p [%t]: %m%n"), (Writer)this.logs));
    }

    public void addModels(Collection<Resource> models) {
        this.modelResources.add(models);
    }

    public void setDebug(Boolean debug) {
        String value = "false";
        if (debug.booleanValue()) {
            value = "true";
        }
        this.setProperty("debug", value);
        this.setProperty("debugTasks", value);
    }

    public void setProperty(String name, String value) {
        this.processorImpl.setProperty(name, value);
    }

    public void setQVTRScript(QVTRScript qvtrScript) {
        this.qvtScript = qvtrScript;
        this.addMetaModels(qvtrScript.getMetaModels());
    }

    public void setWorkingDirectory(URI directoryURI) {
        this.processorImpl.setWorkingLocation(directoryURI);
    }

    public void setOldTracesResourceSet(ResourceSet rSet) {
        this.oldTraces.addAll((Collection<Resource>)rSet.getResources());
    }

    public void setTracesResourceSet(ResourceSet rSet) {
        this.processorImpl.setResourceSetForTraces(rSet);
    }

    public void setExtendedDebugingLog(PrintStream extendedDebuggingLog) {
        this.extendedDebuggingLog = extendedDebuggingLog;
    }

    public void transform() {
        if (this.extendedDebuggingLog != null) {
            QvtSemanticAnalyserThreadPool.setLogger((PrintStream)this.extendedDebuggingLog);
        } else {
            QvtSemanticAnalyserThreadPool.setLogger(null);
        }
        this.processorImpl.setModels(this.modelResources);
        this.processorImpl.evaluateQVT(this.qvtScript.toReader(), this.qvtScript.getTransformationName(), this.enforce.booleanValue(), this.qvtScript.getTransformationDirection(), null, this.oldTraces, this.processorImpl.getLog());
        this.processorImpl.setModels((Collection)Collections.EMPTY_LIST);
    }

    protected AbstractQVTREngine.QVTRScriptInfoImpl qvtrScriptInfoImpl() {
        HashMap transformationInfo = new HashMap();
        Boolean valid = true;
        try {
            List contextDeclarations = this.processorImpl.analyseQvt(this.qvtScript.toReader(), this.processorImpl.getLog());
            if (contextDeclarations == null) {
                throw new RuntimeException("Could not analyse QVT script. Aborting evaluation!");
            }
            for (Transformation transformation : contextDeclarations) {
                ArrayList<String> directions = new ArrayList<String>();
                EList modelParameter = transformation.getModelParameter();
                for (TypedModel currentTypedModel : modelParameter) {
                    directions.add(currentTypedModel.getName());
                }
                transformationInfo.put(transformation.getName(), directions);
            }
        }
        catch (QVTExitDebugSessionException e) {
            valid = false;
        }
        return this.createQVTRScriptInfo(transformationInfo, valid);
    }

    protected void addMetaModels(Collection<Object> metamodels) {
        for (Object p : metamodels) {
            if (!(p instanceof EPackage)) continue;
            this.processorImpl.addMetaModel(p);
        }
    }
}

