/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.resources.active;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.entities.SchedulerEntity;
import de.uka.ipd.sdq.scheduler.resources.active.AbstractActiveResource;
import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimEventDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Hashtable;
import java.util.Map;

public class SimFCFSResource
extends AbstractActiveResource {
    private final ProcessingFinishedEvent processingFinished;
    private final Deque<ISchedulableProcess> processQ = new ArrayDeque<ISchedulableProcess>();
    private final Hashtable<ISchedulableProcess, Double> running_processes = new Hashtable();
    private double last_time;

    public SimFCFSResource(SchedulerModel model, String name, String id, long capacity) {
        super(model, capacity, name, id);
        this.processingFinished = new ProcessingFinishedEvent(model);
    }

    public void scheduleNextEvent() {
        ISchedulableProcess first = this.processQ.peek();
        this.processingFinished.removeEvent();
        if (first != null) {
            double time = this.running_processes.get(first);
            this.processingFinished.schedule(first, time);
        }
    }

    private void toNow() {
        ISchedulableProcess first;
        double now = this.getModel().getSimulationControl().getCurrentSimulationTime();
        double passed_time = now - this.last_time;
        if (MathTools.less((double)0.0, (double)passed_time) && (first = this.processQ.peek()) != null) {
            double demand = this.running_processes.get(first);
            double d = demand = MathTools.equalsDouble((double)(demand -= passed_time), (double)0.0) ? 0.0 : demand;
            assert (demand >= 0.0) : "Remaining demand (" + demand + ") smaller than zero!";
            this.running_processes.put(first, demand);
        }
        this.last_time = now;
    }

    @Override
    public void start() {
    }

    @Override
    protected void dequeue(ISchedulableProcess process) {
    }

    @Override
    protected void doProcessing(ISchedulableProcess process, int resourceServiceID, double demand) {
        this.toNow();
        LoggingWrapper.log("FCFS: " + process + " demands " + demand);
        this.running_processes.put(process, demand);
        this.processQ.add(process);
        this.fireStateChange(this.processQ.size(), 0);
        this.scheduleNextEvent();
        process.passivate();
    }

    @Override
    public double getRemainingDemand(ISchedulableProcess process) {
        if (!this.running_processes.contains(process)) {
            return 0.0;
        }
        this.toNow();
        return this.running_processes.get(process);
    }

    @Override
    public void updateDemand(ISchedulableProcess process, double demand) {
        for (Map.Entry<ISchedulableProcess, Double> e : this.running_processes.entrySet()) {
            if (!e.getKey().equals(process)) continue;
            e.setValue(demand);
            break;
        }
        this.scheduleNextEvent();
    }

    @Override
    protected void enqueue(ISchedulableProcess process) {
    }

    @Override
    public void stop() {
        this.processQ.clear();
        this.running_processes.clear();
    }

    @Override
    public void registerProcess(ISchedulableProcess process) {
    }

    @Override
    public int getQueueLengthFor(SchedulerEntity schedulerEntity, int coreID) {
        return this.processQ.size();
    }

    private class ProcessingFinishedEvent
    extends AbstractSimEventDelegator<ISchedulableProcess> {
        public ProcessingFinishedEvent(SchedulerModel model) {
            super((ISimulationModel)model, ProcessingFinishedEvent.class.getName());
        }

        public void eventRoutine(ISchedulableProcess process) {
            ISchedulableProcess first = process;
            SimFCFSResource.this.toNow();
            assert (MathTools.equalsDouble((double)0.0, (double)((Double)SimFCFSResource.this.running_processes.get(first)))) : "Remaining demand (" + SimFCFSResource.access$1(SimFCFSResource.this).get(first) + ") not zero!";
            SimFCFSResource.this.running_processes.remove(first);
            SimFCFSResource.this.processQ.remove(first);
            SimFCFSResource.this.fireStateChange(SimFCFSResource.this.processQ.size(), 0);
            SimFCFSResource.this.fireDemandCompleted(first);
            LoggingWrapper.log("Demand of Process " + first + " finished.");
            SimFCFSResource.this.scheduleNextEvent();
            first.activate();
        }
    }
}

