/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.scheduler.resources.active;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.LoggingWrapper;
import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.entities.SchedulerEntity;
import de.uka.ipd.sdq.scheduler.resources.active.AbstractActiveResource;
import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimEventDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimulationModel;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SimProcessorSharingResource
extends AbstractActiveResource {
    private static final Logger LOGGER = Logger.getLogger(SimProcessorSharingResource.class);
    static double JIFFY = 1.0E-9;
    private final ProcessingFinishedEvent processingFinished;
    private final Hashtable<ISchedulableProcess, Double> running_processes = new Hashtable();
    private double last_time;
    private final List<Integer> numberProcessesOnCore;

    public SimProcessorSharingResource(SchedulerModel model, String name, String id, long capacity) {
        super(model, capacity, name, id);
        this.processingFinished = new ProcessingFinishedEvent(model);
        this.numberProcessesOnCore = new ArrayList<Integer>((int)this.getCapacity());
        int i = 0;
        while ((long)i < this.getCapacity()) {
            this.numberProcessesOnCore.add(0);
            ++i;
        }
    }

    public void scheduleNextEvent() {
        ISchedulableProcess shortest = null;
        for (ISchedulableProcess process : this.running_processes.keySet()) {
            if (shortest != null && !(this.running_processes.get(shortest) > this.running_processes.get(process))) continue;
            shortest = process;
        }
        this.processingFinished.removeEvent();
        if (shortest != null) {
            double remainingTime = this.running_processes.get(shortest) * this.getProcessingDelayFactorPerProcess();
            double d = remainingTime = remainingTime < JIFFY ? 0.0 : remainingTime;
            assert (remainingTime >= 0.0) : "Remaining time (" + remainingTime + ")small than zero!";
            this.processingFinished.schedule(shortest, remainingTime);
        }
    }

    private void toNow() {
        double now = this.getModel().getSimulationControl().getCurrentSimulationTime();
        double passed_time = now - this.last_time;
        double processedDemandperThread = passed_time / this.getProcessingDelayFactorPerProcess();
        if (MathTools.less((double)0.0, (double)passed_time)) {
            for (Map.Entry<ISchedulableProcess, Double> e : this.running_processes.entrySet()) {
                double rem = e.getValue() - processedDemandperThread;
                e.setValue(rem);
            }
        }
        this.last_time = now;
    }

    private double getProcessingDelayFactorPerProcess() {
        double speed = (double)this.running_processes.size() / (double)this.getCapacity();
        return speed < 1.0 ? 1.0 : speed;
    }

    @Override
    public void start() {
    }

    @Override
    protected void dequeue(ISchedulableProcess process) {
    }

    @Override
    protected void doProcessing(ISchedulableProcess process, int resourceServiceID, double demand) {
        this.toNow();
        LoggingWrapper.log("PS: " + process + " demands " + demand);
        if (demand < JIFFY) {
            demand = JIFFY;
            LoggingWrapper.log("PS: " + process + " demand was increased to match JIFFY " + demand);
        }
        this.running_processes.put(process, demand);
        this.reportCoreUsage();
        this.scheduleNextEvent();
        process.passivate();
    }

    private void reportCoreUsage() {
        if ((long)this.running_processes.size() < this.getCapacity()) {
            int i = 0;
            while ((long)i < this.getCapacity()) {
                if (i < this.running_processes.size()) {
                    this.assignProcessesAndFireStateChange(1, i);
                } else {
                    this.assignProcessesAndFireStateChange(0, i);
                }
                ++i;
            }
        } else {
            int minNumberProcessPerCore = (int)Math.floor((double)this.running_processes.size() / (double)this.getCapacity());
            int numberAdditionalProcesses = (int)((long)this.running_processes.size() - (long)minNumberProcessPerCore * this.getCapacity());
            int i = 0;
            while ((long)i < this.getCapacity()) {
                int numberProcessesAtCore;
                if (numberAdditionalProcesses > 0) {
                    numberProcessesAtCore = minNumberProcessPerCore + 1;
                    --numberAdditionalProcesses;
                } else {
                    numberProcessesAtCore = minNumberProcessPerCore;
                }
                this.assignProcessesAndFireStateChange(numberProcessesAtCore, i);
                ++i;
            }
        }
    }

    private void assignProcessesAndFireStateChange(int targetNumberProcessesAtCore, int coreNumber) {
        if (!this.numberProcessesOnCore.get(coreNumber).equals(targetNumberProcessesAtCore)) {
            this.numberProcessesOnCore.set(coreNumber, targetNumberProcessesAtCore);
            this.fireStateChange(targetNumberProcessesAtCore, coreNumber);
        }
    }

    @Override
    public double getRemainingDemand(ISchedulableProcess process) {
        if (!this.running_processes.contains(process)) {
            return 0.0;
        }
        this.toNow();
        return this.running_processes.get(process);
    }

    @Override
    public void updateDemand(ISchedulableProcess process, double demand) {
        boolean updated = false;
        for (Map.Entry<ISchedulableProcess, Double> e : this.running_processes.entrySet()) {
            if (!e.getKey().equals(process)) continue;
            if (Double.isNaN(demand) && LOGGER.isEnabledFor((Priority)Level.INFO)) {
                LOGGER.info((Object)("Specified demand " + demand + "is not a number."));
            }
            e.setValue(demand);
            updated = true;
            break;
        }
        if (!updated) {
            throw new RuntimeException("COULD NOT UPDATE PROCESS!");
        }
        this.scheduleNextEvent();
    }

    @Override
    protected void enqueue(ISchedulableProcess process) {
    }

    @Override
    public void registerProcess(ISchedulableProcess process) {
    }

    @Override
    public int getQueueLengthFor(SchedulerEntity schedulerEntity, int coreID) {
        return this.numberProcessesOnCore.get(coreID);
    }

    @Override
    public void stop() {
    }

    private class ProcessingFinishedEvent
    extends AbstractSimEventDelegator<ISchedulableProcess> {
        public ProcessingFinishedEvent(SchedulerModel model) {
            super((ISimulationModel)model, ProcessingFinishedEvent.class.getName());
        }

        public void eventRoutine(ISchedulableProcess process) {
            ISchedulableProcess last = process;
            SimProcessorSharingResource.this.toNow();
            SimProcessorSharingResource.this.running_processes.remove(last);
            SimProcessorSharingResource.this.reportCoreUsage();
            SimProcessorSharingResource.this.fireDemandCompleted(last);
            LoggingWrapper.log(last + " finished.");
            SimProcessorSharingResource.this.scheduleNextEvent();
            last.activate();
        }
    }
}

