/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Utilization;
import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.UtilizationBucketInformation;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartUtilizationWidthViewer;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.ExportCSVUtilization;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IUtilizationAccepter;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.IUtilizationSeriesExporter;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.LoadCSVUtilization;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Composite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYSeries;

public class JFreeChartUtilizationViewer
extends AbstractJFreeChartUtilizationWidthViewer
implements IUtilizationAccepter,
IUtilizationSeriesExporter {
    public JFreeChartUtilizationViewer(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initializeContextMenu(MenuManager menu_manager) {
        super.initializeContextMenu(menu_manager);
        menu_manager.add((IAction)new LoadCSVUtilization(this));
        menu_manager.add((IAction)new ExportCSVUtilization(this));
    }

    @Override
    public void addUtilization(Utilization utilization) {
        XYSeries density = new XYSeries((Comparable)((Object)utilization.getTitle()), true, false);
        for (UtilizationBucketInformation e : utilization.getBucketInformation()) {
            density.add(e.getValue(), e.getUtilization());
        }
        this.densityDataset.addSeries(density);
        this.densityDataset.setAutoWidth(true);
        this.initChart();
        this.redraw();
    }

    @Override
    protected void initChart() {
        this.chart = ChartFactory.createHistogram((String)"Utilization over Time", (String)"Time", (String)"Utilization", (IntervalXYDataset)this.densityDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.getRangeAxis().setAutoRange(true);
        plot.setForegroundAlpha(0.8f);
        if (this.densityDataset != null) {
            this.densityDataset.setAutoWidth(true);
        }
    }

    @Override
    protected XYSeries computeDensities(Utilization util) {
        XYSeries density = new XYSeries((Comparable)((Object)util.getTitle()), true, false);
        for (UtilizationBucketInformation bucketInformation : util.getBucketInformation()) {
            density.add(bucketInformation.getValue() + util.getBucketWidth() / 2.0, bucketInformation.getUtilization());
        }
        return density;
    }

    @Override
    public XYSeries getSeries() {
        return this.densityDataset.getSeries(0);
    }

    @Override
    public double getUtilizationWidth() {
        return this.densityDataset.getIntervalWidth();
    }
}

