/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.editor;

import de.uka.ipd.sdq.codegen.simudatavisualisation.datatypes.Histogram;
import de.uka.ipd.sdq.sensorframework.adapter.DataAdapter;
import de.uka.ipd.sdq.sensorframework.visualisation.IVisualisation;
import de.uka.ipd.sdq.sensorframework.visualisation.editor.AbstractReportView;
import de.uka.ipd.sdq.sensorframework.visualisation.jfreechartvisualisation.AbstractJFreeChartWidthViewer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractJFreeChartWidthReport
extends AbstractReportView
implements IVisualisation<Histogram> {
    AbstractJFreeChartWidthViewer viewer;
    protected Text widthInput;
    protected double histogramWidth = Double.NaN;
    private List<DataAdapter> adapterList = null;

    protected abstract AbstractJFreeChartWidthViewer createViewer(Composite var1, int var2);

    protected void createReportControls(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        Composite histogramWidthPanel = new Composite(parent, 0);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        histogramWidthPanel.setLayoutData((Object)data);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = true;
        histogramWidthPanel.setLayout((Layout)rowLayout);
        Label label = new Label(histogramWidthPanel, 0x1000000);
        label.setText("Sampling Rate");
        label.setLayoutData((Object)new RowData(-1, -1));
        this.widthInput = new Text(histogramWidthPanel, 2048);
        this.widthInput.setText(Double.toString(this.histogramWidth));
        this.widthInput.setLayoutData((Object)new RowData(60, -1));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (event.character != '\r') break;
                        AbstractJFreeChartWidthReport.this.updateHistogramWidth(Double.parseDouble(AbstractJFreeChartWidthReport.this.widthInput.getText()));
                        break;
                    }
                    case 16: {
                        AbstractJFreeChartWidthReport.this.updateHistogramWidth(Double.parseDouble(AbstractJFreeChartWidthReport.this.widthInput.getText()));
                    }
                }
            }
        };
        this.widthInput.addListener(1, listener);
        this.widthInput.addListener(16, listener);
        this.viewer = this.createViewer(parent, 0);
        GridData data2 = new GridData();
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        data2.verticalAlignment = 4;
        data2.horizontalAlignment = 4;
        this.viewer.setLayoutData(data2);
        histogramWidthPanel.setLayoutData((Object)data);
    }

    private void updateHistogramWidth(double newWidth) {
        this.histogramWidth = newWidth;
        this.setIgnoreDataSettingsChanged(true);
        for (DataAdapter adapter : this.adapterList) {
            Properties adapterProperties = adapter.getProperties();
            adapterProperties.put("HISTOGRAM_WIDTH", (Object)this.histogramWidth);
            adapter.setProperties(adapterProperties);
        }
        this.setIgnoreDataSettingsChanged(false);
        this.generateVisualization(this.adapterList);
    }

    public void setInput(Collection<Histogram> histograms) {
        this.viewer.setData(histograms);
        this.widthInput.setText("" + this.histogramWidth);
    }

    protected void generateVisualization(List<DataAdapter> newList) {
        DataAdapter adapter;
        if (newList == null || newList.isEmpty()) {
            throw new RuntimeException("Histogram reports must have at least one data input.");
        }
        Properties adapterProperties = null;
        double newWidth = Double.NaN;
        if (this.adapterList != null && !this.adapterList.isEmpty()) {
            adapter = this.adapterList.get(0);
            adapterProperties = adapter.getProperties();
            Double test = (Double)adapterProperties.get("HISTOGRAM_WIDTH");
            newWidth = test;
        } else {
            adapter = newList.get(0);
            adapterProperties = adapter.getProperties();
            newWidth = (Double)adapterProperties.get("HISTOGRAM_WIDTH");
        }
        boolean allSameWidth = this.isSameWidth(newList);
        ArrayList<Histogram> newHistogramList = new ArrayList<Histogram>();
        for (DataAdapter adapter2 : newList) {
            if (!allSameWidth) {
                adapterProperties = adapter2.getProperties();
                adapterProperties.put("HISTOGRAM_WIDTH", (Object)newWidth);
                adapter2.setProperties(adapterProperties);
            }
            newHistogramList.add((Histogram)adapter2.getAdaptedObject());
        }
        this.histogramWidth = newWidth;
        this.adapterList = newList;
        this.setInput(newHistogramList);
    }

    private boolean isSameWidth(List<DataAdapter> adapterList) {
        boolean allSameWidth = true;
        double width = Double.NaN;
        double currentWidth = Double.NaN;
        for (DataAdapter adapter : adapterList) {
            Properties adapterProperties = adapter.getProperties();
            currentWidth = (Double)adapterProperties.get("HISTOGRAM_WIDTH");
            if (Double.isNaN(width)) {
                width = currentWidth;
            }
            if (width == currentWidth) continue;
            allSameWidth = false;
        }
        return allSameWidth;
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    public void addInput(Collection<Histogram> c) {
    }

    public void deleteInput(Collection<Histogram> c) {
    }
}

