/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucom.rerunsimulation.jobs;

import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.xtendworkflow.AllocationWorkflowComponent;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.xtendworkflow.SystemWorkflowComponent;
import de.uka.ipd.sdq.codegen.simucontroller.workflow.jobs.xtendworkflow.UsageModelWorkflowComponent;
import de.uka.ipd.sdq.simucom.rerunsimulation.runconfig.RerunSimuComWorkflowConfiguration;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import java.util.HashMap;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.Workflow;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;

public class XtendTransformPCMToCodeJobRerun
extends SequentialBlackboardInteractingJob<MDSDBlackboard>
implements IJob,
IBlackboardInteractingJob<MDSDBlackboard> {
    private RerunSimuComWorkflowConfiguration configuration = null;

    public XtendTransformPCMToCodeJobRerun(RerunSimuComWorkflowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void cleanup(IProgressMonitor monitr) throws CleanupFailedException {
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        Workflow workflow = new Workflow();
        HashMap<String, Object> systemTransformationSlots = this.getSystemTransformationSlots();
        if (this.configuration.isRegenerateSystem()) {
            workflow.addComponent((IWorkflowComponent)new SystemWorkflowComponent(systemTransformationSlots, this.getBasePath()));
        }
        if (this.configuration.isRegenerateAllocation() || this.configuration.isRegenerateSystem()) {
            workflow.addComponent((IWorkflowComponent)new AllocationWorkflowComponent(systemTransformationSlots, this.getBasePath()));
        }
        if (this.configuration.isRegenerateUsage()) {
            workflow.addComponent((IWorkflowComponent)new UsageModelWorkflowComponent(systemTransformationSlots, this.getBasePath()));
        }
        workflow.invoke(null);
    }

    private HashMap<String, Object> getSystemTransformationSlots() {
        HashMap<String, Object> sC2 = new HashMap<String, Object>();
        PCMResourceSetPartition pcmPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition("org.palladiosimulator.pcmmodels.partition");
        sC2.put("system", pcmPartition.getSystem());
        sC2.put("allocation", pcmPartition.getAllocation());
        sC2.put("usage", pcmPartition.getUsageModel());
        return sC2;
    }

    private String getBasePath() {
        String basePath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString()) + "/" + this.configuration.getStoragePluginID() + "/" + "src";
        return basePath;
    }

    public String getName() {
        return "Regenerate SimuCom Plugin Code";
    }
}

