/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucom.rerunsimulation.runconfig;

import de.uka.ipd.sdq.simucom.rerunsimulation.filter.ProjectFilterPattern;
import de.uka.ipd.sdq.workflow.launchconfig.tabs.TabHelper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.analyzer.workflow.ConstantsContainer;

public class GeneratedProjectChooseSimulationTab
extends AbstractLaunchConfigurationTab {
    private Composite container;
    private Text txtGeneratedProject;
    private Text txtBelongsToProject;
    private Text txtAllocationFile;
    private Text txtUsageModelFile;
    private Text txtEventMiddlewareFile;
    private Text txtRepositoryMiddlewareFile;
    private Text txtFeatureConfigFile;
    private Button fileSystemChooser;
    private Button bUsageCheck;
    private Button bAllocationCheck;
    private Button bSystemCheck;

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.container);
        ModifyListener modify = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneratedProjectChooseSimulationTab.this.setDirty(true);
                GeneratedProjectChooseSimulationTab.this.updateLaunchConfigurationDialog();
            }
        };
        MouseAdapter mouse = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                GeneratedProjectChooseSimulationTab.this.setDirty(true);
                GeneratedProjectChooseSimulationTab.this.updateLaunchConfigurationDialog();
            }

            public void mouseDoubleClick(MouseEvent e) {
                GeneratedProjectChooseSimulationTab.this.setDirty(true);
                GeneratedProjectChooseSimulationTab.this.updateLaunchConfigurationDialog();
            }
        };
        Group generatedProjectInputGroup = new Group(this.container, 2048);
        GridLayout glGeneratedProjectInputGroup = new GridLayout();
        glGeneratedProjectInputGroup.numColumns = 2;
        glGeneratedProjectInputGroup.makeColumnsEqualWidth = false;
        generatedProjectInputGroup.setLayout((Layout)glGeneratedProjectInputGroup);
        generatedProjectInputGroup.setText("Choose existing generated project");
        generatedProjectInputGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtGeneratedProject = new Text((Composite)generatedProjectInputGroup, 2052);
        GridData gridDataTextFileName = new GridData(4, 0x1000000, true, false);
        gridDataTextFileName.widthHint = 200;
        this.txtGeneratedProject.setLayoutData((Object)gridDataTextFileName);
        this.txtGeneratedProject.addModifyListener(modify);
        this.fileSystemChooser = new Button((Composite)generatedProjectInputGroup, 0);
        this.fileSystemChooser.setText("Workspace...");
        this.fileSystemChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<ProjectFilterPattern> filters = new ArrayList<ProjectFilterPattern>();
                ProjectFilterPattern filter = new ProjectFilterPattern();
                filter.setPattern("/*");
                filters.add(filter);
                IContainer[] container = WorkspaceResourceDialog.openFolderSelection((Shell)GeneratedProjectChooseSimulationTab.this.getShell(), (String)"Select project to run again", (String)"Select project to run again", (boolean)false, null, filters);
                GeneratedProjectChooseSimulationTab.this.txtGeneratedProject.setText(container[0].getFullPath().toPortableString());
                GeneratedProjectChooseSimulationTab.this.readPropertiesFile(container[0].getFullPath().toPortableString());
            }
        });
        Group gBelongsToProject = new Group(this.container, 2048);
        GridLayout glBelongsToProject = new GridLayout();
        GridData gDBelongsToProject = new GridData(4, 0x1000000, true, false);
        glBelongsToProject.numColumns = 2;
        glBelongsToProject.makeColumnsEqualWidth = false;
        gBelongsToProject.setLayout((Layout)glBelongsToProject);
        gBelongsToProject.setText("Base project information");
        gBelongsToProject.setLayoutData((Object)gDBelongsToProject);
        Label lBelongsToProject = new Label((Composite)gBelongsToProject, 0);
        lBelongsToProject.setText("Base Project");
        this.txtBelongsToProject = new Text((Composite)gBelongsToProject, 2052);
        this.txtBelongsToProject.setLayoutData((Object)gDBelongsToProject);
        this.txtBelongsToProject.setVisible(true);
        this.txtBelongsToProject.setEnabled(false);
        Group gAllocation = new Group(this.container, 2048);
        GridLayout glAllocation = new GridLayout();
        GridData gDAllocation = new GridData(4, 0x1000000, true, false);
        this.txtAllocationFile = new Text((Composite)gAllocation, 2052);
        TabHelper.createFileInputSection((Composite)gAllocation, (ModifyListener)modify, (String)"Allocation File", (String[])ConstantsContainer.ALLOCATION_EXTENSION, (Text)this.txtAllocationFile, (String)"Select Allocation File", (Shell)this.getShell(), (String)"");
        glAllocation.numColumns = 5;
        glAllocation.makeColumnsEqualWidth = false;
        gAllocation.setLayout((Layout)glAllocation);
        gAllocation.setLayoutData((Object)gDAllocation);
        Group gCheckButtons = new Group((Composite)gAllocation, 0);
        gCheckButtons.setLayout((Layout)new GridLayout());
        this.bAllocationCheck = new Button((Composite)gCheckButtons, 32);
        this.bAllocationCheck.setText("Regenerate allocation");
        this.bAllocationCheck.addMouseListener((MouseListener)mouse);
        this.bSystemCheck = new Button((Composite)gCheckButtons, 32);
        this.bSystemCheck.setText("Regenerate system and allocation");
        this.bSystemCheck.addMouseListener((MouseListener)mouse);
        Group gUsage = new Group(this.container, 2048);
        GridLayout glUsage = new GridLayout();
        GridData gDUsage = new GridData(4, 0x1000000, true, false);
        this.txtUsageModelFile = new Text((Composite)gUsage, 2052);
        TabHelper.createFileInputSection((Composite)gUsage, (ModifyListener)modify, (String)"Usage File", (String[])ConstantsContainer.USAGEMODEL_EXTENSION, (Text)this.txtUsageModelFile, (String)"Select Usage File", (Shell)this.getShell(), (String)"");
        glUsage.numColumns = 5;
        glUsage.makeColumnsEqualWidth = false;
        gUsage.setLayout((Layout)glUsage);
        gUsage.setLayoutData((Object)gDUsage);
        this.bUsageCheck = new Button((Composite)gUsage, 32);
        this.bUsageCheck.setText("Regenerate usage model");
        this.bUsageCheck.addMouseListener((MouseListener)mouse);
        Group gModelFiles = new Group(this.container, 2048);
        GridLayout glModelFiles = new GridLayout();
        GridData gDModelFiles = new GridData(4, 0x1000000, true, false);
        glModelFiles.numColumns = 2;
        glModelFiles.makeColumnsEqualWidth = false;
        gModelFiles.setLayout((Layout)glModelFiles);
        gModelFiles.setText("Model Files");
        gModelFiles.setLayoutData((Object)gDModelFiles);
        gModelFiles.setVisible(false);
        Label lEventMiddlewareFile = new Label((Composite)gModelFiles, 0);
        lEventMiddlewareFile.setText("Event Middleware File");
        this.txtEventMiddlewareFile = new Text((Composite)gModelFiles, 2052);
        this.txtEventMiddlewareFile.setLayoutData((Object)gridDataTextFileName);
        lEventMiddlewareFile.setVisible(true);
        this.txtEventMiddlewareFile.setVisible(true);
        this.txtEventMiddlewareFile.setEnabled(false);
        Label lRepositoryMiddlewareFile = new Label((Composite)gModelFiles, 0);
        lRepositoryMiddlewareFile.setText("Repository Middleware File");
        this.txtRepositoryMiddlewareFile = new Text((Composite)gModelFiles, 2052);
        this.txtRepositoryMiddlewareFile.setLayoutData((Object)gridDataTextFileName);
        lRepositoryMiddlewareFile.setVisible(true);
        this.txtRepositoryMiddlewareFile.setVisible(true);
        this.txtRepositoryMiddlewareFile.setEnabled(false);
        Label lFeatureConfigFile = new Label((Composite)gModelFiles, 0);
        lFeatureConfigFile.setText("Feature config file");
        this.txtFeatureConfigFile = new Text((Composite)gModelFiles, 2052);
        this.txtFeatureConfigFile.setLayoutData((Object)gridDataTextFileName);
        lFeatureConfigFile.setVisible(true);
        this.txtFeatureConfigFile.setVisible(true);
        this.txtFeatureConfigFile.setEnabled(false);
    }

    private void readPropertiesFile(String projectPath) {
        Properties prop = new Properties();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath);
        IResource resource = project.findMember("/content.properties");
        try {
            URL url = resource.getLocationURI().toURL();
            prop.load(url.openStream());
            this.txtBelongsToProject.setText(prop.getProperty("baseProjectID"));
            this.txtAllocationFile.setText(prop.getProperty("allocation"));
            this.txtUsageModelFile.setText(prop.getProperty("usagemodel"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("baseProjectID", "");
        configuration.setAttribute("outpath", "org.palladiosimulator.temporary");
        configuration.setAttribute("allocationFile", "");
        configuration.setAttribute("usageFile", "");
        configuration.setAttribute("eventMiddlewareRepositoryFile", "pathmap://PCM_MODELS/default_event_middleware.repository");
        configuration.setAttribute("rmiRepositoryFile", "pathmap://PCM_MODELS/Glassfish.repository");
        configuration.setAttribute("featureConfig", "pathmap://PCM_MODELS/ConnectorConfig.featureconfig");
        configuration.setAttribute("clear", false);
        configuration.setAttribute("simulateAccuracy", false);
        configuration.setAttribute("accuracyQualityAnnotationFile", "");
        configuration.setAttribute("regenerateAllocation", false);
        configuration.setAttribute("regenerateUsage", false);
        configuration.setAttribute("regenerateSystem", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.txtGeneratedProject.setText(configuration.getAttribute("generatedProjectPath", ""));
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        try {
            this.txtBelongsToProject.setText(configuration.getAttribute("baseProjectID", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.txtAllocationFile.setText(configuration.getAttribute("allocationFile", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.bAllocationCheck.setSelection(configuration.getAttribute("regenerateAllocation", false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.bSystemCheck.setSelection(configuration.getAttribute("regenerateSystem", false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.txtUsageModelFile.setText(configuration.getAttribute("usageFile", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.bUsageCheck.setSelection(configuration.getAttribute("regenerateUsage", false));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.txtRepositoryMiddlewareFile.setText(configuration.getAttribute("rmiRepositoryFile", "pathmap://PCM_MODELS/Glassfish.repository"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.txtEventMiddlewareFile.setText(configuration.getAttribute("eventMiddlewareRepositoryFile", "pathmap://PCM_MODELS/default_event_middleware.repository"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            this.txtFeatureConfigFile.setText(configuration.getAttribute("featureConfig", "pathmap://PCM_MODELS/ConnectorConfig.featureconfig"));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("baseProjectID", this.txtBelongsToProject.getText());
        configuration.setAttribute("outpath", this.txtGeneratedProject.getText());
        configuration.setAttribute("generatedProjectPath", this.txtGeneratedProject.getText());
        configuration.setAttribute("allocationFile", this.txtAllocationFile.getText());
        configuration.setAttribute("usageFile", this.txtUsageModelFile.getText());
        configuration.setAttribute("clear", false);
        configuration.setAttribute("simulateAccuracy", false);
        configuration.setAttribute("accuracyQualityAnnotationFile", "");
        configuration.setAttribute("eventMiddlewareRepositoryFile", "pathmap://PCM_MODELS/default_event_middleware.repository");
        configuration.setAttribute("rmiRepositoryFile", "pathmap://PCM_MODELS/Glassfish.repository");
        configuration.setAttribute("featureConfig", "pathmap://PCM_MODELS/ConnectorConfig.featureconfig");
        configuration.setAttribute("regenerateAllocation", this.bAllocationCheck.getSelection());
        configuration.setAttribute("regenerateUsage", this.bUsageCheck.getSelection());
        configuration.setAttribute("regenerateSystem", this.bSystemCheck.getSelection());
    }

    public String getName() {
        return "Rerun Configuration";
    }
}

