/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.errorhandling.dialogs.issues.DisplayIssuesDialog;
import de.uka.ipd.sdq.simucomframework.ExperimentRunner;
import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.probes.TakeCurrentSimulationTimeProbe;
import de.uka.ipd.sdq.simucomframework.resources.IResourceContainerFactory;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimuComStatus;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusFactory;
import de.uka.ipd.sdq.simucomframework.usage.IUserFactory;
import de.uka.ipd.sdq.simucomframework.usage.IWorkloadDriver;
import de.uka.ipd.sdq.simulation.AbstractSimulationConfig;
import de.uka.ipd.sdq.simulation.ISimulationControl;
import de.uka.ipd.sdq.simulation.ISimulationListener;
import de.uka.ipd.sdq.simulation.IStatusObserver;
import de.uka.ipd.sdq.simulation.SimulationResult;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimEngineFactory;
import de.uka.ipd.sdq.simulation.preferences.SimulationPreferencesHelper;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringpointFactory;
import org.palladiosimulator.edp2.models.measuringpoint.StringMeasuringPoint;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.metricspec.util.builder.MetricSetDescriptionBuilder;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.probes.EventProbeList;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.TriggeredProbe;

public abstract class AbstractMain
implements ISimulationControl,
BundleActivator {
    private static final Logger LOGGER = Logger.getLogger((String)AbstractMain.class.getName());
    private ServiceRegistration<ISimulationControl> serviceRegistryEntry;
    private SimuComModel model;
    private SimuComStatus simuComStatus;
    private final MeasuringpointFactory measuringpointFactory = MeasuringpointFactory.eINSTANCE;

    public void start(BundleContext context) throws Exception {
        this.serviceRegistryEntry = context.registerService(ISimulationControl.class, (Object)this, new Hashtable());
    }

    public void stop(BundleContext context) throws Exception {
        this.serviceRegistryEntry.unregister();
    }

    protected SimulationResult run(final IStatusObserver statusObserver, final SimuComConfig config, boolean isRemoteRun) {
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)"Starting Simulation");
            LOGGER.info((Object)("Simulation engine used: " + this.model.getSimulationControl().getClass().getSimpleName()));
        }
        this.model.getConfiguration().addListener(new ISimulationListener(){

            public void simulationStop() {
                AbstractMain.this.model.getProbeFrameworkContext().finish();
                AbstractMain.this.model.getConfiguration().getRecorderConfigurationFactory().finalizeRecorderConfigurationFactory();
            }

            public void simulationStart() {
            }
        });
        this.model.getSimulationControl().addTimeObserver(new Observer(){

            @Override
            public void update(Observable clock, Object data) {
                int timePercent = config.getSimuTime() < 0L ? 0 : (int)(AbstractMain.this.model.getSimulationControl().getCurrentSimulationTime() * 100.0 / (double)config.getSimuTime());
                int measurementsPercent = (int)(AbstractMain.this.model.getMainMeasurementsCount() * 100L / AbstractMain.this.model.getConfiguration().getMaxMeasurementsCount());
                statusObserver.updateStatus(timePercent < measurementsPercent ? measurementsPercent : timePercent, AbstractMain.this.model.getSimulationControl().getCurrentSimulationTime(), AbstractMain.this.model.getMainMeasurementsCount());
            }
        });
        this.getStatus().setCurrentSimulationTime(0.0);
        double simRealTime = ExperimentRunner.run(this.model);
        if (this.model.getIssues().size() > 0) {
            if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
                LOGGER.info((Object)(String.valueOf(this.model.getIssues().size()) + " issues experience during the simulation run."));
            }
            DisplayIssuesDialog runner = new DisplayIssuesDialog(this.model.getIssues());
            DisplayIssuesDialog.showDialogSync((DisplayIssuesDialog)runner);
        }
        if (LOGGER.isEnabledFor((Priority)Level.INFO)) {
            LOGGER.info((Object)("Simulation stopped. It took " + simRealTime / Math.pow(10.0, 9.0) + " seconds real time to terminate"));
        }
        this.model.getConfiguration().disposeRandomGenerator();
        return this.model.getErrorStatus();
    }

    protected void stop() {
        this.model.getSimulationControl().stop();
    }

    public SimuComModel getModel() {
        return this.model;
    }

    public Throwable getErrorThrowable() {
        return this.model.getErrorThrowable();
    }

    public void prepareSimulation(AbstractSimulationConfig config, IStatusObserver observer, boolean isRemoteRun) {
        ISimEngineFactory factory = SimulationPreferencesHelper.getPreferredSimulationEngine();
        if (factory == null) {
            throw new RuntimeException("There is no simulation engine available. Install at least one engine.");
        }
        this.model = new SimuComModel((SimuComConfig)config, this.getStatus(), factory, isRemoteRun);
        this.model.initialiseResourceContainer(this.getResourceContainerFactory());
        IWorkloadDriver[] workloadDrivers = this.getWorkloads((SimuComConfig)config);
        this.attachUsageResponseTimeCalculators(workloadDrivers);
        this.model.setUsageScenarios(workloadDrivers);
        if (this.model.getConfiguration().getSimulateFailures()) {
            StringMeasuringPoint mp = this.measuringpointFactory.createStringMeasuringPoint();
            mp.setMeasuringPoint("System execution results");
            MeasuringPointRepository myMeasurementPointRepository = MeasuringpointFactory.eINSTANCE.createMeasuringPointRepository();
            myMeasurementPointRepository.getMeasuringPoints().add((Object)mp);
            mp.setMeasuringPointRepository(myMeasurementPointRepository);
            MetricSetDescription metricSetDescription = MetricSetDescriptionBuilder.newMetricSetDescriptionBuilder().name("Execution Result Over Time").textualDescription("This metric records execution results over time, i.e., tuples of (execution result, point in time").id(EcoreUtil.generateUUID()).subsumedMetrics(Arrays.asList(this.model.getFailureStatistics().getExecutionResultProbe().getMetricDesciption(), MetricDescriptionConstants.POINT_IN_TIME_METRIC)).build();
            this.model.getProbeFrameworkContext().getCalculatorFactory().buildExecutionResultCalculator((MeasuringPoint)mp, (Probe)new EventProbeList((MetricDescription)metricSetDescription, this.model.getFailureStatistics().getExecutionResultProbe(), Arrays.asList(new TriggeredProbe[]{new TakeCurrentSimulationTimeProbe(this.model.getSimulationControl())})));
        }
    }

    private void attachUsageResponseTimeCalculators(IWorkloadDriver[] workloadDrivers) {
        IWorkloadDriver[] iWorkloadDriverArray = workloadDrivers;
        int n = workloadDrivers.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkloadDriver driver = iWorkloadDriverArray[n2];
            IUserFactory userFactory = driver.getUserFactory();
            Calculator calculator = userFactory.attachResponseTimeCalculator();
            if (ExperimentRunner.confidenceStopCondition != null) {
                calculator.addObserver((IMeasurementSourceListener)ExperimentRunner.confidenceStopCondition);
            }
            ++n2;
        }
    }

    public SimulationResult startSimulation(AbstractSimulationConfig config, IStatusObserver observer, boolean isRemoteRun) {
        return this.run(observer, (SimuComConfig)config, isRemoteRun);
    }

    public void stopSimulation() {
        this.stop();
    }

    protected abstract IWorkloadDriver[] getWorkloads(SimuComConfig var1);

    protected abstract IResourceContainerFactory getResourceContainerFactory();

    public SimuComStatus getStatus() {
        if (this.simuComStatus == null) {
            this.simuComStatus = SimucomstatusFactory.eINSTANCE.createSimuComStatus();
            this.simuComStatus.setProcessStatus(SimucomstatusFactory.eINSTANCE.createSimulatedProcesses());
            this.simuComStatus.setResourceStatus(SimucomstatusFactory.eINSTANCE.createSimulatedResources());
        }
        return this.simuComStatus;
    }
}

