/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.scheduler.IPassiveResource;
import de.uka.ipd.sdq.simucomframework.ResourceRegistry;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.exceptions.ResourceContainerNotFound;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedLinkingResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.SimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import java.util.HashMap;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;

public abstract class Context
extends StackContext {
    private static final long serialVersionUID = -1869414754329617190L;
    private ResourceRegistry registry = null;
    private final HashMap<String, AbstractSimulatedResourceContainer> assemblyLinkHash = new HashMap();
    private final HashMap<String, IPassiveResource> assemblyPassiveResourceHash = new HashMap();
    private SimuComSimProcess myThread = null;
    private SimuComModel myModel = null;

    public Context(SimuComModel myModel) {
        if (myModel != null) {
            this.registry = myModel.getResourceRegistry();
            this.myModel = myModel;
            this.initialiseAssemblyContextLookup();
        } else {
            this.stack.createAndPushNewStackFrame();
        }
    }

    public long getSessionId() {
        return this.myThread.getCurrentSessionId();
    }

    public AbstractSimulatedResourceContainer findResource(String assemblyContextID) {
        AbstractSimulatedResourceContainer container = this.assemblyLinkHash.get(assemblyContextID);
        if (container == null) {
            throw new ResourceContainerNotFound("Resource container for assembly context " + assemblyContextID + " not found. Check your allocation model. " + "Note that a SubSystem must only be used once in one System, using one several times may cause this error. ");
        }
        return container;
    }

    public SimulatedLinkingResourceContainer findLinkingResource(String linkingResourceContainerID) {
        AbstractSimulatedResourceContainer container = this.registry.getResourceContainer(linkingResourceContainerID);
        if (container == null || !(container instanceof SimulatedLinkingResourceContainer)) {
            throw new ResourceContainerNotFound("Linking resource container for container ID " + linkingResourceContainerID + " not found.");
        }
        return (SimulatedLinkingResourceContainer)container;
    }

    protected void linkAssemblyContextAndResourceContainer(String assemblyContextID, String resourceContainerID) {
        assert (this.registry.containsResourceContainer(resourceContainerID));
        AbstractSimulatedResourceContainer container = this.registry.getResourceContainer(resourceContainerID);
        this.assemblyLinkHash.put(assemblyContextID, container);
    }

    public IPassiveResource getPassiveRessourceInContext(String resourceURI, AssemblyContext assemblyContext, AbstractSimulatedResourceContainer resourceContainer, long capacity) {
        PassiveResource resource = (PassiveResource)EMFLoadHelper.loadAndResolveEObject((String)resourceURI);
        IPassiveResource pr = this.assemblyPassiveResourceHash.get(String.valueOf(assemblyContext.getId()) + resource.getId());
        if (pr == null) {
            pr = ((SimulatedResourceContainer)resourceContainer).createPassiveResource(resource, assemblyContext, capacity);
            this.assemblyPassiveResourceHash.put(String.valueOf(assemblyContext.getId()) + resource.getId(), pr);
        }
        return pr;
    }

    protected abstract void initialiseAssemblyContextLookup();

    public SimuComSimProcess getThread() {
        return this.myThread;
    }

    public void setSimProcess(SimuComSimProcess process) {
        this.myThread = process;
    }

    public SimuComModel getModel() {
        return this.myModel;
    }
}

