/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework;

import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.stopcondition.ConfidenceStopCondition;
import de.uka.ipd.sdq.simucomframework.stopcondition.MaxMeasurementsStopCondition;
import de.uka.ipd.sdq.simulation.abstractsimengine.SimCondition;
import de.uka.ipd.sdq.statistics.IBatchAlgorithm;
import de.uka.ipd.sdq.statistics.PhiMixingBatchAlgorithm;
import de.uka.ipd.sdq.statistics.StaticBatchAlgorithm;
import de.uka.ipd.sdq.statistics.estimation.IConfidenceEstimator;
import de.uka.ipd.sdq.statistics.estimation.SampleMeanEstimator;
import org.apache.log4j.Logger;

public class ExperimentRunner {
    private static final Logger LOGGER = Logger.getLogger((String)ExperimentRunner.class.getName());
    private static final double ONE_HUNDERT_PERCENT = 100.0;
    public static ConfidenceStopCondition confidenceStopCondition = null;

    public static double run(SimuComModel model, long simTime) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Setting up experiment runner");
        }
        ExperimentRunner.setupStopConditions(model);
        double startTime = System.nanoTime();
        model.getSimulationControl().start();
        return (double)System.nanoTime() - startTime;
    }

    public static double run(SimuComModel model) {
        return ExperimentRunner.run(model, model.getConfiguration().getSimuTime());
    }

    private static void setupStopConditions(SimuComModel model) {
        boolean hasStopCondition = false;
        hasStopCondition |= ExperimentRunner.setupMaximumSimulationTimeStopCondition(model);
        hasStopCondition |= ExperimentRunner.setupMaximumMeasurementsStopCondition(model);
        if (!(hasStopCondition |= ExperimentRunner.setupConfidenceIntervalStopCondition(model))) {
            throw new RuntimeException("No stop condition configured. No simulation is executed");
        }
    }

    private static boolean setupConfidenceIntervalStopCondition(SimuComModel model) {
        if (ExperimentRunner.isConfidenceIntervalStopConditionEnabled(model)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Enabling simulation stop condition for confidence intervals");
            }
            double level = (double)model.getConfiguration().getConfidenceLevel() / 100.0;
            double halfWidth = (double)model.getConfiguration().getConfidenceHalfWidth() / 100.0;
            PhiMixingBatchAlgorithm batchAlgorithm = null;
            if (model.getConfiguration().isAutomaticBatches()) {
                batchAlgorithm = new PhiMixingBatchAlgorithm();
            } else {
                int batchSize = model.getConfiguration().getBatchSize();
                int minNumberOfBatches = model.getConfiguration().getMinNumberOfBatches();
                batchAlgorithm = new StaticBatchAlgorithm(batchSize, minNumberOfBatches);
            }
            confidenceStopCondition = new ConfidenceStopCondition(model, (IBatchAlgorithm)batchAlgorithm, (IConfidenceEstimator)new SampleMeanEstimator(), level, halfWidth);
            model.getSimulationControl().addStopCondition((SimCondition)confidenceStopCondition);
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Deactivating confidence interval stop condition per user request");
        }
        return false;
    }

    private static boolean isConfidenceIntervalStopConditionEnabled(SimuComModel model) {
        return model.getConfiguration().isUseConfidence();
    }

    private static boolean setupMaximumMeasurementsStopCondition(SimuComModel model) {
        if (ExperimentRunner.isMaximumMeasurementsStopConditionEnabled(model)) {
            long maxMeasurementsCount = model.getConfiguration().getMaxMeasurementsCount();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Enabling simulation stop condition at maximum measurements count of " + maxMeasurementsCount));
            }
            model.getSimulationControl().addStopCondition((SimCondition)new MaxMeasurementsStopCondition(model));
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Deactivating maximum measurements count stop condition per user request");
        }
        return false;
    }

    private static boolean isMaximumMeasurementsStopConditionEnabled(SimuComModel model) {
        return model.getConfiguration().getMaxMeasurementsCount() > 0L;
    }

    private static boolean setupMaximumSimulationTimeStopCondition(SimuComModel model) {
        if (ExperimentRunner.isMaximumSimulationTimeStopConditionEnabled(model)) {
            long simTime = model.getConfiguration().getSimuTime();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Enabling simulation stop condition at maximum simulation time of " + simTime));
            }
            model.getSimulationControl().setMaxSimTime(simTime);
            return true;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Deactivating maximum simulation time stop condition per user request");
        }
        return false;
    }

    private static boolean isMaximumSimulationTimeStopConditionEnabled(SimuComModel model) {
        return model.getConfiguration().getSimuTime() > 0L;
    }
}

