/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.fork;

import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.fork.ForkedBehaviourProcess;
import org.apache.log4j.Logger;

public class ForkExecutor {
    private final ForkedBehaviourProcess[] forks;
    private final SimuComSimProcess parent;
    private static final Logger LOGGER = Logger.getLogger((String)ForkExecutor.class.getName());

    public ForkExecutor(SimuComSimProcess parent, ForkedBehaviourProcess[] forks) {
        this.forks = forks;
        this.parent = parent;
    }

    public void run() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Running parallel operations");
        }
        double start = this.parent.getModel().getSimulationControl().getCurrentSimulationTime();
        ForkedBehaviourProcess[] forkedBehaviourProcessArray = this.forks;
        int n = this.forks.length;
        int n2 = 0;
        while (n2 < n) {
            ForkedBehaviourProcess p = forkedBehaviourProcessArray[n2];
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("scheduling child forked behaviour process " + p.getId() + " at time 0"));
            }
            p.scheduleAt(0.0);
            ++n2;
        }
        while (this.checkIfRemainingChildrenRun()) {
            this.parent.passivate();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Forks took: " + (this.parent.getModel().getSimulationControl().getCurrentSimulationTime() - start)));
        }
    }

    private boolean checkIfRemainingChildrenRun() {
        ForkedBehaviourProcess[] forkedBehaviourProcessArray = this.forks;
        int n = this.forks.length;
        int n2 = 0;
        while (n2 < n) {
            ForkedBehaviourProcess p = forkedBehaviourProcessArray[n2];
            if (!p.isAsync() && !p.isTerminated()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

